/*
 * Decompiled with CFR 0.152.
 */
package vib;

import distance.Euclidean;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import math3d.Point3d;
import vib.AugmentedLandmarkWarp_;
import vib.BenesNamedPoint;
import vib.FastMatrix;
import vib.InterpolatedImage;
import vib.PointList;
import vib.RigidRegistration;
import vib.TransformedImage;
import vib.VIB;

public class LocalRigidRegistration_
implements PlugInFilter {
    private ImagePlus image;

    public void run(ImageProcessor ip) {
        int[] wIDs = WindowManager.getIDList();
        if (wIDs == null) {
            IJ.error((String)"No images open");
            return;
        }
        String[] titles = new String[wIDs.length];
        for (int i = 0; i < wIDs.length; ++i) {
            titles[i] = WindowManager.getImage((int)wIDs[i]).getTitle();
        }
        GenericDialog gd = new GenericDialog("Registration parameters");
        gd.addChoice("Template", titles, WindowManager.getCurrentImage().getTitle());
        gd.addChoice("Image", titles, titles[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        ImagePlus templ = WindowManager.getImage((String)gd.getNextChoice());
        this.image = WindowManager.getImage((String)gd.getNextChoice());
        TransformedImage trans = new TransformedImage(templ, this.image);
        trans.measure = new Euclidean();
        try {
            RigidRegistration r = new RigidRegistration();
            FastMatrix global = r.rigidRegistration(trans, null, null, -1, -1, false, 4, 2, 1.0, 1, true, true, false, null);
            PointList pl_image = PointList.load((ImagePlus)this.image);
            PointList pl_template = PointList.load((ImagePlus)templ);
            if (pl_image == null || pl_template == null) {
                IJ.error((String)"Landmarks could not be loaded. Abort");
            }
            PointList commonPoints = PointList.pointsInBoth((PointList)pl_image, (PointList)pl_template);
            int n_landmarks = commonPoints.size();
            System.out.println("Number of landmarks: " + n_landmarks);
            if (n_landmarks == 0) {
                IJ.error((String)"No common landmarks. Abort");
            }
            VIB.println((String)("Common landmarks:\n" + commonPoints));
            String initial = global.toStringForAmira();
            FastMatrix[] transformations = new FastMatrix[n_landmarks];
            for (int i = 0; i < n_landmarks; ++i) {
                BenesNamedPoint p = commonPoints.get(i);
                System.out.println("LANDMARK " + p);
                String bb = p.x + " " + p.y + " " + p.z + " " + (p.x - 50.0) + " " + (p.y - 50.0) + " " + (p.z - 50.0) + " " + (p.x + 50.0) + " " + (p.y + 50.0) + " " + (p.z + 50.0);
                transformations[i] = new RigidRegistration().rigidRegistration(trans, bb, initial, -1, -1, false, 4, 2, 1.0, 1, false, false, false, null);
            }
            AugmentedLandmarkWarp_ aw = new AugmentedLandmarkWarp_();
            aw.setCenter((Point3d[])commonPoints.toArray());
            aw.matrix = transformations;
            aw.ii = new InterpolatedImage(templ);
            aw.model = new InterpolatedImage(this.image);
            aw.run();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 3;
    }
}

