/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.Iterator;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;

public class ColumnView<N extends Number>
implements Access1D<N>,
Iterator<ColumnView<N>> {
    private long myColumn = -1L;
    private final Access2D<N> myDelegate2D;
    private final long myLastColumn;
    final Iterable<ColumnView<N>> iterable = () -> this;

    public static <S extends Number> Iterable<ColumnView<S>> makeIterable(Access2D<S> access) {
        return new ColumnView<S>(access).iterable;
    }

    protected ColumnView(Access2D<N> access) {
        this(access, -1L);
    }

    ColumnView(Access2D<N> access, long column) {
        this.myDelegate2D = access;
        this.myLastColumn = access.countColumns() - 1L;
        this.myColumn = column;
    }

    public long column() {
        return this.myColumn;
    }

    @Override
    public long count() {
        return this.myDelegate2D.countRows();
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegate2D.doubleValue(index, this.myColumn);
    }

    @Override
    public N get(long index) {
        return this.myDelegate2D.get(index, this.myColumn);
    }

    @Override
    public boolean hasNext() {
        return this.myColumn < this.myLastColumn;
    }

    public boolean hasPrevious() {
        return this.myColumn > 0L;
    }

    @Override
    public ColumnView<N> next() {
        ++this.myColumn;
        return this;
    }

    public ColumnView<N> previous() {
        --this.myColumn;
        return this;
    }

    @Override
    public void remove() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    protected void setColumn(long column) {
        this.myColumn = column;
    }
}

