/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.AbstractMatrix;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.scalar.Quaternion;

public final class QuaternionMatrix
extends AbstractMatrix<Quaternion, QuaternionMatrix> {
    public static final BasicMatrix.Factory<QuaternionMatrix> FACTORY = new MatrixFactory<Quaternion, QuaternionMatrix>(QuaternionMatrix.class, GenericDenseStore.QUATERNION);

    QuaternionMatrix(MatrixStore<Quaternion> aStore) {
        super(aStore);
    }

    @Override
    ElementsSupplier<Quaternion> cast(Access1D<?> matrix) {
        if (matrix instanceof QuaternionMatrix) {
            return ((QuaternionMatrix)matrix).getStore();
        }
        if (matrix instanceof GenericDenseStore) {
            return (GenericDenseStore)matrix;
        }
        if (matrix instanceof ElementsSupplier && matrix.count() > 0L && matrix.get(0L) instanceof Quaternion) {
            return (ElementsSupplier)((Object)matrix);
        }
        if (matrix instanceof Access2D) {
            Access2D tmpAccess2D = (Access2D)matrix;
            return this.getStore().physical().builder().makeWrapper(tmpAccess2D);
        }
        return (ElementsSupplier)this.getStore().physical().columns(matrix);
    }

    @Override
    DeterminantTask<Quaternion> getDeterminantTask(MatrixStore<Quaternion> template) {
        return DeterminantTask.QUATERNION.make(template, this.isHermitian(), false);
    }

    @Override
    MatrixFactory<Quaternion, QuaternionMatrix> getFactory() {
        return (MatrixFactory)FACTORY;
    }

    @Override
    InverterTask<Quaternion> getInverterTask(MatrixStore<Quaternion> template) {
        return InverterTask.QUATERNION.make(template, this.isHermitian(), false);
    }

    @Override
    SolverTask<Quaternion> getSolverTask(MatrixStore<Quaternion> templateBody, Access2D<?> templateRHS) {
        return SolverTask.QUATERNION.make(templateBody, templateRHS, this.isHermitian(), false);
    }
}

