/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

public interface Label {
    public static final long BACKGROUND = 0L;
    public static final long TRANSPARENT = -1L;
    public static final long INVALID = -2L;
    public static final long OUTSIDE = -3L;
    public static final long MAX_ID = -4L;

    public static boolean regular(long id) {
        return Label.max(id, -4L) == -4L;
    }

    public static boolean isForeground(long id) {
        return Label.regular(id) && id != 0L;
    }

    public static long max(long a, long b) {
        return a + Long.MIN_VALUE > b + Long.MIN_VALUE ? a : b;
    }

    public long id();

    public static enum ReservedValue {
        BACKGROUND(0L),
        TRANSPARENT(-1L),
        INVALID(-2L),
        OUTSIDE(-3L),
        MAX_ID(-4L);

        private final long value;

        private ReservedValue(long value) {
            this.value = value;
        }

        public long id() {
            return this.value;
        }

        public ReservedValue fromString(String str) {
            try {
                return ReservedValue.valueOf(str.toUpperCase());
            }
            catch (IllegalArgumentException | NullPointerException e) {
                return null;
            }
        }

        public ReservedValue fromId(long id) {
            for (ReservedValue rv : ReservedValue.values()) {
                if (rv.value != id) continue;
                return rv;
            }
            return null;
        }
    }
}

