/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.localThickness;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import java.util.ArrayList;

public class MaskThicknessMapWithOriginal {
    public int threshold = 128;
    public boolean inverse = false;
    private ImagePlus resultImage = null;

    public ImagePlus trimOverhang(ImagePlus original, ImagePlus thicknessMap) {
        if (original == null || thicknessMap == null) {
            throw new NullPointerException("Images must not be null");
        }
        if (original.getBitDepth() != 8 || thicknessMap.getBitDepth() != 32) {
            throw new IllegalArgumentException("One or both of the images have the wrong bit depth");
        }
        int w = original.getWidth();
        int h = original.getHeight();
        int d = original.getImageStackSize();
        if (w != thicknessMap.getWidth() || h != thicknessMap.getHeight() || d != thicknessMap.getImageStackSize()) {
            throw new IllegalArgumentException("The dimensions of the images do not match");
        }
        this.resultImage = thicknessMap.duplicate();
        this.resultImage.setTitle(thicknessMap.getTitle() + "_MASK");
        ImageStack originalStack = original.getImageStack();
        ImageStack resultStack = this.resultImage.getImageStack();
        ArrayList<Integer> sliceNumbers = new ArrayList<Integer>();
        for (int z2 = 1; z2 <= d; ++z2) {
            sliceNumbers.add(z2);
        }
        sliceNumbers.parallelStream().forEach(z -> {
            IJ.showStatus((String)"Masking thickness map...");
            ImageProcessor originalProcessor = originalStack.getProcessor(z.intValue());
            ImageProcessor resultProcessor = resultStack.getProcessor(z.intValue());
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int value = originalProcessor.get(x, y);
                    if ((value >= this.threshold || this.inverse) && (value < this.threshold || !this.inverse)) continue;
                    resultProcessor.set(x, y, 0);
                }
            }
        });
        return this.getResultImage();
    }

    public ImagePlus getResultImage() {
        return this.resultImage;
    }

    public void purge() {
        this.resultImage = null;
    }
}

