/*
 * Decompiled with CFR 0.152.
 */
package spimopener;

import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Combine_SPIM_Projects
implements PlugIn {
    public void run(String arg) {
        GenericDialogPlus gd = new GenericDialogPlus("Combine SPIM Projects");
        gd.addMessage("This copies all files from <source> \nto <target> if they do not exist yet");
        gd.addDirectoryField("Source Folder", "");
        gd.addDirectoryField("Target Folder", "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        File source = new File(gd.getNextString());
        File target = new File(gd.getNextString());
        if (!source.exists()) {
            IJ.error((String)(source + " does not exist"));
            return;
        }
        if (!target.exists() && !target.mkdir()) {
            IJ.error((String)(target + " does not exist and cannot be created"));
            return;
        }
        try {
            this.copy(source, target);
        }
        catch (Exception e) {
            IJ.showMessage((String)"Error copying");
            e.printStackTrace();
        }
    }

    public void copy(File source, File target) throws IOException {
        File[] files = source.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            File newf = new File(target, f.getName());
            if (f.isDirectory()) {
                if (!newf.exists()) {
                    newf.mkdir();
                }
                this.copy(f, newf);
                continue;
            }
            if (newf.exists()) {
                IJ.log((String)("Not copying " + newf + " because is exists already"));
                continue;
            }
            this.copySingleFile(f, newf);
        }
    }

    public void copySingleFile(File from, File to) throws IOException {
        int length = (int)from.length();
        byte[] contents = new byte[length];
        FileInputStream in = new FileInputStream(from);
        for (int read = 0; read < contents.length; read += in.read(contents, read, contents.length - read)) {
        }
        in.close();
        FileOutputStream out = new FileOutputStream(to);
        out.write(contents);
        out.close();
    }
}

