/*
 * Decompiled with CFR 0.152.
 */
package spimopener;

import fiji.util.gui.GenericDialogPlus;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import spimopener.DoubleSlider;

public class OpenerGenericDialog
extends GenericDialogPlus {
    private static final long serialVersionUID = 1L;
    private ActionListener listener;
    private List<DoubleSlider> doubleSliders = new ArrayList<DoubleSlider>();
    private int cIdx = 0;
    private Button okButton;

    public OpenerGenericDialog(String title) {
        super(title);
    }

    public OpenerGenericDialog(String title, Frame parent) {
        super(title, parent);
    }

    public void setActionListener(ActionListener l) {
        this.listener = l;
    }

    public void showDialog() {
        super.showDialog();
        Button[] buttons = this.getButtons();
        this.okButton = buttons[0];
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton && this.listener != null) {
            this.listener.actionPerformed(e);
        } else {
            super.actionPerformed(e);
        }
    }

    public DoubleSlider getNextDoubleSlider() {
        return this.doubleSliders.get(this.cIdx++);
    }

    public List<DoubleSlider> getDoubleSliders() {
        return this.doubleSliders;
    }

    public void addChoice(String label, String[] choice) {
        super.addChoice(label, choice, choice[0]);
    }

    public void addDoubleSlider(String label, int min, int max) {
        this.addDoubleSlider(label, min, max, min, max);
    }

    public void addDoubleSlider(String label, int min, int max, int cmin, int cmax) {
        DoubleSlider slider = new DoubleSlider(min, max, cmin, cmax);
        this.doubleSliders.add(slider);
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        GridBagConstraints c = this.getConstraints();
        Label theLabel = new Label(label);
        c.gridx = 0;
        c.anchor = 13;
        c.gridwidth = 1;
        layout.setConstraints(theLabel, c);
        this.add(theLabel);
        ++c.gridx;
        c.fill = 1;
        c.weightx = 1.0;
        layout.setConstraints(slider, c);
        this.add(slider);
    }

    public static void main(String[] args) {
        OpenerGenericDialog gd = new OpenerGenericDialog("GenericDialogOpener Test");
        gd.addDoubleSlider("range", 1, 4, 1, 4);
        gd.addNumericField("lkjl", 0.0, 3);
        gd.showDialog();
    }
}

