/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.list.ListImgFactory;
import net.imglib2.ops.img.BinaryOperationAssignment;
import net.imglib2.ops.img.UnaryOperationAssignment;
import net.imglib2.ops.operation.BinaryOperation;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.img.unary.ImgCopyOperation;
import net.imglib2.ops.operation.randomaccessibleinterval.unary.GrayscaleReconstructionByDilation;
import net.imglib2.ops.operation.real.binary.RealSubtract;
import net.imglib2.ops.types.ConnectedType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

@Deprecated
public class HDomeTransformation<T extends RealType<T>>
implements UnaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> {
    private final ConnectedType m_type;
    private final double m_height;
    private final double m_substractBefore;
    private final ImgFactory<T> m_imgFactory;

    @Deprecated
    public HDomeTransformation(ConnectedType type, double height, double substractBefore) {
        this.m_type = type;
        this.m_height = height;
        this.m_substractBefore = substractBefore;
        this.m_imgFactory = new ListImgFactory();
    }

    public HDomeTransformation(ConnectedType type, double height, double substractBefore, ImgFactory imgFactory) {
        this.m_type = type;
        this.m_height = height;
        this.m_substractBefore = substractBefore;
        this.m_imgFactory = imgFactory;
    }

    @Override
    public RandomAccessibleInterval<T> compute(RandomAccessibleInterval<T> input, RandomAccessibleInterval<T> output) {
        if (this.m_substractBefore > 0.0) {
            Img noSingular = this.m_imgFactory.create(input, (Object)((RealType)Views.iterable(input).firstElement()).createVariable());
            this.getRegionalMaxima(input, this.m_substractBefore, (RandomAccessibleInterval<T>)noSingular);
            input = this.subtract(input, (RandomAccessibleInterval<T>)noSingular);
        }
        if (this.m_height > 0.0) {
            output = this.getRegionalMaxima(input, this.m_height, output);
        } else {
            new ImgCopyOperation().compute(Views.iterable(input), Views.iterable(output));
        }
        return output;
    }

    @Override
    public UnaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> copy() {
        return new HDomeTransformation<T>(this.m_type, this.m_height, this.m_substractBefore, this.m_imgFactory);
    }

    private RandomAccessibleInterval<T> getRegionalMaxima(RandomAccessibleInterval<T> img, double height, RandomAccessibleInterval<T> output) {
        SubstractConstantOp op = new SubstractConstantOp(height);
        op.compute(img, output);
        GrayscaleReconstructionByDilation<T, T> op2 = new GrayscaleReconstructionByDilation<T, T>(this.m_type);
        output = op2.compute(img, output);
        return this.subtract(img, output);
    }

    private RandomAccessibleInterval<T> subtract(RandomAccessibleInterval<T> minuend, RandomAccessibleInterval<T> subtrahend) {
        SubstractImgFromImgOp subtract = new SubstractImgFromImgOp();
        subtract.compute(minuend, subtrahend, subtrahend);
        return subtrahend;
    }

    private class SubstractImgFromImgOp
    implements BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> {
        private SubstractImgFromImgOp() {
        }

        @Override
        public RandomAccessibleInterval<T> compute(RandomAccessibleInterval<T> input1, RandomAccessibleInterval<T> input2, RandomAccessibleInterval<T> output) {
            new BinaryOperationAssignment(new RealSubtract()).compute(Views.iterable(input1), Views.iterable(input2), Views.iterable(output));
            return output;
        }

        @Override
        public BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> copy() {
            return new SubstractImgFromImgOp();
        }
    }

    private class RealSubtractConstantBounded<I extends RealType<I>>
    implements UnaryOperation<I, I> {
        private final double constant;

        public RealSubtractConstantBounded(double constant) {
            this.constant = constant;
        }

        @Override
        public I compute(I input, I output) {
            double val = Math.max(output.getMinValue(), input.getRealDouble() - this.constant);
            output.setReal(val);
            return output;
        }

        @Override
        public UnaryOperation<I, I> copy() {
            return new RealSubtractConstantBounded<I>(this.constant);
        }
    }

    private class SubstractConstantOp
    implements UnaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> {
        private final double height;

        public SubstractConstantOp(double height) {
            this.height = height;
        }

        @Override
        public RandomAccessibleInterval<T> compute(RandomAccessibleInterval<T> input, RandomAccessibleInterval<T> output) {
            new UnaryOperationAssignment(new RealSubtractConstantBounded(this.height)).compute(Views.iterable(input), Views.iterable(output));
            return output;
        }

        @Override
        public UnaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> copy() {
            return new SubstractConstantOp(this.height);
        }
    }
}

