/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Plugin;

@Plugin(type=DataType.class)
public class DataType12BitUnsignedInteger
extends AbstractContextual
implements DataType<Unsigned12BitType> {
    private final Unsigned12BitType type = new Unsigned12BitType();

    @Override
    public Unsigned12BitType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "12-bit uint";
    }

    @Override
    public String longName() {
        return "12-bit unsigned integer";
    }

    @Override
    public String description() {
        return "An integer data type ranging between 0 and 4095";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public void lowerBound(Unsigned12BitType dest) {
        dest.set(0L);
    }

    @Override
    public void upperBound(Unsigned12BitType dest) {
        dest.set(4095L);
    }

    @Override
    public int bitCount() {
        return 12;
    }

    @Override
    public Unsigned12BitType createVariable() {
        return new Unsigned12BitType();
    }

    @Override
    public void cast(Unsigned12BitType val, BigComplex dest) {
        dest.setReal(val.get());
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, Unsigned12BitType dest) {
        this.setLong(dest, val.getReal().longValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return true;
    }

    @Override
    public boolean hasLongRepresentation() {
        return true;
    }

    @Override
    public double asDouble(Unsigned12BitType val) {
        return val.get();
    }

    @Override
    public long asLong(Unsigned12BitType val) {
        return val.get();
    }

    @Override
    public void setDouble(Unsigned12BitType val, double v) {
        this.setLong(val, (long)v);
    }

    @Override
    public void setLong(Unsigned12BitType val, long v) {
        if (v < 0L) {
            val.set(0L);
        } else if (v > 4095L) {
            val.set(4095L);
        } else {
            val.set((long)((short)v));
        }
    }
}

