/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imagej.types.PreciseFixedFloatType;
import org.scijava.AbstractContextual;

public class DataTypeVariableBitSignedFloat
extends AbstractContextual
implements DataType<PreciseFixedFloatType> {
    private PreciseFixedFloatType type = new PreciseFixedFloatType();

    @Override
    public PreciseFixedFloatType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "Fixed float";
    }

    @Override
    public String longName() {
        return "Fixed point float";
    }

    @Override
    public String description() {
        return "A float data type whose size is unrestricted and precise to 25 decimal places";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public void lowerBound(PreciseFixedFloatType dest) {
        throw new UnsupportedOperationException("This data type is unbounded");
    }

    @Override
    public void upperBound(PreciseFixedFloatType dest) {
        throw new UnsupportedOperationException("This data type is unbounded");
    }

    @Override
    public int bitCount() {
        return -1;
    }

    @Override
    public PreciseFixedFloatType createVariable() {
        return new PreciseFixedFloatType();
    }

    @Override
    public void cast(PreciseFixedFloatType val, BigComplex dest) {
        dest.setReal(val.get());
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, PreciseFixedFloatType dest) {
        dest.set(val.getReal());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return false;
    }

    @Override
    public boolean hasLongRepresentation() {
        return false;
    }

    @Override
    public double asDouble(PreciseFixedFloatType val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong(PreciseFixedFloatType val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(PreciseFixedFloatType val, double v) {
        val.set(v);
    }

    @Override
    public void setLong(PreciseFixedFloatType val, long v) {
        val.set(v);
    }
}

