/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.tac.expressions.CallExpression;
import org.renjin.compiler.ir.tac.expressions.Elipses;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.ExpressionVisitor;
import org.renjin.compiler.ir.tac.expressions.IRThunk;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.runtime.VariablePromise;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.Closure;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class DynamicCall
implements CallExpression {
    private SEXP functionSexp;
    private Expression functionExpr;
    private FunctionCall call;
    private final List<Expression> arguments;
    private final List<SEXP> argumentNames;
    private final String[] argumentNamesArray;
    private int elipsesIndex;

    public DynamicCall(FunctionCall call2, Expression function2, List<SEXP> argumentNames, List<Expression> arguments) {
        int i;
        this.call = call2;
        this.functionSexp = call2.getFunction();
        this.functionExpr = function2;
        this.arguments = arguments;
        this.argumentNames = argumentNames;
        this.argumentNamesArray = new String[argumentNames.size()];
        for (i = 0; i != argumentNames.size(); ++i) {
            if (!(argumentNames.get(i) instanceof Symbol)) continue;
            this.argumentNamesArray[i] = ((Symbol)argumentNames.get(i)).getPrintName();
        }
        this.elipsesIndex = -1;
        for (i = 0; i != arguments.size(); ++i) {
            if (arguments.get(i) != Elipses.INSTANCE) continue;
            this.elipsesIndex = i;
        }
    }

    public FunctionCall getCall() {
        return this.call;
    }

    public Expression getFunction() {
        return this.functionExpr;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public Object retrieveValue(Context context, Object[] temps) {
        org.renjin.sexp.Function functionValue = this.findFunction(context, temps);
        if (!this.hasElipses() && functionValue instanceof BuiltinFunction) {
            return ((BuiltinFunction)functionValue).apply(context, context.getEnvironment(), this.call, this.argumentNamesArray, this.evaluateArgs(context, temps));
        }
        if (functionValue instanceof Closure) {
            PairList.Builder args2 = new PairList.Builder();
            int argNameIndex = 0;
            for (Expression argument : this.arguments) {
                if (argument instanceof Elipses) {
                    SEXP elipses = context.getEnvironment().findVariable(Symbols.ELLIPSES);
                    args2.addAll((PairList)elipses);
                    continue;
                }
                if (argument instanceof IRThunk) {
                    if (argument.getSExpression() instanceof Symbol) {
                        args2.add(this.argumentNames.get(argNameIndex++), (SEXP)new VariablePromise(context, ((Symbol)argument.getSExpression()).getPrintName()));
                        continue;
                    }
                    args2.add(this.argumentNames.get(argNameIndex++), (SEXP)new IRPromise(context, temps, (IRThunk)argument));
                    continue;
                }
                args2.add(this.argumentNames.get(argNameIndex++), (SEXP)argument.retrieveValue(context, temps));
            }
            return ((Closure)functionValue).matchAndApply(context, context.getEnvironment(), this.call, args2.build());
        }
        return functionValue.apply(context, context.getEnvironment(), this.call, this.call.getArguments());
    }

    private SEXP[] evaluateArgs(Context context, Object[] temps) {
        SEXP[] evaluated = new SEXP[this.arguments.size()];
        for (int i = 0; i != evaluated.length; ++i) {
            evaluated[i] = (SEXP)this.arguments.get(i).retrieveValue(context, temps);
        }
        return evaluated;
    }

    private org.renjin.sexp.Function findFunction(Context context, Object[] temps) {
        if (this.functionSexp instanceof Symbol) {
            return context.getEnvironment().findFunctionOrThrow(context, (Symbol)this.functionSexp);
        }
        Object value = this.functionExpr.retrieveValue(context, temps);
        if (!(value instanceof org.renjin.sexp.Function)) {
            throw new EvalException("attempt to apply non-function: " + value, new Object[0]);
        }
        return (org.renjin.sexp.Function)value;
    }

    public SEXP getFunctionSexp() {
        return this.functionSexp;
    }

    @Override
    public Set<Variable> variables() {
        HashSet variables = Sets.newHashSet();
        variables.addAll(this.functionExpr.variables());
        for (Expression operand : this.arguments) {
            variables.addAll(operand.variables());
        }
        return Collections.unmodifiableSet(variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\u0394 " + this.functionExpr + "(");
        for (int i = 0; i != this.argumentNames.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (this.argumentNames.get(i) != Null.INSTANCE) {
                sb.append(this.argumentNames.get(i)).append(" = ");
            }
            sb.append(this.arguments.get(i));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Expression replaceVariable(Variable name, Variable newName) {
        ArrayList newOps = Lists.newArrayListWithCapacity((int)this.arguments.size());
        for (Expression argument : this.arguments) {
            newOps.add(argument.replaceVariable(name, newName));
        }
        return new DynamicCall(this.call, (Variable)this.functionExpr.replaceVariable(name, newName), this.argumentNames, newOps);
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList children = Lists.newArrayList();
        children.add(this.functionExpr);
        children.addAll(this.arguments);
        return children;
    }

    @Override
    public void setChild(int i, Expression expr) {
        if (i == 0) {
            this.functionExpr = (Variable)expr;
        } else {
            this.arguments.set(i - 1, expr);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitDynamicCall(this);
    }

    @Override
    public FunctionCall getSExpression() {
        return this.call;
    }

    @Override
    public List<String> getArgumentNames() {
        return Lists.transform(this.argumentNames, (Function)new Function<SEXP, String>(){

            public String apply(SEXP input) {
                if (input instanceof Symbol) {
                    return ((Symbol)input).getPrintName();
                }
                return null;
            }
        });
    }

    @Override
    public int getElipsesIndex() {
        return this.elipsesIndex;
    }

    @Override
    public boolean hasElipses() {
        return this.elipsesIndex != -1;
    }

    private static class IRPromise
    extends Promise {
        private Object[] temps;
        private IRThunk thunk;

        public IRPromise(Context context, Object[] temps, IRThunk thunk) {
            super(context.getEnvironment(), thunk.getSExpression());
            this.temps = temps;
            this.thunk = thunk;
        }

        @Override
        protected SEXP doEval(Context context) {
            return this.thunk.retrieveValue(context, this.temps);
        }
    }
}

