/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.exporter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.List;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.Calibrations;
import sc.fiji.filamentdetector.exporter.FilamentsExporter;
import sc.fiji.filamentdetector.model.Filament;
import sc.fiji.filamentdetector.model.Filaments;

public class JSONFilamentExporter
extends FilamentsExporter<Filaments> {
    @Parameter
    private LogService log;
    public static String NAME = "JSON Exporter";
    public static String DESCRIPTION = "A JSON Exporter. Calibrations of the image will be applied to all spatial values.";
    public static String EXTENSION = "*.json";
    public static String EXTENSION_DESCRIPTION = "JSON File (*.json)";
    public static List<String> EXTENSION_FILTERS = Arrays.asList("*.json");
    private Calibrations calibrations;

    public JSONFilamentExporter(Context context, Calibrations calibrations) {
        super(context);
        this.calibrations = calibrations;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    @Override
    public List<String> getExtensionFilters() {
        return EXTENSION_FILTERS;
    }

    @Override
    public String getExtensionDescription() {
        return EXTENSION_DESCRIPTION;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String toString() {
        return NAME;
    }

    @Override
    public void export(Filaments filaments, File file) {
        JsonObject root = new JsonObject();
        JsonArray filamentsArray = new JsonArray();
        for (Filament filament : filaments) {
            JsonObject filamentElement = new JsonObject();
            filamentElement.add("id", (JsonElement)new JsonPrimitive((Number)filament.getId()));
            filamentElement.add("length", (JsonElement)new JsonPrimitive((Number)(filament.getLength() * this.calibrations.getDx())));
            filamentElement.add("frame", (JsonElement)new JsonPrimitive((Number)filament.getFrame()));
            filamentElement.add("sinuosity", (JsonElement)new JsonPrimitive((Number)filament.getSinuosity()));
            filamentElement.add("size", (JsonElement)new JsonPrimitive((Number)filament.getSize()));
            filamentElement.add("color", (JsonElement)new JsonPrimitive(filament.getColorAsHex()));
            double[] x = filament.getXCoordinates();
            filamentElement.add("x", (JsonElement)this.serializeCoordinates(x, this.calibrations.getDx()));
            double[] y = filament.getYCoordinates();
            filamentElement.add("y", (JsonElement)this.serializeCoordinates(y, this.calibrations.getDy()));
            filamentsArray.add((JsonElement)filamentElement);
        }
        root.add("filaments", (JsonElement)filamentsArray);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)root);
        try {
            file.createNewFile();
            FileOutputStream fOut = new FileOutputStream(file);
            OutputStreamWriter myOutWriter = new OutputStreamWriter(fOut);
            myOutWriter.append(json);
            myOutWriter.close();
            fOut.close();
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
    }
}

