/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.reader;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.gui.ImageWindow;
import ij.io.FileInfo;
import ij.io.ImageReader;
import ij.io.OpenDialog;
import ij.io.RandomAccessStream;
import ij.measure.Calibration;
import java.awt.Color;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.imagearchive.lsm.reader.info.CZLSMInfo;
import org.imagearchive.lsm.reader.info.ChannelNamesAndColors;
import org.imagearchive.lsm.reader.info.ImageDirectory;
import org.imagearchive.lsm.reader.info.LSMFileInfo;

public class Reader {
    public static char micro = (char)181;
    private boolean show = true;
    public static String micrometer = micro + "m";

    public ImagePlus open(String path) {
        this.show = false;
        return this.open(path, true);
    }

    public ImagePlus open(String arg, boolean verbose) {
        File file = null;
        ImagePlus imp = null;
        OpenDialog od = new OpenDialog("Open LSM image... ", arg);
        String name = od.getFileName();
        if (name == null) {
            return null;
        }
        file = new File(od.getDirectory(), name);
        if (file != null) {
            imp = this.open(file.getParent(), file.getName(), true, false);
        }
        if (this.show && !arg.equals("noshow") & imp != null) {
            imp.setPosition(1, 1, 1);
            imp.show();
            imp.updateAndDraw();
            WindowFocusListener listener = null;
            try {
                ImageWindow win;
                Class<?> toolbox = Class.forName("org.imagearchive.lsm.toolbox.gui.ImageFocusListener");
                Object o = null;
                Constructor<?> toolboxCon = toolbox.getConstructor(new Class[0]);
                o = toolboxCon.newInstance(new Object[0]);
                listener = (WindowFocusListener)o;
                Method toolboxMet = o.getClass().getMethod("windowGainedFocus", WindowEvent.class);
                if (listener != null && (win = imp.getWindow()) != null) {
                    win.addWindowFocusListener(listener);
                }
                if (toolboxMet != null) {
                    toolboxMet.invoke(o, new Object[]{null});
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return imp;
    }

    public ImagePlus open(String directory, String filename, boolean verbose, boolean thumb) {
        ImagePlus imp = null;
        try {
            RandomAccessFile file = new RandomAccessFile(new File(directory, filename), "r");
            RandomAccessStream stream = new RandomAccessStream(file);
            LSMFileInfo lsm = new LSMFileInfo();
            lsm.fileName = filename;
            lsm.directory = directory;
            if (this.isLSMfile(stream)) {
                ImageDirectory imDir = this.readImageDirectoy(stream, 8L, thumb);
                lsm.imageDirectories.add(imDir);
                while (imDir.OFFSET_NEXT_DIRECTORY != 0L) {
                    imDir = this.readImageDirectoy(stream, imDir.OFFSET_NEXT_DIRECTORY, thumb);
                    lsm.imageDirectories.add(imDir);
                }
                imp = this.open(stream, lsm, verbose, thumb);
                stream.close();
            } else {
                IJ.error((String)"Not a valid lsm file");
            }
        }
        catch (FileNotFoundException e) {
            IJ.error((String)"File not found");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imp;
    }

    public boolean isLSMfile(RandomAccessStream stream) {
        boolean identifier = false;
        long ID = 0L;
        try {
            stream.seek(2);
            ID = this.swap(stream.readShort());
            if (ID == 42L) {
                identifier = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return identifier;
    }

    private long getTagCount(RandomAccessStream stream, long position) {
        long tags = 0L;
        try {
            stream.seek((int)position);
            tags = this.swap(stream.readShort());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tags;
    }

    private ImageDirectory readImageDirectoy(RandomAccessStream stream, long startPosition, boolean thumb) {
        ImageDirectory imDir = new ImageDirectory();
        long tags = this.getTagCount(stream, startPosition);
        int tagtype = 0;
        int MASK = 255;
        long MASK2 = 255L;
        long currentTagPosition = 0L;
        long stripOffset = 0L;
        long stripByteOffset = 0L;
        int i = 0;
        while ((long)i < tags) {
            currentTagPosition = startPosition + 2L + (long)(i * 12);
            byte[] tag = this.readTag(stream, (int)currentTagPosition);
            tagtype = (tag[1] & 0xFF) << 8 | (tag[0] & 0xFF) << 0;
            switch (tagtype) {
                case 254: {
                    imDir.TIF_NEWSUBFILETYPE = ((long)tag[11] & 0xFFL) << 24 | ((long)tag[10] & 0xFFL) << 16 | ((long)tag[9] & 0xFFL) << 8 | (long)tag[8] & 0xFFL;
                    break;
                }
                case 256: {
                    imDir.TIF_IMAGEWIDTH = ((long)tag[11] & 0xFFL) << 24 | ((long)tag[10] & 0xFFL) << 16 | ((long)tag[9] & 0xFFL) << 8 | (long)tag[8] & 0xFFL;
                    break;
                }
                case 257: {
                    imDir.TIF_IMAGELENGTH = ((long)tag[11] & 0xFFL) << 24 | ((long)tag[10] & 0xFFL) << 16 | ((long)tag[9] & 0xFFL) << 8 | (long)tag[8] & 0xFFL;
                    break;
                }
                case 258: {
                    imDir.TIF_BITSPERSAMPLE_LENGTH = ((long)tag[7] & 0xFFL) << 24 | ((long)tag[6] & 0xFFL) << 16 | ((long)tag[5] & 0xFFL) << 8 | (long)tag[4] & 0xFFL;
                    imDir.TIF_BITSPERSAMPLE_CHANNEL[0] = ((long)tag[8] & 0xFFL) << 0;
                    imDir.TIF_BITSPERSAMPLE_CHANNEL[1] = ((long)tag[9] & 0xFFL) << 0;
                    imDir.TIF_BITSPERSAMPLE_CHANNEL[2] = ((long)tag[10] & 0xFFL) << 0;
                    break;
                }
                case 259: {
                    imDir.TIF_COMPRESSION = ((long)tag[8] & 0xFFL) << 0;
                    break;
                }
                case 262: {
                    imDir.TIF_PHOTOMETRICINTERPRETATION = ((long)tag[8] & 0xFFL) << 0;
                    break;
                }
                case 273: {
                    imDir.TIF_STRIPOFFSETS_LENGTH = ((long)tag[7] & 0xFFL) << 24 | ((long)tag[6] & 0xFFL) << 16 | ((long)tag[5] & 0xFFL) << 8 | (long)tag[4] & 0xFFL;
                    stripOffset = ((long)tag[11] & 0xFFL) << 24 | ((long)tag[10] & 0xFFL) << 16 | ((long)tag[9] & 0xFFL) << 8 | (long)tag[8] & 0xFFL;
                    break;
                }
                case 277: {
                    imDir.TIF_SAMPLESPERPIXEL = ((long)tag[8] & 0xFFL) << 0;
                    break;
                }
                case 279: {
                    imDir.TIF_STRIPBYTECOUNTS_LENGTH = ((long)tag[7] & 0xFFL) << 24 | ((long)tag[6] & 0xFFL) << 16 | ((long)tag[5] & 0xFFL) << 8 | (long)tag[4] & 0xFFL;
                    stripByteOffset = ((long)tag[11] & 0xFFL) << 24 | ((long)tag[10] & 0xFFL) << 16 | ((long)tag[9] & 0xFFL) << 8 | (long)tag[8] & 0xFFL;
                    break;
                }
                case 317: {
                    imDir.TIF_PREDICTOR = ((long)tag[8] & 0xFFL) << 0;
                    break;
                }
                case 34412: {
                    imDir.TIF_CZ_LSMINFO_OFFSET = ((long)tag[11] & 0xFFL) << 24 | ((long)tag[10] & 0xFFL) << 16 | ((long)tag[9] & 0xFFL) << 8 | (long)tag[8] & 0xFFL;
                    break;
                }
            }
            ++i;
        }
        imDir.TIF_STRIPOFFSETS = new long[(int)imDir.TIF_STRIPOFFSETS_LENGTH];
        if (imDir.TIF_STRIPOFFSETS_LENGTH == 1L) {
            imDir.TIF_STRIPOFFSETS[0] = stripOffset;
        } else {
            imDir.TIF_STRIPOFFSETS = this.getIntTable(stream, stripOffset, (int)imDir.TIF_STRIPOFFSETS_LENGTH);
        }
        imDir.TIF_STRIPBYTECOUNTS = new long[(int)imDir.TIF_STRIPBYTECOUNTS_LENGTH];
        if (imDir.TIF_STRIPBYTECOUNTS_LENGTH == 1L) {
            imDir.TIF_STRIPBYTECOUNTS[0] = stripByteOffset;
        } else {
            imDir.TIF_STRIPBYTECOUNTS = this.getIntTable(stream, stripByteOffset, (int)imDir.TIF_STRIPBYTECOUNTS_LENGTH);
        }
        try {
            stream.seek((int)(currentTagPosition + 12L));
            int offset_next_directory = this.swap(stream.readInt());
            imDir.OFFSET_NEXT_DIRECTORY = offset_next_directory;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (imDir.TIF_CZ_LSMINFO_OFFSET != 0L) {
            imDir.TIF_CZ_LSMINFO = this.getCZ_LSMINFO(stream, imDir.TIF_CZ_LSMINFO_OFFSET, thumb);
        }
        return imDir;
    }

    private byte[] readTag(RandomAccessStream stream, int position) {
        byte[] tag = new byte[12];
        try {
            stream.seek(position);
            stream.readFully(tag);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tag;
    }

    private long[] getIntTable(RandomAccessStream stream, long position, int count) {
        long[] offsets = new long[count];
        try {
            stream.seek((int)position);
            for (int i = 0; i < count; ++i) {
                offsets[i] = this.swap(stream.readInt());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return offsets;
    }

    private CZLSMInfo getCZ_LSMINFO(RandomAccessStream stream, long position, boolean thumb) {
        CZLSMInfo cz = new CZLSMInfo();
        try {
            if (position == 0L) {
                return cz;
            }
            stream.seek((int)position + 8);
            cz.DimensionX = this.swap(stream.readInt());
            cz.DimensionY = this.swap(stream.readInt());
            cz.DimensionZ = this.swap(stream.readInt());
            cz.DimensionChannels = this.swap(stream.readInt());
            cz.DimensionTime = this.swap(stream.readInt());
            cz.IntensityDataType = this.swap(stream.readInt());
            cz.ThumbnailX = this.swap(stream.readInt());
            cz.ThumbnailY = this.swap(stream.readInt());
            cz.VoxelSizeX = this.swap(stream.readDouble());
            cz.VoxelSizeY = this.swap(stream.readDouble());
            cz.VoxelSizeZ = this.swap(stream.readDouble());
            stream.seek((int)position + 88);
            cz.ScanType = this.swap(stream.readShort());
            stream.seek((int)position + 108);
            cz.OffsetChannelColors = this.swap(stream.readInt());
            stream.seek((int)position + 120);
            cz.OffsetChannelDataTypes = this.swap(stream.readInt());
            stream.seek((int)position + 264);
            cz.DimensionP = this.swap(stream.readInt());
            if (cz.DimensionP < 1L) {
                cz.DimensionP = 1L;
            }
            cz.DimensionM = this.swap(stream.readInt());
            if (cz.DimensionM < 1L) {
                cz.DimensionM = 1L;
            }
            if (cz.OffsetChannelDataTypes != 0L) {
                cz.OffsetChannelDataTypesValues = this.getOffsetChannelDataTypesValues(stream, cz.OffsetChannelDataTypes, cz.DimensionChannels);
            }
            if (cz.OffsetChannelColors != 0L) {
                ChannelNamesAndColors channelNamesAndColors;
                cz.channelNamesAndColors = channelNamesAndColors = this.getChannelNamesAndColors(stream, cz.OffsetChannelColors, cz.DimensionChannels);
            }
        }
        catch (IOException getCZ_LSMINFO_exception) {
            getCZ_LSMINFO_exception.printStackTrace();
        }
        return cz;
    }

    private int[] getOffsetChannelDataTypesValues(RandomAccessStream stream, long position, long channelCount) {
        int[] OffsetChannelDataTypesValues = new int[(int)channelCount];
        try {
            stream.seek((int)position);
            int i = 0;
            while ((long)i < channelCount) {
                OffsetChannelDataTypesValues[i] = this.swap(stream.readInt());
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return OffsetChannelDataTypesValues;
    }

    private ChannelNamesAndColors getChannelNamesAndColors(RandomAccessStream stream, long position, long channelCount) {
        ChannelNamesAndColors channelNamesAndColors = new ChannelNamesAndColors();
        try {
            stream.seek((int)position);
            channelNamesAndColors.BlockSize = this.swap(stream.readInt());
            channelNamesAndColors.NumberColors = this.swap(stream.readInt());
            channelNamesAndColors.NumberNames = this.swap(stream.readInt());
            channelNamesAndColors.ColorsOffset = this.swap(stream.readInt());
            channelNamesAndColors.NamesOffset = this.swap(stream.readInt());
            channelNamesAndColors.Mono = this.swap(stream.readInt());
            stream.seek((int)channelNamesAndColors.NamesOffset + (int)position);
            channelNamesAndColors.ChannelNames = new String[(int)channelCount];
            int j = 0;
            while ((long)j < channelCount) {
                long size = this.swap(stream.readInt());
                channelNamesAndColors.ChannelNames[j] = Reader.readSizedNULLASCII(stream, size);
                ++j;
            }
            stream.seek((int)channelNamesAndColors.ColorsOffset + (int)position);
            channelNamesAndColors.Colors = new int[(int)channelNamesAndColors.NumberColors];
            for (j = 0; j < (int)channelNamesAndColors.NumberColors; ++j) {
                channelNamesAndColors.Colors[j] = this.swap(stream.readInt());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return channelNamesAndColors;
    }

    public static String readSizedNULLASCII(RandomAccessStream stream, long s) {
        int offset = 0;
        String tempstr = new String("");
        int in = 0;
        boolean addchar = true;
        try {
            while ((long)offset < s && (in = stream.read()) != -1) {
                char ch = (char)in;
                if (addchar) {
                    String achar = new Character(ch).toString();
                    if (ch != '\u0000') {
                        tempstr = tempstr + achar;
                    } else {
                        addchar = false;
                    }
                }
                ++offset;
            }
        }
        catch (IOException Read_ASCII_exception) {
            Read_ASCII_exception.printStackTrace();
        }
        return tempstr;
    }

    private void applyColors(ImagePlus imp, int channel, Color[] gc, int i) {
        FileInfo fi = new FileInfo();
        int size = 256;
        fi.reds = new byte[256];
        fi.greens = new byte[256];
        fi.blues = new byte[256];
        fi.lutSize = 256;
        float nColorsfl = 256.0f;
        float interval = 256.0f;
        float iR = gc[0].getRed();
        float iG = gc[0].getGreen();
        float iB = gc[0].getBlue();
        float idR = gc[1].getRed() - gc[0].getRed();
        float idG = gc[1].getGreen() - gc[0].getGreen();
        float idB = gc[1].getBlue() - gc[0].getBlue();
        idR /= 256.0f;
        idG /= 256.0f;
        idB /= 256.0f;
        int a = 0;
        a = 0;
        while (a < 256) {
            fi.reds[a] = (byte)iR;
            fi.greens[a] = (byte)iG;
            fi.blues[a] = (byte)iB;
            ++a;
            iR += idR;
            iG += idG;
            iB += idB;
        }
        int b = 255;
        fi.reds[255] = (byte)gc[1].getRed();
        fi.greens[255] = (byte)gc[1].getGreen();
        fi.blues[255] = (byte)gc[1].getBlue();
        nColorsfl = 256.0f;
        if (nColorsfl > 0.0f) {
            if (nColorsfl < 256.0f) {
                this.interpolate(256, fi.reds, fi.greens, fi.blues, (int)nColorsfl);
            }
            this.showLut(imp, channel, fi, true);
            return;
        }
    }

    private void interpolate(int size, byte[] reds, byte[] greens, byte[] blues, int nColors) {
        byte[] r = new byte[nColors];
        byte[] g = new byte[nColors];
        byte[] b = new byte[nColors];
        System.arraycopy(reds, 0, r, 0, nColors);
        System.arraycopy(greens, 0, g, 0, nColors);
        System.arraycopy(blues, 0, b, 0, nColors);
        double scale = (float)nColors / (float)size;
        for (int i = 0; i < size; ++i) {
            int i1 = (int)((double)i * scale);
            int i2 = i1 + 1;
            if (i2 == nColors) {
                i2 = nColors - 1;
            }
            double fraction = (double)i * scale - (double)i1;
            reds[i] = (byte)((1.0 - fraction) * (double)(r[i1] & 0xFF) + fraction * (double)(r[i2] & 0xFF));
            greens[i] = (byte)((1.0 - fraction) * (double)(g[i1] & 0xFF) + fraction * (double)(g[i2] & 0xFF));
            blues[i] = (byte)((1.0 - fraction) * (double)(b[i1] & 0xFF) + fraction * (double)(b[i2] & 0xFF));
        }
    }

    private void showLut(ImagePlus imp, int channel, FileInfo fi, boolean showImage) {
        if (imp != null) {
            if (imp.getType() == 4) {
                IJ.error((String)"Color tables cannot be assiged to RGB Images.");
            } else {
                IndexColorModel cm = null;
                cm = new IndexColorModel(8, 256, fi.reds, fi.greens, fi.blues);
                imp.setPosition(channel + 1, imp.getSlice(), imp.getFrame());
                if (imp.isComposite()) {
                    ((CompositeImage)imp).setChannelColorModel(cm);
                    ((CompositeImage)imp).updateChannelAndDraw();
                } else {
                    imp.getProcessor().setColorModel((ColorModel)cm);
                    imp.updateAndDraw();
                }
            }
        }
    }

    public ImagePlus open(RandomAccessStream stream, LSMFileInfo lsmFi, boolean verbose, boolean thumb) {
        ImageDirectory firstImDir = (ImageDirectory)lsmFi.imageDirectories.get(0);
        if (firstImDir == null) {
            if (verbose) {
                IJ.error((String)"LSM ImageDir null.");
            }
            return null;
        }
        CZLSMInfo cz = (CZLSMInfo)firstImDir.TIF_CZ_LSMINFO;
        if (cz == null) {
            if (verbose) {
                IJ.error((String)"LSM ImageDir null.");
            }
            return null;
        }
        ImagePlus imps = null;
        switch (cz.ScanType) {
            case 0: {
                imps = this.readStack(stream, lsmFi, cz, thumb);
                return imps;
            }
            case 1: {
                imps = this.readStack(stream, lsmFi, cz, thumb);
                return imps;
            }
            case 2: {
                imps = this.readStack(stream, lsmFi, cz, thumb);
                return imps;
            }
            case 3: {
                imps = this.readStack(stream, lsmFi, cz, thumb);
                return imps;
            }
            case 4: {
                imps = this.readStack(stream, lsmFi, cz, thumb);
                return imps;
            }
            case 5: {
                imps = this.readStack(stream, lsmFi, cz, thumb);
                return imps;
            }
            case 6: {
                imps = this.readStack(stream, lsmFi, cz, thumb);
                return imps;
            }
            case 10: {
                imps = this.readStack(stream, lsmFi, cz, thumb);
                return imps;
            }
        }
        if (verbose) {
            IJ.error((String)("Unsupported LSM scantype: " + cz.ScanType));
        }
        return imps;
    }

    private ImagePlus readStack(RandomAccessStream stream, LSMFileInfo lsmFi, CZLSMInfo cz, boolean thumb) {
        ImageDirectory firstImDir = (ImageDirectory)lsmFi.imageDirectories.get(0);
        lsmFi.url = "";
        lsmFi.fileFormat = 2;
        lsmFi.pixelDepth = cz.VoxelSizeZ * 1000000.0;
        lsmFi.pixelHeight = cz.VoxelSizeY * 1000000.0;
        lsmFi.pixelWidth = cz.VoxelSizeX * 1000000.0;
        lsmFi.unit = micrometer;
        lsmFi.valueUnit = micrometer;
        lsmFi.nImages = 1;
        lsmFi.intelByteOrder = true;
        ImageStack st = null;
        int datatype = (int)cz.IntensityDataType;
        if (datatype == 0) {
            datatype = cz.OffsetChannelDataTypesValues[0];
        }
        switch (datatype) {
            case 1: {
                lsmFi.fileType = 0;
                break;
            }
            case 2: {
                lsmFi.fileType = 2;
                break;
            }
            case 3: {
                lsmFi.fileType = 2;
                break;
            }
            case 5: {
                lsmFi.fileType = 4;
                break;
            }
            default: {
                lsmFi.fileType = 0;
            }
        }
        ColorModel cm = null;
        cm = lsmFi.fileType == 5 && lsmFi.lutSize > 0 ? new IndexColorModel(8, lsmFi.lutSize, lsmFi.reds, lsmFi.greens, lsmFi.blues) : LookUpTable.createGrayscaleColorModel((boolean)lsmFi.whiteIsZero);
        st = !thumb ? new ImageStack((int)firstImDir.TIF_IMAGEWIDTH, (int)firstImDir.TIF_IMAGELENGTH, cm) : new ImageStack((int)cz.ThumbnailX, (int)cz.ThumbnailY, cm);
        firstImDir = null;
        ImageReader reader = null;
        int flength = 0;
        lsmFi.stripOffsets = new int[1];
        lsmFi.stripLengths = new int[1];
        for (int imageCounter = 0; imageCounter < lsmFi.imageDirectories.size(); ++imageCounter) {
            ImageDirectory imDir = (ImageDirectory)lsmFi.imageDirectories.get(imageCounter);
            for (int i = 0; i < imDir.TIF_STRIPBYTECOUNTS.length; ++i) {
                if (imDir.TIF_COMPRESSION == 5L) {
                    lsmFi.compression = 2;
                    flength = (int)new File(lsmFi.directory + System.getProperty("file.separator") + lsmFi.fileName).length();
                    if (imDir.TIF_PREDICTOR != 2L) continue;
                    lsmFi.compression = 3;
                    continue;
                }
                lsmFi.compression = 0;
            }
            if (!thumb && imDir.TIF_NEWSUBFILETYPE == 0L) {
                lsmFi.width = (int)imDir.TIF_IMAGEWIDTH;
                lsmFi.height = (int)imDir.TIF_IMAGELENGTH;
                for (int channelCount = 0; channelCount < (int)cz.DimensionChannels; ++channelCount) {
                    datatype = (int)cz.IntensityDataType;
                    if (datatype == 0) {
                        datatype = cz.OffsetChannelDataTypesValues[channelCount];
                    }
                    switch (datatype) {
                        case 1: {
                            lsmFi.fileType = 0;
                            break;
                        }
                        case 2: {
                            lsmFi.fileType = 2;
                            break;
                        }
                        case 3: {
                            lsmFi.fileType = 2;
                            break;
                        }
                        case 5: {
                            lsmFi.fileType = 4;
                            break;
                        }
                        default: {
                            lsmFi.fileType = 0;
                        }
                    }
                    lsmFi.stripLengths[0] = (int)imDir.TIF_STRIPBYTECOUNTS[channelCount];
                    lsmFi.stripOffsets[0] = (int)imDir.TIF_STRIPOFFSETS[channelCount];
                    reader = new ImageReader((FileInfo)lsmFi);
                    if ((long)channelCount >= imDir.TIF_STRIPOFFSETS_LENGTH) continue;
                    if (lsmFi.stripLengths[0] + lsmFi.stripOffsets[0] > flength) {
                        lsmFi.stripLengths[0] = flength - lsmFi.stripOffsets[0];
                    }
                    try {
                        stream.seek(lsmFi.stripOffsets[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    Object pixels = reader.readPixels((InputStream)stream);
                    st.addSlice("", pixels);
                }
                continue;
            }
            if (!thumb || imDir.TIF_NEWSUBFILETYPE != 1L) continue;
            lsmFi.width = (int)imDir.TIF_IMAGEWIDTH;
            lsmFi.height = (int)imDir.TIF_IMAGELENGTH;
            reader = new ImageReader((FileInfo)lsmFi);
            int channels = (int)cz.DimensionChannels;
            channels = 1;
            for (int channelCount = 0; channelCount < channels; ++channelCount) {
                lsmFi.stripLengths[0] = (int)imDir.TIF_STRIPBYTECOUNTS[channelCount];
                lsmFi.stripOffsets[0] = (int)imDir.TIF_STRIPOFFSETS[channelCount];
                if ((long)channelCount >= imDir.TIF_STRIPOFFSETS_LENGTH) continue;
                try {
                    stream.seek(lsmFi.stripOffsets[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Object pixels = reader.readPixels((InputStream)stream);
                st.addSlice("", pixels);
            }
            imageCounter = lsmFi.imageDirectories.size();
        }
        IJ.showProgress((double)1.0);
        ImagePlus imp = new ImagePlus(lsmFi.fileName, st);
        imp.setDimensions((int)cz.DimensionChannels, (int)cz.DimensionZ, (int)(cz.DimensionTime * cz.DimensionP));
        if (cz.DimensionChannels >= 2L && (long)imp.getStackSize() % cz.DimensionChannels == 0L) {
            imp = new CompositeImage(imp, 2);
        }
        imp.setFileInfo((FileInfo)lsmFi);
        Calibration cal = new Calibration();
        cal.setUnit(lsmFi.unit);
        cal.pixelDepth = lsmFi.pixelDepth;
        cal.pixelHeight = lsmFi.pixelHeight;
        cal.pixelWidth = lsmFi.pixelWidth;
        imp.setCalibration(cal);
        Color[] color = new Color[2];
        color[0] = new Color(0, 0, 0);
        for (int channel = 0; channel < (int)cz.DimensionChannels; ++channel) {
            int r = cz.channelNamesAndColors.Colors[channel] & 0xFF;
            int g = cz.channelNamesAndColors.Colors[channel] >> 8 & 0xFF;
            int b = cz.channelNamesAndColors.Colors[channel] >> 16 & 0xFF;
            color[1] = new Color(r, g, b);
            if (r == 0 && g == 0 && b == 0) {
                color[1] = Color.white;
            }
            this.applyColors(imp, channel, color, 2);
        }
        if (imp.getOriginalFileInfo().fileType == 2) {
            double min = imp.getProcessor().getMin();
            double max = imp.getProcessor().getMax();
            imp.getProcessor().setMinAndMax(min, max);
        }
        int stackPosition = 1;
        int i = 1;
        while ((long)i <= cz.DimensionTime) {
            int j = 1;
            while ((long)j <= cz.DimensionZ) {
                int k = 1;
                while ((long)k <= cz.DimensionChannels) {
                    if (stackPosition <= imp.getStackSize()) {
                        String label = cz.channelNamesAndColors.ChannelNames[k - 1];
                        st.setSliceLabel(label, stackPosition++);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.setInfo(imp, lsmFi);
        return imp;
    }

    public ImagePlus setInfo(ImagePlus imp, LSMFileInfo lsm) {
        ImageDirectory imDir = (ImageDirectory)lsm.imageDirectories.get(0);
        if (imDir == null) {
            return null;
        }
        CZLSMInfo cz = (CZLSMInfo)imDir.TIF_CZ_LSMINFO;
        String infos = new String();
        String stacksize = IJ.d2s((double)cz.DimensionZ, (int)0);
        String width = IJ.d2s((double)lsm.width, (int)0);
        String height = IJ.d2s((double)lsm.height, (int)0);
        String channels = IJ.d2s((double)cz.DimensionChannels, (int)0);
        String scantype = "";
        switch (cz.ScanType) {
            case 0: {
                scantype = "Normal X-Y-Z scan";
                break;
            }
            case 1: {
                scantype = "Z scan";
                break;
            }
            case 2: {
                scantype = "Line scan";
                break;
            }
            case 3: {
                scantype = "Time series X-Y";
                break;
            }
            case 4: {
                scantype = "Time series X-Y";
                break;
            }
            case 5: {
                scantype = "Time series - Means of ROIs";
                break;
            }
            case 6: {
                scantype = "Time series - X-Y-Z";
                break;
            }
            case 10: {
                scantype = "Point mode";
                break;
            }
            default: {
                scantype = "UNKNOWN !";
            }
        }
        String voxelsize_x = IJ.d2s((double)(cz.VoxelSizeX * 1000000.0), (int)2) + " " + micrometer;
        String voxelsize_y = IJ.d2s((double)(cz.VoxelSizeY * 1000000.0), (int)2) + " " + micrometer;
        String voxelsize_z = IJ.d2s((double)(cz.VoxelSizeZ * 1000000.0), (int)2) + " " + micrometer;
        String timestacksize = IJ.d2s((double)cz.DimensionTime, (int)0);
        String positionssize = IJ.d2s((double)cz.DimensionP, (int)0);
        String mosaicsize = IJ.d2s((double)cz.DimensionM, (int)0);
        String plane_width = IJ.d2s((double)((double)cz.DimensionX * cz.VoxelSizeX), (int)2) + " " + micrometer;
        String plane_height = IJ.d2s((double)((double)cz.DimensionY * cz.VoxelSizeY), (int)2) + " " + micrometer;
        String volume_depth = IJ.d2s((double)((double)cz.DimensionZ * cz.VoxelSizeZ), (int)2) + " " + micrometer;
        infos = "Filename: " + lsm.fileName + "\n";
        infos = infos + "Width: " + width + "\n";
        infos = infos + "Height: " + height + "\n";
        infos = infos + "Channels: " + channels + "\n";
        infos = infos + "Z_size:" + stacksize + "\n";
        infos = infos + "T_size: " + timestacksize + "\n";
        infos = infos + "P_size: " + positionssize + "\n";
        infos = infos + "M_size: " + mosaicsize + "\n";
        infos = infos + "Scan_type: " + scantype + "\n";
        infos = infos + "Voxel_size_X: " + voxelsize_x + "\n";
        infos = infos + "Voxel_size_Y: " + voxelsize_y + "\n";
        infos = infos + "Voxel_size_Z: " + voxelsize_z + "\n";
        infos = infos + "Plane_width: " + plane_width + "\n";
        infos = infos + "Plane_height: " + plane_height + "\n";
        infos = infos + "Plane_depth: " + volume_depth + "\n";
        imp.setProperty("Info", (Object)infos);
        return imp;
    }

    private short swap(short x) {
        return (short)(x << 8 | x >> 8 & 0xFF);
    }

    private char swap(char x) {
        return (char)(x << 8 | x >> 8 & 0xFF);
    }

    private int swap(int x) {
        return this.swap((short)x) << 16 | this.swap((short)(x >> 16)) & 0xFFFF;
    }

    private long swap(long x) {
        return (long)this.swap((int)x) << 32 | (long)this.swap((int)(x >> 32)) & 0xFFFFFFFFL;
    }

    private float swap(float x) {
        return Float.intBitsToFloat(this.swap(Float.floatToIntBits(x)));
    }

    private double swap(double x) {
        return Double.longBitsToDouble(this.swap(Double.doubleToLongBits(x)));
    }
}

