/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.convert;

import net.imagej.ops.Op;
import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.UHCFViaUCSameIO;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imglib2.Dimensions;
import net.imglib2.IterableInterval;
import net.imglib2.img.Img;
import net.imglib2.type.NativeType;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.plugin.Plugin;

public final class ConvertImages {
    private ConvertImages() {
    }

    private static abstract class ConvertViaMap<I extends ComplexType<I>, O extends NativeType<O>>
    extends UHCFViaUCSameIO<IterableInterval<I>, Img<O>> {
        private Class<? extends Op> opType;
        private O outElement;

        protected ConvertViaMap(Class<? extends Op> opType, O outElement) {
            this.opType = opType;
            this.outElement = outElement;
        }

        @Override
        public UnaryComputerOp<IterableInterval<I>, Img<O>> createWorker(IterableInterval<I> t) {
            ComplexType inElement = (ComplexType)t.firstElement();
            UnaryComputerOp<ComplexType, O> elementOp = Computers.unary(this.ops(), this.opType, this.outElement, inElement, new Object[0]);
            return Computers.unary(this.ops(), Ops.Map.class, Img.class, t, new Object[]{elementOp});
        }

        @Override
        public Img<O> createOutput(IterableInterval<I> input) {
            return this.ops().create().img((Dimensions)input, this.outElement);
        }
    }

    @Plugin(type=Ops.Convert.Cfloat64.class)
    public static class Cfloat64<C extends ComplexType<C>>
    extends ConvertViaMap<C, ComplexDoubleType>
    implements Ops.Convert.Cfloat64 {
        public Cfloat64() {
            super(Ops.Convert.Cfloat64.class, new ComplexDoubleType());
        }
    }

    @Plugin(type=Ops.Convert.Cfloat32.class)
    public static class Cfloat32<C extends ComplexType<C>>
    extends ConvertViaMap<C, ComplexFloatType>
    implements Ops.Convert.Cfloat32 {
        public Cfloat32() {
            super(Ops.Convert.Cfloat32.class, new ComplexFloatType());
        }
    }

    @Plugin(type=Ops.Convert.Float64.class)
    public static class Float64<C extends ComplexType<C>>
    extends ConvertViaMap<C, DoubleType>
    implements Ops.Convert.Float64 {
        public Float64() {
            super(Ops.Convert.Float64.class, new DoubleType());
        }
    }

    @Plugin(type=Ops.Convert.Float32.class)
    public static class Float32<C extends ComplexType<C>>
    extends ConvertViaMap<C, FloatType>
    implements Ops.Convert.Float32 {
        public Float32() {
            super(Ops.Convert.Float32.class, new FloatType());
        }
    }

    @Plugin(type=Ops.Convert.Uint128.class)
    public static class Uint128<C extends ComplexType<C>>
    extends ConvertViaMap<C, Unsigned128BitType>
    implements Ops.Convert.Uint128 {
        public Uint128() {
            super(Ops.Convert.Uint128.class, new Unsigned128BitType());
        }
    }

    @Plugin(type=Ops.Convert.Uint64.class)
    public static class Uint64<C extends ComplexType<C>>
    extends ConvertViaMap<C, UnsignedLongType>
    implements Ops.Convert.Uint64 {
        public Uint64() {
            super(Ops.Convert.Uint64.class, new UnsignedLongType());
        }
    }

    @Plugin(type=Ops.Convert.Int64.class)
    public static class Int64<C extends ComplexType<C>>
    extends ConvertViaMap<C, LongType>
    implements Ops.Convert.Int64 {
        public Int64() {
            super(Ops.Convert.Int64.class, new LongType());
        }
    }

    @Plugin(type=Ops.Convert.Uint32.class)
    public static class Uint32<C extends ComplexType<C>>
    extends ConvertViaMap<C, UnsignedIntType>
    implements Ops.Convert.Uint32 {
        public Uint32() {
            super(Ops.Convert.Uint32.class, new UnsignedIntType());
        }
    }

    @Plugin(type=Ops.Convert.Int32.class)
    public static class Int32<C extends ComplexType<C>>
    extends ConvertViaMap<C, IntType>
    implements Ops.Convert.Int32 {
        public Int32() {
            super(Ops.Convert.Int32.class, new IntType());
        }
    }

    @Plugin(type=Ops.Convert.Uint16.class)
    public static class Uint16<C extends ComplexType<C>>
    extends ConvertViaMap<C, UnsignedShortType>
    implements Ops.Convert.Uint16 {
        public Uint16() {
            super(Ops.Convert.Uint16.class, new UnsignedShortType());
        }
    }

    @Plugin(type=Ops.Convert.Int16.class)
    public static class Int16<C extends ComplexType<C>>
    extends ConvertViaMap<C, ShortType>
    implements Ops.Convert.Int16 {
        public Int16() {
            super(Ops.Convert.Int16.class, new ShortType());
        }
    }

    @Plugin(type=Ops.Convert.Uint12.class)
    public static class Uint12<C extends ComplexType<C>>
    extends ConvertViaMap<C, Unsigned12BitType>
    implements Ops.Convert.Uint12 {
        public Uint12() {
            super(Ops.Convert.Uint12.class, new Unsigned12BitType());
        }
    }

    @Plugin(type=Ops.Convert.Uint8.class)
    public static class Uint8<C extends ComplexType<C>>
    extends ConvertViaMap<C, UnsignedByteType>
    implements Ops.Convert.Uint8 {
        public Uint8() {
            super(Ops.Convert.Uint8.class, new UnsignedByteType());
        }
    }

    @Plugin(type=Ops.Convert.Int8.class)
    public static class Int8<C extends ComplexType<C>>
    extends ConvertViaMap<C, ByteType>
    implements Ops.Convert.Int8 {
        public Int8() {
            super(Ops.Convert.Int8.class, new ByteType());
        }
    }

    @Plugin(type=Ops.Convert.Uint4.class)
    public static class Uint4<C extends ComplexType<C>>
    extends ConvertViaMap<C, Unsigned4BitType>
    implements Ops.Convert.Uint4 {
        public Uint4() {
            super(Ops.Convert.Uint4.class, new Unsigned4BitType());
        }
    }

    @Plugin(type=Ops.Convert.Uint2.class)
    public static class Uint2<C extends ComplexType<C>>
    extends ConvertViaMap<C, Unsigned2BitType>
    implements Ops.Convert.Uint2 {
        public Uint2() {
            super(Ops.Convert.Uint2.class, new Unsigned2BitType());
        }
    }

    @Plugin(type=Ops.Convert.Bit.class)
    public static class Bit<C extends ComplexType<C>>
    extends ConvertViaMap<C, BitType>
    implements Ops.Convert.Bit {
        public Bit() {
            super(Ops.Convert.Bit.class, new BitType());
        }
    }
}

