/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.create.kernelBiGauss;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractBinaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Create.KernelBiGauss.class, name="create.kernelBiGauss")
public class DefaultCreateKernelBiGauss<T extends ComplexType<T>>
extends AbstractBinaryFunctionOp<double[], Integer, RandomAccessibleInterval<T>>
implements Ops.Create.KernelBiGauss {
    @Parameter
    private T typeVar;
    private UnaryFunctionOp<Interval, RandomAccessibleInterval<T>> createImgOp;

    @Override
    public void initialize() {
        this.createImgOp = Functions.unary(this.ops(), Ops.Create.Img.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{this.typeVar});
    }

    @Override
    public RandomAccessibleInterval<T> calculate(double[] sigmas, Integer dimensionality) {
        if (sigmas.length < 2) {
            throw new IllegalArgumentException("Two sigmas (for inner and outer Gauss) must be supplied.");
        }
        if (sigmas[0] <= 0.0 || sigmas[1] <= 0.0) {
            throw new IllegalArgumentException("Input sigmas must be both positive.");
        }
        if (dimensionality <= 0) {
            throw new IllegalArgumentException("Input dimensionality must both positive.");
        }
        long[] dims = new long[dimensionality.intValue()];
        long[] centre = new long[dimensionality.intValue()];
        dims[0] = Math.max(3, 2 * (int)(sigmas[0] + 2.0 * sigmas[1] + 0.5) + 1);
        centre[0] = (int)(dims[0] / 2L);
        for (int d = 1; d < dims.length; ++d) {
            dims[d] = dims[0];
            centre[d] = centre[0];
        }
        double k = sigmas[1] / sigmas[0] * (sigmas[1] / sigmas[0]);
        double c0 = 0.24197 * (sigmas[1] / sigmas[0] - 1.0) / sigmas[0];
        double[] C = new double[]{1.0 / (2.50663 * sigmas[0]), 1.0 / (2.50663 * sigmas[1])};
        double[] sigmasSq = new double[]{sigmas[0] * sigmas[0], sigmas[1] * sigmas[1]};
        RandomAccessibleInterval<T> out = this.createImgOp.calculate((Interval)new FinalInterval(dims));
        Cursor cursor = Views.iterable(out).cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(dims);
            double dist = 0.0;
            for (int d = 0; d < dims.length; ++d) {
                double dx = dims[d] - centre[d];
                dist += dx * dx;
            }
            double val = 0.0;
            if (dist < sigmasSq[0]) {
                val = C[0] * Math.exp(-0.5 * dist / sigmasSq[0]) + c0;
            } else {
                dist = Math.sqrt(dist) - (sigmas[0] - sigmas[1]);
                dist *= dist;
                val = k * C[1] * Math.exp(-0.5 * dist / sigmasSq[1]);
            }
            ((ComplexType)cursor.get()).setReal(val);
        }
        return out;
    }
}

