/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imagej.ops.features.haralick.helper.CoocHXY;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.ICM2.class, label="Haralick: Information Measure of Correlation 2")
public class DefaultICM2<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.ICM2 {
    private UnaryFunctionOp<double[][], double[]> coocHXYFunc;
    private UnaryFunctionOp<IterableInterval<T>, DoubleType> entropy;

    @Override
    public void initialize() {
        super.initialize();
        this.coocHXYFunc = Functions.unary(this.ops(), CoocHXY.class, double[].class, double[][].class, new Object[0]);
        this.entropy = Functions.unary(this.ops(), Ops.Haralick.Entropy.class, DoubleType.class, this.in(), this.numGreyLevels, this.distance, this.orientation);
    }

    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        double res = 0.0;
        double[] coochxy = this.coocHXYFunc.calculate(matrix);
        res = Math.sqrt(1.0 - Math.exp(-2.0 * (coochxy[3] - this.entropy.calculate(input).get())));
        if (Double.isNaN(res)) {
            output.set(0.0);
        } else {
            output.set(res);
        }
    }
}

