/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter;

import net.imagej.ops.filter.fft.CreateOutputFFTMethods;
import net.imagej.ops.filter.pad.PadInputFFTMethods;
import net.imagej.ops.filter.pad.PadShiftKernelFFTMethods;
import net.imagej.ops.special.computer.AbstractBinaryComputerOp;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.function.BinaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import org.scijava.plugin.Parameter;

public abstract class AbstractPadAndFFTFilter<I extends RealType<I>, O extends RealType<O> & NativeType<O>, K extends RealType<K>, C extends ComplexType<C> & NativeType<C>>
extends AbstractBinaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> {
    @Parameter(required=false)
    private long[] borderSize = null;
    @Parameter(required=false)
    private OutOfBoundsFactory<I, RandomAccessibleInterval<I>> obfInput;
    @Parameter(required=false)
    private OutOfBoundsFactory<K, RandomAccessibleInterval<K>> obfKernel;
    @Parameter(required=false)
    private O outType;
    @Parameter(required=false)
    private C fftType;
    private BinaryFunctionOp<RandomAccessibleInterval<I>, Dimensions, RandomAccessibleInterval<I>> padOp;
    private BinaryFunctionOp<RandomAccessibleInterval<K>, Dimensions, RandomAccessibleInterval<K>> padKernelOp;
    private UnaryFunctionOp<Dimensions, RandomAccessibleInterval<C>> createOp;
    private BinaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> filter;

    @Override
    public void initialize() {
        super.initialize();
        this.padOp = Functions.binary(this.ops(), PadInputFFTMethods.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{true, this.obfInput});
        this.padKernelOp = Functions.binary(this.ops(), PadShiftKernelFFTMethods.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{true});
        if (this.fftType == null) {
            this.fftType = (ComplexType)this.ops().create().nativeType(ComplexFloatType.class);
        }
        this.createOp = Functions.unary(this.ops(), CreateOutputFFTMethods.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{this.fftType, true});
    }

    public RandomAccessibleInterval<O> createOutput(RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel) {
        if (this.outType == null) {
            if (((RealType)Util.getTypeFromInterval(input)).getClass() == ((RealType)Util.getTypeFromInterval(kernel)).getClass()) {
                Type temp = ((RealType)Util.getTypeFromInterval(input)).createVariable();
                this.outType = (RealType)temp;
            } else {
                FloatType temp = new FloatType();
                this.outType = (RealType)temp;
            }
        }
        return this.ops().create().img((Dimensions)input, (NativeType)this.outType.createVariable());
    }

    @Override
    public void compute(RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel, RandomAccessibleInterval<O> output) {
        int d;
        int numDimensions = input.numDimensions();
        long[] paddedSize = new long[numDimensions];
        if (this.borderSize == null) {
            for (d = 0; d < numDimensions; ++d) {
                paddedSize[d] = (int)input.dimension(d) + (int)kernel.dimension(d) - 1;
            }
        } else {
            for (d = 0; d < numDimensions; ++d) {
                paddedSize[d] = Math.max(kernel.dimension(d) + 2L * this.borderSize[d], input.dimension(d) + 2L * this.borderSize[d]);
            }
        }
        RandomAccessibleInterval<I> paddedInput = this.padOp.calculate(input, (Dimensions)new FinalDimensions(paddedSize));
        RandomAccessibleInterval<K> paddedKernel = this.padKernelOp.calculate(kernel, (Dimensions)new FinalDimensions(paddedSize));
        RandomAccessibleInterval<C> fftInput = this.createOp.calculate((Dimensions)new FinalDimensions(paddedSize));
        RandomAccessibleInterval<C> fftKernel = this.createOp.calculate((Dimensions)new FinalDimensions(paddedSize));
        this.filter = this.createFilterComputer(paddedInput, paddedKernel, fftInput, fftKernel, output);
        this.filter.compute(paddedInput, paddedKernel, output);
    }

    public abstract BinaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> createFilterComputer(RandomAccessibleInterval<I> var1, RandomAccessibleInterval<K> var2, RandomAccessibleInterval<C> var3, RandomAccessibleInterval<C> var4, RandomAccessibleInterval<O> var5);

    protected long[] getBorderSize() {
        return this.borderSize;
    }

    protected OutOfBoundsFactory<I, RandomAccessibleInterval<I>> getOBFInput() {
        return this.obfInput;
    }

    protected void setOBFInput(OutOfBoundsFactory<I, RandomAccessibleInterval<I>> objInput) {
        this.obfInput = objInput;
    }

    protected OutOfBoundsFactory<K, RandomAccessibleInterval<K>> getOBFKernel() {
        return this.obfKernel;
    }

    protected void setOBFKernel(OutOfBoundsFactory<K, RandomAccessibleInterval<K>> obfKernel) {
        this.obfKernel = obfKernel;
    }

    protected O getOutType() {
        return this.outType;
    }
}

