/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d.mesh;

import net.imagej.ops.Ops;
import net.imagej.ops.geom.geom3d.mesh.AbstractVertexInterpolator;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.VertexInterpolator.class)
public class DefaultVertexInterpolator
extends AbstractVertexInterpolator
implements Ops.Geometric.VertexInterpolator {
    @Parameter(type=ItemIO.INPUT)
    double isolevel;

    public void run() {
        this.output = new double[3];
        if (Math.abs(this.isolevel - this.p1Value) < 1.0E-5) {
            for (int i = 0; i < 3; ++i) {
                this.output[i] = this.p1[i];
            }
        } else if (Math.abs(this.isolevel - this.p2Value) < 1.0E-5) {
            for (int i = 0; i < 3; ++i) {
                this.output[i] = this.p2[i];
            }
        } else if (Math.abs(this.p1Value - this.p2Value) < 1.0E-5) {
            for (int i = 0; i < 3; ++i) {
                this.output[i] = this.p1[i];
            }
        } else {
            double mu = (this.isolevel - this.p1Value) / (this.p2Value - this.p1Value);
            this.output[0] = (double)this.p1[0] + mu * (double)(this.p2[0] - this.p1[0]);
            this.output[1] = (double)this.p1[1] + mu * (double)(this.p2[1] - this.p1[1]);
            this.output[2] = (double)this.p1[2] + mu * (double)(this.p2[2] - this.p1[2]);
        }
    }

    @Override
    public void setIsoLevel(double d) {
        this.isolevel = d;
    }
}

