/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.distancetransform;

import java.util.concurrent.Callable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;

class Phase1Runnable3DCal<B extends BooleanType<B>>
implements Callable<Void> {
    private final double[][][] tempValues;
    private final RandomAccess<B> raIn;
    private final int y;
    private final int z;
    private final double infinite;
    private final int width;
    private final double[] calibration;

    public Phase1Runnable3DCal(double[][][] tempValues, RandomAccessibleInterval<B> raIn, int yPos, int zPos, double[] calibration) {
        this.tempValues = tempValues;
        this.raIn = raIn.randomAccess();
        this.y = yPos;
        this.z = zPos;
        this.infinite = calibration[0] * (double)raIn.dimension(0) + calibration[1] * (double)raIn.dimension(1) + calibration[2] * (double)raIn.dimension(2);
        this.width = (int)raIn.dimension(0);
        this.calibration = calibration;
    }

    @Override
    public Void call() throws Exception {
        int x;
        this.raIn.setPosition(0, 0);
        this.raIn.setPosition(this.y, 1);
        this.raIn.setPosition(this.z, 2);
        this.tempValues[0][this.y][this.z] = !((BooleanType)this.raIn.get()).get() ? 0.0 : this.infinite;
        for (x = 1; x < this.width; ++x) {
            this.raIn.setPosition(x, 0);
            this.tempValues[x][this.y][this.z] = !((BooleanType)this.raIn.get()).get() ? 0.0 : this.tempValues[x - 1][this.y][this.z] + this.calibration[0];
        }
        for (x = this.width - 2; x >= 0; --x) {
            if (!(this.tempValues[x + 1][this.y][this.z] < this.tempValues[x][this.y][this.z])) continue;
            this.tempValues[x][this.y][this.z] = this.calibration[0] + this.tempValues[x + 1][this.y][this.z];
        }
        return null;
    }
}

