/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.GaussianGenerationCallback;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import math3d.Eigensystem2x2Double;
import math3d.Eigensystem2x2Float;
import math3d.Eigensystem3x3Double;
import math3d.Eigensystem3x3Float;
import math3d.JacobiDouble;
import math3d.JacobiFloat;

public class ComputeCurvatures
implements Runnable {
    private boolean _3D;
    private FloatArray data;
    private double[][] hessianMatrix;
    private float[] eigenValues = new float[3];
    private FloatArray3D[] result3D;
    private FloatArray3D result2D;
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;
    protected ImagePlus imp;
    protected double sigma;
    protected boolean useCalibration;
    protected GaussianGenerationCallback callback;
    private boolean cancelGeneration = false;

    public ComputeCurvatures() {
    }

    public ComputeCurvatures(ImagePlus imp, double sigma, GaussianGenerationCallback callback, boolean useCalibration) {
        this.imp = imp;
        this.sigma = sigma;
        this.callback = callback;
        this.useCalibration = useCalibration;
    }

    public void runAsPlugIn(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (null == this.imp) {
            IJ.error((String)"No images open.");
            return;
        }
        if (this.imp.getStackSize() > 1) {
            ImageStack stack = this.imp.getStack();
            this._3D = true;
            this.data = this.StackToFloatArray(stack);
            if (this.data == null) {
                return;
            }
        } else {
            this._3D = false;
            this.data = this.ImageToFloatArray(this.imp.getProcessor());
            if (this.data == null) {
                return;
            }
        }
        Calibration calibration = this.imp.getCalibration();
        double minimumSeparation = 1.0;
        if (calibration != null) {
            minimumSeparation = Math.min(calibration.pixelWidth, Math.min(calibration.pixelHeight, calibration.pixelDepth));
        }
        GenericDialog gd = new GenericDialog("Principle curvature computing");
        gd.addMessage("Options:");
        if (this._3D) {
            gd.addCheckbox("Show Eigenvalue 1 (smallest)", true);
            gd.addCheckbox("Show Eigenvalue 2", true);
            gd.addCheckbox("Show Eigenvalue 3 (largest)", true);
            gd.addMessage("");
        }
        gd.addCheckbox("Compute a gaussian convolution", true);
        gd.addMessage("Please define sigma (>= 0.5) for computing.");
        gd.addMessage("(Applies only if you wish to compute the convolution first)");
        gd.addNumericField("Sigma: ", calibration == null ? 0.5 : minimumSeparation / 2.0, 4);
        gd.addCheckbox("Use calibration information", calibration != null);
        gd.addCheckbox("Show Gauss Image", false);
        gd.addCheckbox("Order eigenvalues on absolute values", true);
        gd.addCheckbox("Normalize eigenvalues", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        boolean[] evaluesToShow = new boolean[3];
        if (this._3D) {
            evaluesToShow[0] = gd.getNextBoolean();
            evaluesToShow[1] = gd.getNextBoolean();
            evaluesToShow[2] = gd.getNextBoolean();
        }
        boolean computeGauss = gd.getNextBoolean();
        this.sigma = gd.getNextNumber();
        this.useCalibration = gd.getNextBoolean();
        boolean showGauss = gd.getNextBoolean();
        boolean orderOnAbsoluteValues = gd.getNextBoolean();
        boolean normalizeEigenValues = gd.getNextBoolean();
        if (computeGauss) {
            if (this._3D) {
                this.data = this.computeGaussianFastMirror((FloatArray3D)this.data, (float)this.sigma, (GaussianGenerationCallback)new TrivialProgressDisplayer(), (Calibration)(this.useCalibration ? calibration : null));
                if (showGauss) {
                    this.FloatArrayToStack((FloatArray3D)this.data, "Gauss image", 0.0f, 255.0f).show();
                }
            } else {
                this.data = this.computeGaussianFastMirror((FloatArray2D)this.data, (float)this.sigma, (GaussianGenerationCallback)new TrivialProgressDisplayer(), (Calibration)(this.useCalibration ? calibration : null));
                if (showGauss) {
                    ComputeCurvatures.FloatArrayToImagePlus((FloatArray2D)this.data, "Gauss image", 0.0f, 255.0f).show();
                }
            }
        } else {
            this.sigma = 1.0;
        }
        float sepX = 1.0f;
        float sepY = 1.0f;
        float sepZ = 1.0f;
        if (this.useCalibration && calibration != null) {
            sepX = (float)calibration.pixelWidth;
            sepY = (float)calibration.pixelHeight;
            sepZ = (float)calibration.pixelDepth;
        }
        if (this._3D) {
            FloatArray3D data3D = (FloatArray3D)this.data;
            this.result3D = new FloatArray3D[3];
            for (int i = 0; i < 3; ++i) {
                if (!evaluesToShow[i]) continue;
                this.result3D[i] = new FloatArray3D(data3D.width, data3D.height, data3D.depth);
            }
            IJ.showProgress((double)0.0);
            for (int z = 1; z < data3D.depth - 1; ++z) {
                for (int y = 1; y < data3D.height - 1; ++y) {
                    for (int x = 1; x < data3D.width - 1; ++x) {
                        int i;
                        if (this.hessianEigenvaluesAtPoint3D(x, y, z, orderOnAbsoluteValues, this.eigenValues, normalizeEigenValues, false, sepX, sepY, sepZ)) {
                            for (i = 0; i < 3; ++i) {
                                if (!evaluesToShow[i]) continue;
                                this.result3D[i].set(this.eigenValues[i], x, y, z);
                            }
                            if ((double)this.eigenValues[0] < this.min) {
                                this.min = this.eigenValues[0];
                            }
                            if ((double)this.eigenValues[1] < this.min) {
                                this.min = this.eigenValues[1];
                            }
                            if ((double)this.eigenValues[2] < this.min) {
                                this.min = this.eigenValues[2];
                            }
                            if ((double)this.eigenValues[0] > this.max) {
                                this.max = this.eigenValues[0];
                            }
                            if ((double)this.eigenValues[1] > this.max) {
                                this.max = this.eigenValues[1];
                            }
                            if (!((double)this.eigenValues[2] > this.max)) continue;
                            this.max = this.eigenValues[2];
                            continue;
                        }
                        for (i = 0; i < 3; ++i) {
                            if (!evaluesToShow[i]) continue;
                            this.result3D[i].set(0.0f, x, y, z);
                        }
                        if (0.0 < this.min) {
                            this.min = 0.0;
                        }
                        if (!(0.0 > this.max)) continue;
                        this.max = 0.0;
                    }
                }
                IJ.showProgress((double)((double)z / (double)data3D.depth));
            }
            IJ.showProgress((double)1.0);
        } else {
            FloatArray2D data2D = (FloatArray2D)this.data;
            this.result2D = new FloatArray3D(data2D.width, data2D.height, 2);
            for (int y = 1; y < data2D.height - 1; ++y) {
                for (int x = 1; x < data2D.width - 1; ++x) {
                    if (this.hessianEigenvaluesAtPoint2D(x, y, orderOnAbsoluteValues, this.eigenValues, normalizeEigenValues, false, sepX, sepY)) {
                        this.result2D.set(this.eigenValues[0], x, y, 0);
                        this.result2D.set(this.eigenValues[1], x, y, 1);
                        if ((double)this.eigenValues[0] < this.min) {
                            this.min = this.eigenValues[0];
                        }
                        if ((double)this.eigenValues[1] < this.min) {
                            this.min = this.eigenValues[1];
                        }
                        if ((double)this.eigenValues[0] > this.max) {
                            this.max = this.eigenValues[0];
                        }
                        if (!((double)this.eigenValues[1] > this.max)) continue;
                        this.max = this.eigenValues[1];
                        continue;
                    }
                    this.result2D.set(0.0f, x, y, 0);
                    this.result2D.set(0.0f, x, y, 1);
                    if (0.0 < this.min) {
                        this.min = 0.0;
                    }
                    if (!(0.0 > this.max)) continue;
                    this.max = 0.0;
                }
            }
        }
        if (this._3D) {
            for (int i = 0; i < 3; ++i) {
                if (!evaluesToShow[i]) continue;
                this.FloatArrayToStack(this.result3D[i], "Eigenvalues " + (i + 1), (float)this.min, (float)this.max).show();
            }
        } else {
            this.FloatArrayToStack(this.result2D, "Eigenvalues", (float)this.min, (float)this.max).show();
        }
    }

    public void cancelGaussianGeneration() {
        this.cancelGeneration = true;
    }

    @Override
    public void run() {
        if (this.imp == null) {
            IJ.error((String)"BUG: imp should not be null - are you using the right constructor?");
            return;
        }
        this.setup();
    }

    public void setup() {
        try {
            if (this.imp == null) {
                IJ.error((String)"BUG: imp should not be null - are you using the right constructor?");
                return;
            }
            if (this.callback != null) {
                this.callback.proportionDone(0.0);
            }
            if (this.imp.getStackSize() > 1) {
                ImageStack stack = this.imp.getStack();
                this._3D = true;
                this.data = this.StackToFloatArray(stack);
                if (this.data == null) {
                    return;
                }
            } else {
                this._3D = false;
                this.data = this.ImageToFloatArray(this.imp.getProcessor());
                if (this.data == null) {
                    return;
                }
            }
            boolean computeGauss = true;
            boolean showGauss = false;
            Calibration calibration = this.imp.getCalibration();
            if (this._3D) {
                this.data = this.computeGaussianFastMirror((FloatArray3D)this.data, (float)this.sigma, this.callback, (Calibration)(this.useCalibration ? calibration : null));
                if (this.data == null) {
                    if (this.callback != null) {
                        this.callback.proportionDone(-1.0);
                    }
                    return;
                }
                if (showGauss) {
                    this.FloatArrayToStack((FloatArray3D)this.data, "Gauss image", 0.0f, 255.0f).show();
                }
            } else {
                this.data = this.computeGaussianFastMirror((FloatArray2D)this.data, (float)this.sigma, this.callback, (Calibration)(this.useCalibration ? calibration : null));
                if (this.data == null) {
                    if (this.callback != null) {
                        this.callback.proportionDone(-1.0);
                    }
                    return;
                }
                if (showGauss) {
                    ComputeCurvatures.FloatArrayToImagePlus((FloatArray2D)this.data, "Gauss image", 0.0f, 255.0f).show();
                }
            }
        }
        catch (OutOfMemoryError e) {
            long requiredMiB = this.imp.getWidth() * this.imp.getHeight() * this.imp.getStackSize() * 4 / 0x100000;
            IJ.error((String)("Out of memory when calculating the Gaussian convolution of the image (requires " + requiredMiB + "MiB"));
            if (this.callback != null) {
                this.callback.proportionDone(-1.0);
            }
            return;
        }
    }

    public boolean hessianEigenvaluesAtPoint2D(int x, int y, boolean orderOnAbsoluteSize, float[] result, boolean normalize, boolean fixUp, float sepX, float sepY) {
        float e1c;
        float[][] hessianMatrix;
        float[] eigenValues;
        if (this._3D) {
            IJ.error((String)"hessianEigenvaluesAtPoint2D( x, y, z, ... ) is only for 2D data.");
            return false;
        }
        FloatArray2D data2D = (FloatArray2D)this.data;
        if (fixUp) {
            if (x == 0) {
                x = 1;
            }
            if (x == data2D.width - 1) {
                x = data2D.width - 2;
            }
            if (y == 0) {
                y = 1;
            }
            if (y == data2D.height - 1) {
                y = data2D.height - 2;
            }
        }
        if ((eigenValues = this.computeEigenValues(hessianMatrix = this.computeHessianMatrix2DFloat(data2D, x, y, this.sigma, sepX, sepY))) == null) {
            return false;
        }
        float e0 = eigenValues[0];
        float e1 = eigenValues[1];
        float e0c = orderOnAbsoluteSize ? Math.abs(e0) : e0;
        float f = e1c = orderOnAbsoluteSize ? Math.abs(e1) : e1;
        if (e0c <= e1c) {
            result[0] = e0;
            result[1] = e1;
        } else {
            result[0] = e1;
            result[1] = e0;
        }
        if (normalize) {
            float divideBy = Math.abs(result[1]);
            result[0] = result[0] / divideBy;
            result[1] = result[1] / divideBy;
        }
        return true;
    }

    public boolean hessianEigenvaluesAtPoint2D(int x, int y, boolean orderOnAbsoluteSize, double[] result, boolean normalize, boolean fixUp, float sepX, float sepY) {
        double e1c;
        double[][] hessianMatrix;
        double[] eigenValues;
        if (this._3D) {
            IJ.error((String)"hessianEigenvaluesAtPoint2D( x, y, z, ... ) is only for 2D data.");
            return false;
        }
        FloatArray2D data2D = (FloatArray2D)this.data;
        if (fixUp) {
            if (x == 0) {
                x = 1;
            }
            if (x == data2D.width - 1) {
                x = data2D.width - 2;
            }
            if (y == 0) {
                y = 1;
            }
            if (y == data2D.height - 1) {
                y = data2D.height - 2;
            }
        }
        if ((eigenValues = this.computeEigenValues(hessianMatrix = this.computeHessianMatrix2DDouble(data2D, x, y, this.sigma, sepX, sepY))) == null) {
            return false;
        }
        double e0 = eigenValues[0];
        double e1 = eigenValues[1];
        double e0c = orderOnAbsoluteSize ? Math.abs(e0) : e0;
        double d = e1c = orderOnAbsoluteSize ? Math.abs(e1) : e1;
        if (e0c <= e1c) {
            result[0] = e0;
            result[1] = e1;
        } else {
            result[0] = e1;
            result[1] = e0;
        }
        if (normalize) {
            double divideBy = Math.abs(result[1]);
            result[0] = result[0] / divideBy;
            result[1] = result[1] / divideBy;
        }
        return true;
    }

    public boolean hessianEigenvaluesAtPoint3D(int x, int y, int z, boolean orderOnAbsoluteSize, float[] result, boolean normalize, boolean fixUp, float sepX, float sepY, float sepZ) {
        float e2c;
        float[][] hessianMatrix;
        float[] eigenValues;
        if (!this._3D) {
            IJ.error((String)"hessianEigenvaluesAtPoint3D( x, y, z, ... ) is only for 3D data.");
            return false;
        }
        FloatArray3D data3D = (FloatArray3D)this.data;
        if (fixUp) {
            if (x == 0) {
                x = 1;
            }
            if (x == data3D.width - 1) {
                x = data3D.width - 2;
            }
            if (y == 0) {
                y = 1;
            }
            if (y == data3D.height - 1) {
                y = data3D.height - 2;
            }
            if (z == 0) {
                z = 1;
            }
            if (z == data3D.depth - 1) {
                z = data3D.depth - 2;
            }
        }
        if ((eigenValues = this.computeEigenValues(hessianMatrix = this.computeHessianMatrix3DFloat(data3D, x, y, z, this.sigma, sepX, sepY, sepZ))) == null) {
            return false;
        }
        float e0 = eigenValues[0];
        float e1 = eigenValues[1];
        float e2 = eigenValues[2];
        float e0c = orderOnAbsoluteSize ? Math.abs(e0) : e0;
        float e1c = orderOnAbsoluteSize ? Math.abs(e1) : e1;
        float f = e2c = orderOnAbsoluteSize ? Math.abs(e2) : e2;
        if (e0c <= e1c) {
            if (e1c <= e2c) {
                result[0] = e0;
                result[1] = e1;
                result[2] = e2;
            } else if (e0c <= e2c) {
                result[0] = e0;
                result[1] = e2;
                result[2] = e1;
            } else {
                result[0] = e2;
                result[1] = e0;
                result[2] = e1;
            }
        } else if (e0c <= e2c) {
            result[0] = e1;
            result[1] = e0;
            result[2] = e2;
        } else if (e1c <= e2c) {
            result[0] = e1;
            result[1] = e2;
            result[2] = e0;
        } else {
            result[0] = e2;
            result[1] = e1;
            result[2] = e0;
        }
        if (normalize) {
            float divideBy = Math.abs(result[2]);
            result[0] = result[0] / divideBy;
            result[1] = result[1] / divideBy;
            result[2] = result[2] / divideBy;
        }
        return true;
    }

    public boolean hessianEigenvaluesAtPoint3D(int x, int y, int z, boolean orderOnAbsoluteSize, double[] result, boolean normalize, boolean fixUp, float sepX, float sepY, float sepZ) {
        double e2c;
        double[][] hessianMatrix;
        double[] eigenValues;
        if (!this._3D) {
            IJ.error((String)"hessianEigenvaluesAtPoint3D( x, y, z, ... ) is only for 3D data.");
            return false;
        }
        FloatArray3D data3D = (FloatArray3D)this.data;
        if (fixUp) {
            if (x == 0) {
                x = 1;
            }
            if (x == data3D.width - 1) {
                x = data3D.width - 2;
            }
            if (y == 0) {
                y = 1;
            }
            if (y == data3D.height - 1) {
                y = data3D.height - 2;
            }
            if (z == 0) {
                z = 1;
            }
            if (z == data3D.depth - 1) {
                z = data3D.depth - 2;
            }
        }
        if ((eigenValues = this.computeEigenValues(hessianMatrix = this.computeHessianMatrix3DDouble(data3D, x, y, z, this.sigma, sepX, sepY, sepZ))) == null) {
            return false;
        }
        double e0 = eigenValues[0];
        double e1 = eigenValues[1];
        double e2 = eigenValues[2];
        double e0c = orderOnAbsoluteSize ? Math.abs(e0) : e0;
        double e1c = orderOnAbsoluteSize ? Math.abs(e1) : e1;
        double d = e2c = orderOnAbsoluteSize ? Math.abs(e2) : e2;
        if (e0c <= e1c) {
            if (e1c <= e2c) {
                result[0] = e0;
                result[1] = e1;
                result[2] = e2;
            } else if (e0c <= e2c) {
                result[0] = e0;
                result[1] = e2;
                result[2] = e1;
            } else {
                result[0] = e2;
                result[1] = e0;
                result[2] = e1;
            }
        } else if (e0c <= e2c) {
            result[0] = e1;
            result[1] = e0;
            result[2] = e2;
        } else if (e1c <= e2c) {
            result[0] = e1;
            result[1] = e2;
            result[2] = e0;
        } else {
            result[0] = e2;
            result[1] = e1;
            result[2] = e0;
        }
        if (normalize) {
            double divideBy = Math.abs(result[2]);
            result[0] = result[0] / divideBy;
            result[1] = result[1] / divideBy;
            result[2] = result[2] / divideBy;
        }
        return true;
    }

    public static ImagePlus FloatArrayToImagePlus(FloatArray2D image, String name, float min, float max) {
        ImagePlus imp = IJ.createImage((String)name, (String)"32-Bit Black", (int)image.width, (int)image.height, (int)1);
        FloatProcessor ip = (FloatProcessor)imp.getProcessor();
        ComputeCurvatures.FloatArrayToFloatProcessor((ImageProcessor)ip, image);
        if (min == max) {
            ip.resetMinAndMax();
        } else {
            ip.setMinAndMax((double)min, (double)max);
        }
        imp.updateAndDraw();
        return imp;
    }

    public static void FloatArrayToFloatProcessor(ImageProcessor ip, FloatArray2D pixels) {
        float[] data = new float[pixels.width * pixels.height];
        int count = 0;
        for (int y = 0; y < pixels.height; ++y) {
            for (int x = 0; x < pixels.width; ++x) {
                data[count] = pixels.data[count++];
            }
        }
        ip.setPixels((Object)data);
        ip.resetMinAndMax();
    }

    public ImagePlus FloatArrayToStack(FloatArray3D image, String name, float min, float max) {
        int width = image.width;
        int height = image.height;
        int nstacks = image.depth;
        ImageStack stack = new ImageStack(width, height);
        for (int slice = 0; slice < nstacks; ++slice) {
            ImagePlus impResult = IJ.createImage((String)name, (String)"32-Bit Black", (int)width, (int)height, (int)1);
            ImageProcessor ipResult = impResult.getProcessor();
            float[] sliceImg = new float[width * height];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    sliceImg[y * width + x] = image.get(x, y, slice);
                }
            }
            ipResult.setPixels((Object)sliceImg);
            if (min == max) {
                ipResult.resetMinAndMax();
            } else {
                ipResult.setMinAndMax((double)min, (double)max);
            }
            stack.addSlice("Slice " + slice, ipResult);
        }
        return new ImagePlus(name, stack);
    }

    public double[] computeEigenValues(double[][] matrix) {
        if (matrix.length == 3 && matrix[0].length == 3) {
            Eigensystem3x3Double e = new Eigensystem3x3Double(matrix);
            boolean result = e.findEvalues();
            return result ? e.getEvaluesCopy() : null;
        }
        if (matrix.length == 2 && matrix[0].length == 2) {
            Eigensystem2x2Double e = new Eigensystem2x2Double(matrix);
            boolean result = e.findEvalues();
            return result ? e.getEvaluesCopy() : null;
        }
        JacobiDouble jc = new JacobiDouble(matrix, 50);
        return jc.getEigenValues();
    }

    public float[] computeEigenValues(float[][] matrix) {
        if (matrix.length == 3 && matrix[0].length == 3) {
            Eigensystem3x3Float e = new Eigensystem3x3Float(matrix);
            boolean result = e.findEvalues();
            return result ? e.getEvaluesCopy() : null;
        }
        if (matrix.length == 2 && matrix[0].length == 2) {
            Eigensystem2x2Float e = new Eigensystem2x2Float(matrix);
            boolean result = e.findEvalues();
            return result ? e.getEvaluesCopy() : null;
        }
        JacobiFloat jc = new JacobiFloat(matrix, 50);
        return jc.getEigenValues();
    }

    public double[][] computeHessianMatrix2DDouble(FloatArray2D laPlace, int x, int y, double sigma, float sepX, float sepY) {
        if (laPlace == null) {
            laPlace = (FloatArray2D)this.data;
        }
        double[][] hessianMatrix = new double[2][2];
        double temp = 2.0f * laPlace.get(x, y);
        hessianMatrix[0][0] = (double)laPlace.get(x + 1, y) - temp + (double)laPlace.get(x - 1, y);
        hessianMatrix[1][1] = (double)laPlace.get(x, y + 1) - temp + (double)laPlace.get(x, y - 1);
        double d = ((laPlace.get(x + 1, y + 1) - laPlace.get(x - 1, y + 1)) / 2.0f - (laPlace.get(x + 1, y - 1) - laPlace.get(x - 1, y - 1)) / 2.0f) / 2.0f;
        hessianMatrix[1][0] = d;
        hessianMatrix[0][1] = d;
        for (int i = 0; i < 2; ++i) {
            int j = 0;
            while (j < 2) {
                double[] dArray = hessianMatrix[i];
                int n = j++;
                dArray[n] = dArray[n] * (sigma * sigma);
            }
        }
        return hessianMatrix;
    }

    public float[][] computeHessianMatrix2DFloat(FloatArray2D laPlace, int x, int y, double sigma, float sepX, float sepY) {
        if (laPlace == null) {
            laPlace = (FloatArray2D)this.data;
        }
        float[][] hessianMatrix = new float[2][2];
        float temp = 2.0f * laPlace.get(x, y);
        hessianMatrix[0][0] = laPlace.get(x + 1, y) - temp + laPlace.get(x - 1, y);
        hessianMatrix[1][1] = laPlace.get(x, y + 1) - temp + laPlace.get(x, y - 1);
        float f = ((laPlace.get(x + 1, y + 1) - laPlace.get(x - 1, y + 1)) / 2.0f - (laPlace.get(x + 1, y - 1) - laPlace.get(x - 1, y - 1)) / 2.0f) / 2.0f;
        hessianMatrix[1][0] = f;
        hessianMatrix[0][1] = f;
        for (int i = 0; i < 2; ++i) {
            int j = 0;
            while (j < 2) {
                float[] fArray = hessianMatrix[i];
                int n = j++;
                fArray[n] = (float)((double)fArray[n] * (sigma * sigma));
            }
        }
        return hessianMatrix;
    }

    public double[][] computeHessianMatrix3DDouble(FloatArray3D img, int x, int y, int z, double sigma, float sepX, float sepY, float sepZ) {
        if (img == null) {
            img = (FloatArray3D)this.data;
        }
        double[][] hessianMatrix = new double[3][3];
        double temp = 2.0f * img.get(x, y, z);
        hessianMatrix[0][0] = (double)img.get(x + 1, y, z) - temp + (double)img.get(x - 1, y, z);
        hessianMatrix[1][1] = (double)img.get(x, y + 1, z) - temp + (double)img.get(x, y - 1, z);
        hessianMatrix[2][2] = (double)img.get(x, y, z + 1) - temp + (double)img.get(x, y, z - 1);
        double d = ((img.get(x + 1, y + 1, z) - img.get(x - 1, y + 1, z)) / 2.0f - (img.get(x + 1, y - 1, z) - img.get(x - 1, y - 1, z)) / 2.0f) / 2.0f;
        hessianMatrix[1][0] = d;
        hessianMatrix[0][1] = d;
        double d2 = ((img.get(x + 1, y, z + 1) - img.get(x - 1, y, z + 1)) / 2.0f - (img.get(x + 1, y, z - 1) - img.get(x - 1, y, z - 1)) / 2.0f) / 2.0f;
        hessianMatrix[2][0] = d2;
        hessianMatrix[0][2] = d2;
        double d3 = ((img.get(x, y + 1, z + 1) - img.get(x, y - 1, z + 1)) / 2.0f - (img.get(x, y + 1, z - 1) - img.get(x, y - 1, z - 1)) / 2.0f) / 2.0f;
        hessianMatrix[2][1] = d3;
        hessianMatrix[1][2] = d3;
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                double[] dArray = hessianMatrix[i];
                int n = j++;
                dArray[n] = dArray[n] * (sigma * sigma);
            }
        }
        return hessianMatrix;
    }

    public float[][] computeHessianMatrix3DFloat(FloatArray3D img, int x, int y, int z, double sigma, float sepX, float sepY, float sepZ) {
        if (img == null) {
            img = (FloatArray3D)this.data;
        }
        float[][] hessianMatrix = new float[3][3];
        float temp = 2.0f * img.get(x, y, z);
        hessianMatrix[0][0] = img.get(x + 1, y, z) - temp + img.get(x - 1, y, z);
        hessianMatrix[1][1] = img.get(x, y + 1, z) - temp + img.get(x, y - 1, z);
        hessianMatrix[2][2] = img.get(x, y, z + 1) - temp + img.get(x, y, z - 1);
        float f = ((img.get(x + 1, y + 1, z) - img.get(x - 1, y + 1, z)) / 2.0f - (img.get(x + 1, y - 1, z) - img.get(x - 1, y - 1, z)) / 2.0f) / 2.0f;
        hessianMatrix[1][0] = f;
        hessianMatrix[0][1] = f;
        float f2 = ((img.get(x + 1, y, z + 1) - img.get(x - 1, y, z + 1)) / 2.0f - (img.get(x + 1, y, z - 1) - img.get(x - 1, y, z - 1)) / 2.0f) / 2.0f;
        hessianMatrix[2][0] = f2;
        hessianMatrix[0][2] = f2;
        float f3 = ((img.get(x, y + 1, z + 1) - img.get(x, y - 1, z + 1)) / 2.0f - (img.get(x, y + 1, z - 1) - img.get(x, y - 1, z - 1)) / 2.0f) / 2.0f;
        hessianMatrix[2][1] = f3;
        hessianMatrix[1][2] = f3;
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                float[] fArray = hessianMatrix[i];
                int n = j++;
                fArray[n] = (float)((double)fArray[n] * (sigma * sigma));
            }
        }
        return hessianMatrix;
    }

    public static float[] createGaussianKernel1D(float sigma, boolean normalize) {
        float[] gaussianKernel;
        if (sigma <= 0.0f) {
            gaussianKernel = new float[3];
            gaussianKernel[1] = 1.0f;
        } else {
            int size = Math.max(3, 2 * (int)((double)(3.0f * sigma) + 0.5) + 1);
            float two_sq_sigma = 2.0f * sigma * sigma;
            gaussianKernel = new float[size];
            for (int x = size / 2; x >= 0; --x) {
                float val;
                gaussianKernel[size / 2 - x] = val = (float)Math.exp(-((float)(x * x)) / two_sq_sigma);
                gaussianKernel[size / 2 + x] = val;
            }
        }
        if (normalize) {
            int i;
            float sum = 0.0f;
            for (i = 0; i < gaussianKernel.length; ++i) {
                sum += gaussianKernel[i];
            }
            i = 0;
            while (i < gaussianKernel.length) {
                int n = i++;
                gaussianKernel[n] = gaussianKernel[n] / sum;
            }
        }
        return gaussianKernel;
    }

    public FloatArray2D computeGaussianFastMirror(FloatArray2D input, float sigma, GaussianGenerationCallback callback, Calibration calibration) {
        float avg;
        int x;
        int i;
        FloatArray2D output = new FloatArray2D(input.width, input.height);
        float kernelsumX = 0.0f;
        float kernelsumY = 0.0f;
        float kernelsumZ = 0.0f;
        float pixelWidth = 1.0f;
        float pixelHeight = 1.0f;
        float pixelDepth = 1.0f;
        if (calibration != null) {
            pixelWidth = (float)calibration.pixelWidth;
            pixelHeight = (float)calibration.pixelHeight;
            pixelDepth = (float)calibration.pixelDepth;
        }
        float[] kernelX = ComputeCurvatures.createGaussianKernel1D(sigma / pixelWidth, true);
        float[] kernelY = ComputeCurvatures.createGaussianKernel1D(sigma / pixelHeight, true);
        int filterSizeX = kernelX.length;
        int filterSizeY = kernelY.length;
        for (i = 0; i < kernelX.length; ++i) {
            kernelsumX += kernelX[i];
        }
        for (i = 0; i < kernelY.length; ++i) {
            kernelsumY += kernelY[i];
        }
        double totalPoints = input.width * input.height * 2;
        long pointsDone = 0L;
        for (x = 0; x < input.width; ++x) {
            if (this.cancelGeneration) {
                return null;
            }
            for (int y = 0; y < input.height; ++y) {
                int f;
                avg = 0.0f;
                if (x - filterSizeX / 2 >= 0 && x + filterSizeX / 2 < input.width) {
                    for (f = -filterSizeX / 2; f <= filterSizeX / 2; ++f) {
                        avg += input.get(x + f, y) * kernelX[f + filterSizeX / 2];
                    }
                } else {
                    for (f = -filterSizeX / 2; f <= filterSizeX / 2; ++f) {
                        avg += input.getMirror(x + f, y) * kernelX[f + filterSizeX / 2];
                    }
                }
                output.set(avg / kernelsumX, x, y);
            }
            pointsDone += (long)input.height;
            if (callback == null) continue;
            callback.proportionDone((double)pointsDone / totalPoints);
        }
        for (x = 0; x < input.width; ++x) {
            int y;
            if (this.cancelGeneration) {
                return null;
            }
            float[] temp = new float[input.height];
            for (y = 0; y < input.height; ++y) {
                int f;
                avg = 0.0f;
                if (y - filterSizeY / 2 >= 0 && y + filterSizeY / 2 < input.height) {
                    for (f = -filterSizeY / 2; f <= filterSizeY / 2; ++f) {
                        avg += output.get(x, y + f) * kernelY[f + filterSizeY / 2];
                    }
                } else {
                    for (f = -filterSizeY / 2; f <= filterSizeY / 2; ++f) {
                        avg += output.getMirror(x, y + f) * kernelY[f + filterSizeY / 2];
                    }
                }
                temp[y] = avg / kernelsumY;
            }
            for (y = 0; y < input.height; ++y) {
                output.set(temp[y], x, y);
            }
            pointsDone += (long)input.height;
            if (callback == null || !((double)pointsDone < totalPoints)) continue;
            callback.proportionDone((double)pointsDone / totalPoints);
        }
        if (callback != null) {
            callback.proportionDone(1.0);
        }
        return output;
    }

    public FloatArray3D computeGaussianFastMirror(FloatArray3D input, float sigma, GaussianGenerationCallback callback, Calibration calibration) {
        int f;
        float avg;
        int y;
        int x;
        int i;
        FloatArray3D output = new FloatArray3D(input.width, input.height, input.depth);
        float kernelsumX = 0.0f;
        float kernelsumY = 0.0f;
        float kernelsumZ = 0.0f;
        float pixelWidth = 1.0f;
        float pixelHeight = 1.0f;
        float pixelDepth = 1.0f;
        if (calibration != null) {
            pixelWidth = (float)calibration.pixelWidth;
            pixelHeight = (float)calibration.pixelHeight;
            pixelDepth = (float)calibration.pixelDepth;
        }
        float[] kernelX = ComputeCurvatures.createGaussianKernel1D(sigma / pixelWidth, true);
        float[] kernelY = ComputeCurvatures.createGaussianKernel1D(sigma / pixelHeight, true);
        float[] kernelZ = ComputeCurvatures.createGaussianKernel1D(sigma / pixelDepth, true);
        int filterSizeX = kernelX.length;
        int filterSizeY = kernelY.length;
        int filterSizeZ = kernelZ.length;
        for (i = 0; i < kernelX.length; ++i) {
            kernelsumX += kernelX[i];
        }
        for (i = 0; i < kernelY.length; ++i) {
            kernelsumY += kernelY[i];
        }
        for (i = 0; i < kernelZ.length; ++i) {
            kernelsumZ += kernelZ[i];
        }
        double totalPoints = input.width * input.height * input.depth * 3;
        long pointsDone = 0L;
        for (x = 0; x < input.width; ++x) {
            if (this.cancelGeneration) {
                return null;
            }
            for (y = 0; y < input.height; ++y) {
                for (int z = 0; z < input.depth; ++z) {
                    int f2;
                    avg = 0.0f;
                    if (x - filterSizeX / 2 >= 0 && x + filterSizeX / 2 < input.width) {
                        for (f2 = -filterSizeX / 2; f2 <= filterSizeX / 2; ++f2) {
                            avg += input.get(x + f2, y, z) * kernelX[f2 + filterSizeX / 2];
                        }
                    } else {
                        for (f2 = -filterSizeX / 2; f2 <= filterSizeX / 2; ++f2) {
                            avg += input.getMirror(x + f2, y, z) * kernelX[f2 + filterSizeX / 2];
                        }
                    }
                    output.set(avg / kernelsumX, x, y, z);
                }
            }
            pointsDone += (long)(input.height * input.depth);
            if (callback == null) continue;
            callback.proportionDone((double)pointsDone / totalPoints);
        }
        for (x = 0; x < input.width; ++x) {
            if (this.cancelGeneration) {
                return null;
            }
            for (int z = 0; z < input.depth; ++z) {
                int y2;
                float[] temp = new float[input.height];
                for (y2 = 0; y2 < input.height; ++y2) {
                    avg = 0.0f;
                    if (y2 - filterSizeY / 2 >= 0 && y2 + filterSizeY / 2 < input.height) {
                        for (f = -filterSizeY / 2; f <= filterSizeY / 2; ++f) {
                            avg += output.get(x, y2 + f, z) * kernelY[f + filterSizeY / 2];
                        }
                    } else {
                        for (f = -filterSizeY / 2; f <= filterSizeY / 2; ++f) {
                            avg += output.getMirror(x, y2 + f, z) * kernelY[f + filterSizeY / 2];
                        }
                    }
                    temp[y2] = avg / kernelsumY;
                }
                for (y2 = 0; y2 < input.height; ++y2) {
                    output.set(temp[y2], x, y2, z);
                }
            }
            pointsDone += (long)(input.depth * input.height);
            if (callback == null) continue;
            callback.proportionDone((double)pointsDone / totalPoints);
        }
        for (x = 0; x < input.width; ++x) {
            if (this.cancelGeneration) {
                return null;
            }
            for (y = 0; y < input.height; ++y) {
                int z;
                float[] temp = new float[input.depth];
                for (z = 0; z < input.depth; ++z) {
                    avg = 0.0f;
                    if (z - filterSizeZ / 2 >= 0 && z + filterSizeZ / 2 < input.depth) {
                        for (f = -filterSizeZ / 2; f <= filterSizeZ / 2; ++f) {
                            avg += output.get(x, y, z + f) * kernelZ[f + filterSizeZ / 2];
                        }
                    } else {
                        for (f = -filterSizeZ / 2; f <= filterSizeZ / 2; ++f) {
                            avg += output.getMirror(x, y, z + f) * kernelZ[f + filterSizeZ / 2];
                        }
                    }
                    temp[z] = avg / kernelsumZ;
                }
                for (z = 0; z < input.depth; ++z) {
                    output.set(temp[z], x, y, z);
                }
            }
            pointsDone += (long)(input.height * input.depth);
            if (callback == null || !((double)pointsDone < totalPoints)) continue;
            callback.proportionDone((double)pointsDone / totalPoints);
        }
        if (callback != null) {
            callback.proportionDone(1.0);
        }
        return output;
    }

    public FloatArray3D StackToFloatArray(ImageStack stack) {
        int width = stack.getWidth();
        int height = stack.getHeight();
        int nstacks = stack.getSize();
        Object[] imageStack = new Object[nstacks];
        if (nstacks == 0) {
            IJ.error((String)"Image Stack is empty.");
            return null;
        }
        for (int z = 0; z < nstacks; ++z) {
            imageStack[z] = stack.getPixels(z + 1);
        }
        if (imageStack[0] instanceof int[]) {
            IJ.error((String)"RGB images not supported at the moment.");
            return null;
        }
        FloatArray3D pixels = new FloatArray3D(width, height, nstacks);
        if (imageStack[0] instanceof byte[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                byte[] pixelTmp = (byte[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = pixelTmp[count++] & 0xFF;
                    }
                }
            }
        } else if (imageStack[0] instanceof short[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                short[] pixelTmp = (short[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = pixelTmp[count++] & 0xFFFF;
                    }
                }
            }
        } else {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                float[] pixelTmp = (float[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = pixelTmp[count++];
                    }
                }
            }
        }
        return pixels;
    }

    public FloatArray2D ImageToFloatArray(ImageProcessor ip) {
        FloatArray2D image;
        Object pixelArray = ip.getPixels();
        int count = 0;
        if (ip instanceof ByteProcessor) {
            image = new FloatArray2D(ip.getWidth(), ip.getHeight());
            byte[] pixels = (byte[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.data[count] = pixels[count++] & 0xFF;
                }
            }
        } else if (ip instanceof ShortProcessor) {
            image = new FloatArray2D(ip.getWidth(), ip.getHeight());
            short[] pixels = (short[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.data[count] = pixels[count++] & 0xFFFF;
                }
            }
        } else if (ip instanceof FloatProcessor) {
            image = new FloatArray2D(ip.getWidth(), ip.getHeight());
            float[] pixels = (float[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.data[count] = pixels[count++];
                }
            }
        } else {
            IJ.error((String)"RGB images not supported");
            image = null;
        }
        return image;
    }

    public class FloatArray3D
    extends FloatArray {
        public float[] data;
        public int width;
        public int height;
        public int depth;

        public FloatArray3D(float[] data, int width, int height, int depth) {
            this.data = null;
            this.width = 0;
            this.height = 0;
            this.depth = 0;
            this.data = data;
            this.width = width;
            this.height = height;
            this.depth = depth;
        }

        public FloatArray3D(int width, int height, int depth) {
            this.data = null;
            this.width = 0;
            this.height = 0;
            this.depth = 0;
            this.data = new float[width * height * depth];
            this.width = width;
            this.height = height;
            this.depth = depth;
        }

        @Override
        public FloatArray3D clone() {
            FloatArray3D clone = new FloatArray3D(this.width, this.height, this.depth);
            System.arraycopy(this.data, 0, clone.data, 0, this.data.length);
            return clone;
        }

        public int getPos(int x, int y, int z) {
            return x + this.width * (y + z * this.height);
        }

        public float get(int x, int y, int z) {
            return this.data[this.getPos(x, y, z)];
        }

        public float getMirror(int x, int y, int z) {
            int dir;
            int tmp;
            if (x >= this.width) {
                x = this.width - (x - this.width + 2);
            }
            if (y >= this.height) {
                y = this.height - (y - this.height + 2);
            }
            if (z >= this.depth) {
                z = this.depth - (z - this.depth + 2);
            }
            if (x < 0) {
                tmp = 0;
                dir = 1;
                while (x < 0) {
                    if ((tmp += dir) == this.width - 1 || tmp == 0) {
                        dir *= -1;
                    }
                    ++x;
                }
                x = tmp;
            }
            if (y < 0) {
                tmp = 0;
                dir = 1;
                while (y < 0) {
                    if ((tmp += dir) == this.height - 1 || tmp == 0) {
                        dir *= -1;
                    }
                    ++y;
                }
                y = tmp;
            }
            if (z < 0) {
                tmp = 0;
                dir = 1;
                while (z < 0) {
                    if ((tmp += dir) == this.height - 1 || tmp == 0) {
                        dir *= -1;
                    }
                    ++z;
                }
                z = tmp;
            }
            return this.data[this.getPos(x, y, z)];
        }

        public void set(float value, int x, int y, int z) {
            this.data[this.getPos((int)x, (int)y, (int)z)] = value;
        }

        public FloatArray2D getXPlane(int x) {
            FloatArray2D plane = new FloatArray2D(this.height, this.depth);
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    plane.set(this.get(x, y, z), y, z);
                }
            }
            return plane;
        }

        public float[][] getXPlane_float(int x) {
            float[][] plane = new float[this.height][this.depth];
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    plane[y][z] = this.get(x, y, z);
                }
            }
            return plane;
        }

        public FloatArray2D getYPlane(int y) {
            FloatArray2D plane = new FloatArray2D(this.width, this.depth);
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    plane.set(this.get(x, y, z), x, z);
                }
            }
            return plane;
        }

        public float[][] getYPlane_float(int y) {
            float[][] plane = new float[this.width][this.depth];
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    plane[x][z] = this.get(x, y, z);
                }
            }
            return plane;
        }

        public FloatArray2D getZPlane(int z) {
            FloatArray2D plane = new FloatArray2D(this.width, this.height);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    plane.set(this.get(x, y, z), x, y);
                }
            }
            return plane;
        }

        public float[][] getZPlane_float(int z) {
            float[][] plane = new float[this.width][this.height];
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    plane[x][y] = this.get(x, y, z);
                }
            }
            return plane;
        }

        public void setXPlane(FloatArray2D plane, int x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    this.set(plane.get(y, z), x, y, z);
                }
            }
        }

        public void setXPlane(float[][] plane, int x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    this.set(plane[y][z], x, y, z);
                }
            }
        }

        public void setYPlane(FloatArray2D plane, int y) {
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    this.set(plane.get(x, z), x, y, z);
                }
            }
        }

        public void setYPlane(float[][] plane, int y) {
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    this.set(plane[x][z], x, y, z);
                }
            }
        }

        public void setZPlane(FloatArray2D plane, int z) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    this.set(plane.get(x, y), x, y, z);
                }
            }
        }

        public void setZPlane(float[][] plane, int z) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    this.set(plane[x][y], x, y, z);
                }
            }
        }
    }

    public class FloatArray2D
    extends FloatArray {
        public float[] data;
        public int width;
        public int height;

        public FloatArray2D(int width, int height) {
            this.data = null;
            this.width = 0;
            this.height = 0;
            this.data = new float[width * height];
            this.width = width;
            this.height = height;
        }

        public FloatArray2D(float[] data, int width, int height) {
            this.data = null;
            this.width = 0;
            this.height = 0;
            this.data = data;
            this.width = width;
            this.height = height;
        }

        @Override
        public FloatArray2D clone() {
            FloatArray2D clone = new FloatArray2D(this.width, this.height);
            System.arraycopy(this.data, 0, clone.data, 0, this.data.length);
            return clone;
        }

        public int getPos(int x, int y) {
            return x + this.width * y;
        }

        public float get(int x, int y) {
            return this.data[this.getPos(x, y)];
        }

        public float getMirror(int x, int y) {
            int dir;
            int tmp;
            if (x >= this.width) {
                x = this.width - (x - this.width + 2);
            }
            if (y >= this.height) {
                y = this.height - (y - this.height + 2);
            }
            if (x < 0) {
                tmp = 0;
                dir = 1;
                while (x < 0) {
                    if ((tmp += dir) == this.width - 1 || tmp == 0) {
                        dir *= -1;
                    }
                    ++x;
                }
                x = tmp;
            }
            if (y < 0) {
                tmp = 0;
                dir = 1;
                while (y < 0) {
                    if ((tmp += dir) == this.height - 1 || tmp == 0) {
                        dir *= -1;
                    }
                    ++y;
                }
                y = tmp;
            }
            return this.data[this.getPos(x, y)];
        }

        public float getZero(int x, int y) {
            if (x >= this.width) {
                return 0.0f;
            }
            if (y >= this.height) {
                return 0.0f;
            }
            if (x < 0) {
                return 0.0f;
            }
            if (y < 0) {
                return 0.0f;
            }
            return this.data[this.getPos(x, y)];
        }

        public void set(float value, int x, int y) {
            this.data[this.getPos((int)x, (int)y)] = value;
        }
    }

    public abstract class FloatArray {
        public float[] data = null;

        public abstract FloatArray clone();
    }

    static class TrivialProgressDisplayer
    implements GaussianGenerationCallback {
        TrivialProgressDisplayer() {
        }

        @Override
        public void proportionDone(double proportion) {
            if (proportion < 0.0) {
                IJ.showProgress((double)1.0);
            } else {
                IJ.showProgress((double)proportion);
            }
        }
    }
}

