/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import ij.gui.ShapeRoi;
import java.awt.Point;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Iterator;

public class Utils {
    public static final ShapeRoi toShapeRoi(PathIterator iter) {
        ArrayList<Float> pathData = new ArrayList<Float>();
        while (!iter.isDone()) {
            float[] values = new float[6];
            int type = iter.currentSegment(values);
            pathData.add(Float.valueOf(type));
            if (type == 0 || type == 1) {
                pathData.add(Float.valueOf(values[0]));
                pathData.add(Float.valueOf(values[1]));
            } else if (type != 4) {
                throw new UnsupportedOperationException("upgrade ShapeBuilder " + type);
            }
            iter.next();
        }
        float[] floatRepresentation = new float[pathData.size()];
        for (int i = 0; i < floatRepresentation.length; ++i) {
            floatRepresentation[i] = ((Float)pathData.get(i)).floatValue();
        }
        return new ShapeRoi(floatRepresentation);
    }

    public static void main(String[] args) {
        Spiral s = new Spiral(new Point(5, 5));
        for (int i = 0; i < 20; ++i) {
            System.out.println(s.next());
        }
    }

    public static class Spiral
    implements Iterator<Point> {
        private Point currentCorner;
        private Point currentPoint;
        int depth = 0;
        boolean applyX = false;

        public Spiral(Point start) {
            this.currentPoint = new Point(start.x, start.y);
            this.currentCorner = new Point(start.x, start.y);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        public Point nextCorner() {
            int modAmount;
            int n = modAmount = this.depth % 2 == 0 ? this.depth : -this.depth;
            if (this.applyX) {
                this.applyX = false;
                this.currentCorner.x += modAmount;
            } else {
                this.applyX = true;
                this.currentCorner.y += modAmount;
                ++this.depth;
            }
            return this.currentCorner;
        }

        @Override
        public Point next() {
            int yDiff;
            int xDiff;
            if (this.currentPoint.equals(this.currentCorner)) {
                this.currentCorner = this.nextCorner();
            }
            if ((xDiff = this.currentPoint.x - this.currentCorner.x) > 0) {
                --this.currentPoint.x;
            }
            if (xDiff < 0) {
                ++this.currentPoint.x;
            }
            if ((yDiff = this.currentPoint.y - this.currentCorner.y) > 0) {
                --this.currentPoint.y;
            }
            if (yDiff < 0) {
                ++this.currentPoint.y;
            }
            return this.currentPoint;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

