/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class DistanceTransform3D {
    private static final float SQ1 = 1.0f;
    private static final float SQ2 = (float)Math.sqrt(2.0);
    private static final float SQ3 = (float)Math.sqrt(3.0);
    private final float[] ML = new float[]{SQ3, SQ2, SQ3, SQ2, 1.0f, SQ2, SQ3, SQ2, SQ3, SQ2, 1.0f, SQ2, 1.0f};
    private final float[] MR = new float[]{1.0f, SQ2, 1.0f, SQ2, SQ3, SQ2, SQ3, SQ2, 1.0f, SQ2, SQ3, SQ2, SQ3};
    protected ImagePlus image;
    protected int w;
    protected int h;
    protected int d;
    protected float[][] dist;
    protected float maxVal;
    protected int fg = 255;

    public ImagePlus getTransformed(ImagePlus image, int fg) {
        this.image = image;
        this.fg = fg;
        this.init();
        this.forwardPass();
        this.backwardPass();
        return this.toFloat();
    }

    public float[][] getDistances() {
        return this.dist;
    }

    public void init(float[][] dist, int w, int h, int d) {
        this.dist = dist;
        this.w = w;
        this.h = h;
        this.d = d;
        this.maxVal = (float)Math.sqrt(w * w + h * h + d * d);
    }

    public void init() {
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.d = this.image.getStackSize();
        this.maxVal = (float)Math.sqrt(this.w * this.w + this.h * this.h + this.d * this.d);
        this.dist = new float[this.d][this.w * this.h];
        for (int z = 0; z < this.d; ++z) {
            byte[] pixels = (byte[])this.image.getStack().getProcessor(z + 1).getPixels();
            for (int i = 0; i < this.w * this.h; ++i) {
                this.dist[z][i] = (pixels[i] & 0xFF) == this.fg ? 0.0f : this.maxVal;
            }
        }
    }

    private float dist(int x, int y, int z) {
        if (x < 0 || x >= this.w || y < 0 || y >= this.h || z < 0 || z >= this.d) {
            return -this.maxVal;
        }
        return this.dist[z][y * this.w + x];
    }

    public void forwardPass() {
        float[] D = new float[13];
        for (int z = 0; z < this.d; ++z) {
            for (int y = 0; y < this.h; ++y) {
                for (int x = 0; x < this.w; ++x) {
                    if (this.dist[z][y * this.w + x] == 0.0f) continue;
                    D[0] = this.ML[0] + this.dist(x - 1, y - 1, z - 1);
                    D[1] = this.ML[1] + this.dist(x, y - 1, z - 1);
                    D[2] = this.ML[2] + this.dist(x + 1, y - 1, z - 1);
                    D[3] = this.ML[3] + this.dist(x - 1, y, z - 1);
                    D[4] = this.ML[4] + this.dist(x, y, z - 1);
                    D[5] = this.ML[5] + this.dist(x + 1, y, z - 1);
                    D[6] = this.ML[6] + this.dist(x - 1, y + 1, z - 1);
                    D[7] = this.ML[7] + this.dist(x, y + 1, z - 1);
                    D[8] = this.ML[8] + this.dist(x + 1, y + 1, z - 1);
                    D[9] = this.ML[9] + this.dist(x - 1, y - 1, z);
                    D[10] = this.ML[10] + this.dist(x, y - 1, z);
                    D[11] = this.ML[11] + this.dist(x + 1, y - 1, z);
                    D[12] = this.ML[12] + this.dist(x - 1, y, z);
                    this.dist[z][y * this.w + x] = this.min(D);
                }
            }
        }
    }

    public void backwardPass() {
        float[] D = new float[14];
        for (int z = this.d - 1; z >= 0; --z) {
            for (int y = this.h - 1; y >= 0; --y) {
                for (int x = this.w - 1; x >= 0; --x) {
                    if (this.dist[z][y * this.w + x] == 0.0f) continue;
                    D[0] = this.MR[0] + this.dist(x + 1, y, z);
                    D[1] = this.MR[1] + this.dist(x - 1, y + 1, z);
                    D[2] = this.MR[2] + this.dist(x, y + 1, z);
                    D[3] = this.MR[3] + this.dist(x + 1, y + 1, z);
                    D[4] = this.MR[4] + this.dist(x - 1, y - 1, z + 1);
                    D[5] = this.MR[5] + this.dist(x, y - 1, z + 1);
                    D[6] = this.MR[6] + this.dist(x + 1, y - 1, z + 1);
                    D[7] = this.MR[7] + this.dist(x - 1, y, z + 1);
                    D[8] = this.MR[8] + this.dist(x, y, z + 1);
                    D[9] = this.MR[9] + this.dist(x + 1, y, z + 1);
                    D[10] = this.MR[10] + this.dist(x - 1, y + 1, z + 1);
                    D[11] = this.MR[11] + this.dist(x, y + 1, z + 1);
                    D[12] = this.MR[12] + this.dist(x + 1, y + 1, z + 1);
                    D[13] = this.dist[z][y * this.w + x];
                    this.dist[z][y * this.w + x] = this.min(D);
                }
            }
        }
    }

    public float min(float[] data) {
        float min = this.maxVal;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] < min) || !(data[i] >= 0.0f)) continue;
            min = data[i];
        }
        return min;
    }

    public ImagePlus toFloat() {
        ImageStack stack = new ImageStack(this.w, this.h);
        for (int z = 0; z < this.d; ++z) {
            stack.addSlice("", (ImageProcessor)new FloatProcessor(this.w, this.h, this.dist[z], null));
        }
        return new ImagePlus("Distance", stack);
    }

    public ImagePlus rebin() {
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        for (int z = 0; z < this.d; ++z) {
            for (int i = 0; i < this.w * this.h; ++i) {
                if (this.dist[z][i] < min) {
                    min = this.dist[z][i];
                }
                if (!(this.dist[z][i] > max)) continue;
                max = this.dist[z][i];
            }
        }
        float delta = (max - min) / 256.0f;
        ImageStack stack = new ImageStack(this.w, this.h);
        for (int z = 0; z < this.d; ++z) {
            byte[] binned = new byte[this.w * this.h];
            for (int i = 0; i < this.w * this.h; ++i) {
                binned[i] = (byte)((this.dist[z][i] - min) / delta);
            }
            stack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h, binned, null));
        }
        return new ImagePlus("Distance", stack);
    }
}

