/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import math3d.Point3d;
import vib.BenesNamedPoint;

public class PointList
implements Iterable<BenesNamedPoint> {
    private List<BenesNamedPoint> points;
    private List<PointListListener> listeners = new ArrayList<PointListListener>();

    public PointList() {
        this.points = new ArrayList<BenesNamedPoint>();
    }

    public void add(BenesNamedPoint point) {
        this.points.add(point);
        this.fireAdded(point);
    }

    public void add(String name, double x, double y, double z) {
        this.add(new BenesNamedPoint(name, x, y, z));
    }

    public void add(double x, double y, double z) {
        this.add(this.getDefaultNameForNext(), x, y, z);
    }

    private String getDefaultNameForNext() {
        int size = this.points.size();
        int point = 1;
        if (size != 0) {
            String lastp = this.get((int)(this.points.size() - 1)).name;
            try {
                point = Integer.parseInt(lastp.substring(5, lastp.length())) + 1;
            }
            catch (Exception e) {
                point = size;
            }
        }
        return "point" + point;
    }

    public void remove(BenesNamedPoint point) {
        int i = this.indexOf(point);
        this.remove(i);
    }

    public void remove(int i) {
        if (i >= 0 && i < this.size()) {
            BenesNamedPoint p = this.points.get(i);
            this.points.remove(i);
            this.fireRemoved(p);
        }
    }

    public void clear() {
        while (this.size() > 0) {
            this.remove(0);
        }
    }

    public void rename(BenesNamedPoint point, String name) {
        point.name = name;
        this.fireRenamed(point);
    }

    public void up(BenesNamedPoint point) {
        int size = this.points.size();
        int i = this.points.indexOf(point);
        this.points.remove(i);
        this.points.add((i - 1 + size) % size, point);
        this.fireReordered();
    }

    public void down(BenesNamedPoint point) {
        int i = this.points.indexOf(point);
        int size = this.points.size();
        this.points.remove(i);
        this.points.add((i + 1) % size, point);
        this.fireReordered();
    }

    public void highlight(BenesNamedPoint p) {
        this.fireHighlighted(p);
    }

    public void placePoint(BenesNamedPoint point, double x, double y, double z) {
        point.set(x, y, z);
        this.fireMoved(point);
    }

    public BenesNamedPoint get(int index) {
        return this.points.get(index);
    }

    public int indexOf(BenesNamedPoint p) {
        return this.points.indexOf(p);
    }

    public int indexOfPointAt(double x, double y, double z, double tol) {
        Point3d p = new Point3d(x, y, z);
        tol *= tol;
        for (int i = 0; i < this.points.size(); ++i) {
            BenesNamedPoint bnp = this.points.get(i);
            if (!(p.distance2(bnp) < tol)) continue;
            return i;
        }
        return -1;
    }

    public BenesNamedPoint pointAt(double x, double y, double z, double tol) {
        int i = this.indexOfPointAt(x, y, z, tol);
        if (i == -1) {
            return null;
        }
        return this.get(i);
    }

    public BenesNamedPoint[] toArray() {
        return this.points.toArray(new BenesNamedPoint[0]);
    }

    public int size() {
        return this.points.size();
    }

    public BenesNamedPoint get(String name) {
        for (BenesNamedPoint p : this.points) {
            if (!p.name.equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public Iterator<BenesNamedPoint> iterator() {
        return this.points.iterator();
    }

    public PointList duplicate() {
        PointList copy = new PointList();
        for (BenesNamedPoint p : this) {
            copy.add(new BenesNamedPoint(p.name, p.x, p.y, p.z));
        }
        return copy;
    }

    public static PointList fromMask(ImagePlus imp) {
        PointList res = new PointList();
        int w = imp.getWidth();
        int d = imp.getStackSize();
        Calibration cal = imp.getCalibration();
        double pw = cal.pixelWidth;
        double ph = cal.pixelHeight;
        double pd = cal.pixelDepth;
        for (int z = 0; z < d; ++z) {
            byte[] pixels = (byte[])imp.getStack().getPixels(z + 1);
            for (int i = 0; i < pixels.length; ++i) {
                if (pixels[i] != -1) continue;
                res.add(new BenesNamedPoint("point" + i, (double)(i % w) * pw, (double)(i / w) * ph, (double)z * pd));
            }
        }
        return res;
    }

    public static PointList load(ImagePlus imp) {
        FileInfo info = imp.getOriginalFileInfo();
        if (info != null) {
            PointList l = PointList.load(info.directory, info.fileName + ".points", true);
            return l;
        }
        return PointList.load(null, null, true);
    }

    public static PointList load(String dir, String file, boolean showDialog) {
        String openPath = dir + File.separatorChar + file;
        if (showDialog) {
            OpenDialog od = new OpenDialog("Open points annotation file", dir, file);
            if (od.getFileName() == null) {
                return null;
            }
            openPath = od.getDirectory() + od.getFileName();
        }
        try {
            return PointList.load(new FileReader(openPath));
        }
        catch (FileNotFoundException e) {
            IJ.showMessage((String)("Could not find file " + openPath));
        }
        catch (IOException e) {
            IJ.showMessage((String)("Could not read file " + openPath));
        }
        return null;
    }

    public static PointList load(Reader reader) throws IOException {
        String line;
        PointList list = new PointList();
        BufferedReader f = new BufferedReader(reader);
        while ((line = f.readLine()) != null) {
            BenesNamedPoint p = BenesNamedPoint.fromLine(line);
            if (p == null) continue;
            list.add(p);
        }
        f.close();
        return list;
    }

    public static PointList parseString(String fileContents) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContents.getBytes());
        InputStreamReader reader = new InputStreamReader(inputStream);
        return PointList.load(reader);
    }

    public void save(String directory, String fileName) {
        String suggestedSaveFilename = fileName + ".points";
        SaveDialog sd = new SaveDialog("Save points annotation file as...", directory, suggestedSaveFilename, ".points");
        if (sd.getFileName() == null) {
            return;
        }
        String savePath = sd.getDirectory() + sd.getFileName();
        File file = new File(savePath);
        if (file != null && file.exists() && !IJ.showMessageWithCancel((String)"Save points annotation file", (String)("The file " + savePath + " already exists.\nDo you want to replace it?"))) {
            return;
        }
        IJ.showStatus((String)("Saving point annotations to " + savePath));
        try {
            this.save(new PrintStream(savePath), true);
            IJ.showStatus((String)"Saved point annotations.");
        }
        catch (IOException e) {
            IJ.error((String)("Error saving to: " + savePath + "\n" + e));
        }
    }

    public void save(PrintStream fos, boolean close) throws IOException {
        for (BenesNamedPoint p : this.points) {
            if (!p.set) continue;
            fos.println(p.toYAML());
        }
        if (close) {
            fos.close();
        } else {
            fos.flush();
        }
    }

    public static ArrayList<String> pointsInBothAsString(PointList points0, PointList points1) {
        ArrayList<String> common = new ArrayList<String>();
        block0: for (BenesNamedPoint point0 : points0) {
            for (BenesNamedPoint point1 : points1) {
                if (!point0.name.equals(point1.name)) continue;
                common.add(point0.name);
                continue block0;
            }
        }
        return common;
    }

    public static PointList pointsInBoth(PointList points0, PointList points1) {
        PointList common = new PointList();
        block0: for (BenesNamedPoint point0 : points0) {
            for (BenesNamedPoint point1 : points1) {
                if (!point0.name.equals(point1.name)) continue;
                common.add(point0);
                continue block0;
            }
        }
        return common;
    }

    public void print() {
        for (BenesNamedPoint p : this.points) {
            System.out.println(p.toString());
        }
    }

    public void addPointListListener(PointListListener pll) {
        this.listeners.add(pll);
    }

    public void removePointListListener(PointListListener pll) {
        this.listeners.remove(pll);
    }

    private void fireAdded(BenesNamedPoint p) {
        for (PointListListener l : this.listeners) {
            l.added(p);
        }
    }

    private void fireRemoved(BenesNamedPoint p) {
        for (PointListListener l : this.listeners) {
            l.removed(p);
        }
    }

    private void fireRenamed(BenesNamedPoint p) {
        for (PointListListener l : this.listeners) {
            l.renamed(p);
        }
    }

    private void fireMoved(BenesNamedPoint p) {
        for (PointListListener l : this.listeners) {
            l.moved(p);
        }
    }

    private void fireHighlighted(BenesNamedPoint p) {
        for (PointListListener l : this.listeners) {
            l.highlighted(p);
        }
    }

    private void fireReordered() {
        for (PointListListener l : this.listeners) {
            l.reordered();
        }
    }

    public static interface PointListListener {
        public void added(BenesNamedPoint var1);

        public void removed(BenesNamedPoint var1);

        public void renamed(BenesNamedPoint var1);

        public void moved(BenesNamedPoint var1);

        public void highlighted(BenesNamedPoint var1);

        public void reordered();
    }
}

