/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import distance.Euclidean;
import ij.ImagePlus;
import vib.FastMatrix;
import vib.FloatMatrix;
import vib.RigidRegistration;
import vib.TransformedImage;
import vib.app.ImageMetaData;
import vib.app.module.Module;
import vib.app.module.Resample;
import vib.app.module.State;

public class GreyTransformation
extends Module {
    @Override
    public String getName() {
        return "GreyTransformation";
    }

    @Override
    protected String getMessage() {
        return "Registering the brains";
    }

    @Override
    protected void run(State state, int index) {
        int level;
        new Resample().runOnOneImage(state, -1);
        new Resample().runOnOneImage(state, index);
        this.prereqsDone(state, index);
        int refChannel = state.options.refChannel - 1;
        String imagePath = state.getResampledPath(refChannel, index);
        String statisticsPath = state.getStatisticsPath(index);
        ImageMetaData stats = new ImageMetaData(statisticsPath);
        String transformLabel = state.getTransformLabel(0);
        if (stats.upToDate(imagePath, transformLabel)) {
            return;
        }
        String initialTransform = "";
        int stopLevel = 1;
        double tolerance = 4.0;
        String materialBBox = "";
        boolean noOptimization = false;
        int nInitialPositions = 1;
        boolean showTransformed = false;
        boolean showDifferenceImage = false;
        boolean fastButInaccurate = false;
        ImagePlus templ = state.getTemplate();
        ImagePlus image = state.getImage(imagePath);
        for (level = 4; level > 0 && templ.getWidth() >> level < 32; --level) {
        }
        if (stopLevel > level) {
            stopLevel = level;
        }
        TransformedImage trans = new TransformedImage(templ, image);
        if (stopLevel > 0) {
            trans = trans.resample(1 << stopLevel);
        }
        trans.measure = new Euclidean();
        RigidRegistration rr = new RigidRegistration();
        this.console.append("...rigidRegistration");
        FastMatrix matrix2 = rr.rigidRegistration(trans, materialBBox, initialTransform, -1, -1, noOptimization, level, stopLevel, tolerance, nInitialPositions, showTransformed, showDifferenceImage, fastButInaccurate, null);
        String forAmira = matrix2.toStringForAmira();
        FloatMatrix floatMatrix = FloatMatrix.parseMatrix(forAmira);
        stats.setMatrix(transformLabel, floatMatrix);
        if (!stats.saveTo(statisticsPath)) {
            throw new RuntimeException("Could not save " + statisticsPath);
        }
    }
}

