/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.IJ;
import ij.ImagePlus;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import vib.app.module.Module;
import vib.app.module.State;

public class Show
extends Module {
    private static final int[] redSteps = new int[]{0, 45, 25, 0, 40, 0, 65, 25, 140, 20, 170, 150, 190, 210, 255, 255};
    private static final int[] greenSteps = new int[]{0, 2, 30, 0, 100, 180, 190, 210, 255, 35};
    private static final int[] blueSteps = new int[]{0, 125, 70, 170, 100, 180, 140, 25, 255, 20};

    @Override
    public String getName() {
        return "Show";
    }

    @Override
    protected String getMessage() {
        return "Displaying the results";
    }

    @Override
    protected boolean runsOnce() {
        return true;
    }

    @Override
    protected void run(State state, int index) {
        if (index != 0) {
            return;
        }
        this.prereqsDone(state, index);
        for (int i = -1; i < state.options.numChannels; ++i) {
            IJ.open((String)state.getOutputPath(i));
            if (i >= 0) continue;
            Show.setPhysicsLUT(IJ.getImage());
            IJ.setMinAndMax((double)0.0, (double)100.0);
        }
    }

    private static byte[] makeColorChannel(int[] steps) {
        byte[] result = new byte[256];
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            if (i > steps[j + 2]) {
                j += 2;
            }
            result[i] = (byte)(steps[j + 1] + (i - steps[j]) * (steps[j + 3] - steps[j + 1]) / (steps[j + 2] - steps[j]));
        }
        return result;
    }

    private static void setPhysicsLUT(ImagePlus ip) {
        IndexColorModel c = new IndexColorModel(8, 256, Show.makeColorChannel(redSteps), Show.makeColorChannel(greenSteps), Show.makeColorChannel(blueSteps));
        ip.getProcessor().setColorModel((ColorModel)c);
        if (ip.getStackSize() > 1) {
            ip.getStack().setColorModel((ColorModel)c);
        }
    }
}

