/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kymographBuilder;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import java.util.concurrent.atomic.AtomicInteger;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import org.scijava.Context;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.ui.UIService;
import sc.fiji.kymographBuilder.KymographCreator;
import sc.fiji.kymographBuilder.LinesBuilder;

public class KymographFactory {
    public static AtomicInteger IDcounter = new AtomicInteger(-1);
    private final int ID;
    @Parameter
    private Context context;
    @Parameter
    private DatasetService dsService;
    @Parameter
    private LogService log;
    @Parameter
    private ConvertService convert;
    @Parameter
    private UIService ui;
    private final Dataset dataset;
    private Dataset kymograph;
    private final Roi roi;

    public KymographFactory(Context context, Dataset dataset, Roi roi) {
        context.inject((Object)this);
        this.roi = roi;
        this.dataset = dataset;
        this.ID = IDcounter.incrementAndGet();
    }

    public Dataset getKymograph() {
        return this.kymograph;
    }

    public void build() {
        ImagePlus imp = WindowManager.getCurrentImage();
        int zPosition = -1;
        if (imp != null) {
            zPosition = imp.getZ();
        }
        LinesBuilder linesBuilder = new LinesBuilder(this.roi);
        linesBuilder.build();
        this.log.info((Object)(linesBuilder.getLines().size() + " lines with a width of " + linesBuilder.getlineWidth() + " will be used for the kymograph " + this.ID + "."));
        this.log.info((Object)"Creating kymograph for the channel.");
        KymographCreator creator = new KymographCreator(this.context, this.dataset, linesBuilder, zPosition);
        creator.build();
        this.kymograph = creator.getProjectedKymograph();
    }
}

