/*
 * Decompiled with CFR 0.152.
 */
package io.scif.cli;

import io.scif.AbstractSCIFIOPlugin;
import io.scif.cli.SCIFIOToolCommand;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;

public abstract class AbstractSCIFIOToolCommand
extends AbstractSCIFIOPlugin
implements SCIFIOToolCommand {
    @Parameter
    private LocationService locationService;
    @Parameter
    private LogService logService;
    @Option(name="-h", aliases={"--help"}, usage="print help information")
    private boolean help;
    @Option(name="-v", aliases={"--version"}, usage="print version and exit")
    private boolean printVersion;
    @Option(name="-d", aliases={"--debug"}, usage="turn on debugging output")
    private boolean debug;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runCommand(String ... args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
            if (this.getExtraArguments() != null && !this.getExtraArguments().isEmpty()) {
                this.warn("the following arguments were not used:");
                for (String arg : this.getExtraArguments()) {
                    this.warn("\t" + arg);
                }
            }
            if (this.help) {
                this.info(this.getName() + " - " + this.description() + "\nUsage:\nscifio " + this.getName() + " [options...] arguments...\nParameters:");
                parser.printUsage((OutputStream)System.out);
                return;
            }
            this.validateParams();
            if (!this.printVersion) {
                // empty if block
            }
        }
        catch (CmdLineException e) {
            this.err(e.getMessage());
            this.err("scifio " + this.getName() + " [options...] arguments...\nParameters:");
            parser.printUsage((OutputStream)System.err);
            return;
        }
        try {
            this.run();
            return;
        }
        catch (CmdLineException e) {
            this.logService.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void run() throws CmdLineException;

    protected abstract String description();

    protected abstract String getName();

    protected abstract List<String> getExtraArguments();

    protected abstract void validateParams() throws CmdLineException;

    protected void err(String msg) {
        this.logService.error((Object)msg);
    }

    protected void warn(String msg) {
        this.logService.warn((Object)msg);
    }

    protected void info(String msg) {
        this.logService.info((Object)msg);
    }

    protected void debug(String msg) {
        if (this.debug) {
            this.logService.debug((Object)msg);
        }
    }

    @Override
    public String commandName() {
        return this.getClass().toString().toLowerCase();
    }

    protected Location location(String source) throws CmdLineException {
        try {
            Location location = this.locationService.resolve(source);
            if (location != null) {
                return location;
            }
            throw new CmdLineException(null, "Unresolvable location: " + source);
        }
        catch (URISyntaxException exc) {
            throw new CmdLineException(null, "Invalid location: " + source);
        }
    }
}

