/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.uploaders.webdav;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

class ProgressHttpEntityWrapper
extends HttpEntityWrapper {
    private final ProgressCallback progressCallback;
    private long contentLength;

    public ProgressHttpEntityWrapper(HttpEntity entity, ProgressCallback progressCallback, long contentLength) {
        super(entity);
        this.progressCallback = progressCallback;
        this.contentLength = contentLength;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.wrappedEntity.writeTo(out instanceof ProgressFilterOutputStream ? out : new ProgressFilterOutputStream(out, this.progressCallback, this.contentLength));
    }

    static class ProgressFilterOutputStream
    extends FilterOutputStream {
        private final ProgressCallback progressCallback;
        private long transferred;
        private long totalBytes;

        ProgressFilterOutputStream(OutputStream out, ProgressCallback progressCallback, long totalBytes) {
            super(out);
            this.progressCallback = progressCallback;
            this.transferred = 0L;
            this.totalBytes = totalBytes;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.transferred += (long)len;
            this.progressCallback.progress(this.getCurrentProgress());
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.transferred;
            this.progressCallback.progress(this.getCurrentProgress());
        }

        private float getCurrentProgress() {
            return (float)this.transferred / (float)this.totalBytes;
        }
    }

    public static interface ProgressCallback {
        public void progress(float var1);
    }
}

