/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.view;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;

public class ViewPropertyAction
extends AbstractViewAction {
    private String propertyName;
    private Class[] parameterClass;
    private Object propertyValue;
    private String setterName;
    private String getterName;
    private PropertyChangeListener viewListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == ViewPropertyAction.this.propertyName) {
                ViewPropertyAction.this.updateSelectedState();
            }
        }
    };

    public ViewPropertyAction(Application app, @Nullable View view, String propertyName, Object propertyValue) {
        this(app, view, propertyName, propertyValue.getClass(), propertyValue);
    }

    public ViewPropertyAction(Application app, @Nullable View view, String propertyName, Class propertyClass, Object propertyValue) {
        super(app, view);
        this.propertyName = propertyName;
        this.parameterClass = new Class[]{propertyClass};
        this.propertyValue = propertyValue;
        this.setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        this.getterName = (propertyClass == Boolean.TYPE || propertyClass == Boolean.class ? "is" : "get") + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        this.updateSelectedState();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        View p = this.getActiveView();
        try {
            p.getClass().getMethod(this.setterName, this.parameterClass).invoke((Object)p, this.propertyValue);
        }
        catch (Throwable e) {
            InternalError error = new InternalError("Method invocation failed. setter:" + this.setterName + " object:" + p);
            error.initCause(e);
            throw error;
        }
    }

    @Override
    protected void installViewListeners(View p) {
        super.installViewListeners(p);
        p.addPropertyChangeListener(this.viewListener);
        this.updateSelectedState();
    }

    @Override
    protected void uninstallViewListeners(View p) {
        super.uninstallViewListeners(p);
        p.removePropertyChangeListener(this.viewListener);
    }

    private void updateSelectedState() {
        boolean isSelected = false;
        View p = this.getActiveView();
        if (p != null) {
            try {
                Object value = p.getClass().getMethod(this.getterName, null).invoke((Object)p, new Object[0]);
                isSelected = value == this.propertyValue || value != null && this.propertyValue != null && value.equals(this.propertyValue);
            }
            catch (Throwable e) {
                InternalError error = new InternalError("Method invocation failed. getter:" + this.getterName + " object:" + p);
                error.initCause(e);
                throw error;
            }
        }
        this.putValue("SwingSelectedKey", isSelected);
    }
}

