/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.draw;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.geom.Point2D;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.ImageFigure;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.io.DOMStorableInputOutputFormat;
import org.jhotdraw.draw.io.ImageInputFormat;
import org.jhotdraw.draw.io.ImageOutputFormat;
import org.jhotdraw.draw.io.TextInputFormat;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.samples.draw.DrawFigureFactory;
import org.jhotdraw.samples.draw.DrawingPanel;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.NanoXMLDOMInput;
import org.jhotdraw.xml.NanoXMLDOMOutput;

public class DrawApplet
extends JApplet {
    private static final String NAME = "JHotDraw Draw";
    private DrawingPanel drawingPanel;
    private ButtonGroup toolButtonGroup;

    @Override
    public String getParameter(String name) {
        try {
            return super.getParameter(name);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    protected String getVersion() {
        return DrawApplet.class.getPackage().getImplementationVersion();
    }

    @Override
    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            PopupFactory.setSharedInstance(new PopupFactory());
        }
        catch (Throwable e) {
            // empty catch block
        }
        Container c = this.getContentPane();
        c.setLayout(new BoxLayout(c, 1));
        String[] labels = this.getAppletInfo().split("\n");
        for (int i = 0; i < labels.length; ++i) {
            c.add(new JLabel(labels[i].length() == 0 ? " " : labels[i]));
        }
        new Worker<Drawing>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Drawing construct() throws IOException {
                Drawing result;
                if (DrawApplet.this.getParameter("data") != null) {
                    NanoXMLDOMInput domi = new NanoXMLDOMInput((DOMFactory)new DrawFigureFactory(), new StringReader(DrawApplet.this.getParameter("data")));
                    result = (Drawing)domi.readObject(0);
                } else if (DrawApplet.this.getParameter("datafile") != null) {
                    URL url = new URL(DrawApplet.this.getDocumentBase(), DrawApplet.this.getParameter("datafile"));
                    InputStream in = url.openConnection().getInputStream();
                    try {
                        NanoXMLDOMInput domi = new NanoXMLDOMInput((DOMFactory)new DrawFigureFactory(), in);
                        result = (Drawing)domi.readObject(0);
                    }
                    finally {
                        in.close();
                    }
                } else {
                    result = null;
                }
                return result;
            }

            @Override
            protected void done(Drawing result) {
                Container c = DrawApplet.this.getContentPane();
                c.setLayout(new BorderLayout());
                c.removeAll();
                c.add(DrawApplet.this.drawingPanel = new DrawingPanel());
                DrawApplet.this.initComponents();
                if (result != null) {
                    DrawApplet.this.setDrawing(result);
                }
            }

            @Override
            protected void failed(Throwable result) {
                Container c = DrawApplet.this.getContentPane();
                c.setLayout(new BorderLayout());
                c.removeAll();
                c.add(DrawApplet.this.drawingPanel = new DrawingPanel());
                result.printStackTrace();
                DrawApplet.this.getDrawing().add(new TextFigure(result.toString()));
                result.printStackTrace();
            }

            @Override
            protected void finished() {
                Container c = DrawApplet.this.getContentPane();
                DrawApplet.this.initDrawing(DrawApplet.this.getDrawing());
                c.validate();
            }
        }.start();
    }

    private void setDrawing(Drawing d) {
        this.drawingPanel.setDrawing(d);
    }

    private Drawing getDrawing() {
        return this.drawingPanel.getDrawing();
    }

    private void initDrawing(Drawing d) {
        d.setInputFormats(Collections.EMPTY_LIST);
        d.setOutputFormats(Collections.EMPTY_LIST);
        DOMStorableInputOutputFormat ioFormat = new DOMStorableInputOutputFormat(new DrawFigureFactory());
        d.addInputFormat(ioFormat);
        d.addInputFormat(new ImageInputFormat(new ImageFigure()));
        d.addInputFormat(new TextInputFormat(new TextFigure()));
        d.addOutputFormat(ioFormat);
        d.addOutputFormat(new ImageOutputFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String text) {
        if (text != null && text.length() > 0) {
            StringReader in = new StringReader(text);
            try {
                NanoXMLDOMInput domi = new NanoXMLDOMInput((DOMFactory)new DrawFigureFactory(), in);
                this.setDrawing((Drawing)domi.readObject(0));
            }
            catch (Throwable e) {
                this.getDrawing().removeAllChildren();
                TextFigure tf = new TextFigure();
                tf.setText(e.getMessage());
                tf.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
                this.getDrawing().add(tf);
                e.printStackTrace();
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData() {
        CharArrayWriter out = new CharArrayWriter();
        try {
            NanoXMLDOMOutput domo = new NanoXMLDOMOutput(new DrawFigureFactory());
            domo.writeObject(this.getDrawing());
            domo.save(out);
        }
        catch (IOException e) {
            TextFigure tf = new TextFigure();
            tf.setText(e.getMessage());
            tf.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
            this.getDrawing().add(tf);
            e.printStackTrace();
        }
        finally {
            out.close();
        }
        return out.toString();
    }

    @Override
    public String[][] getParameterInfo() {
        return new String[][]{{"data", "String", "the data to be displayed by this applet."}, {"datafile", "URL", "an URL to a file containing the data to be displayed by this applet."}};
    }

    @Override
    public String getAppletInfo() {
        return "JHotDraw Draw\nVersion " + this.getVersion() + "\n\nCopyright 1996-2010 (c) by the original authors of JHotDraw and all its contributors" + "\nThis software is licensed under LGPL or" + "\nCreative Commons 3.0 BY";
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("JHotDraw Draw Applet");
                f.setDefaultCloseOperation(3);
                DrawApplet a = new DrawApplet();
                f.getContentPane().add(a);
                a.init();
                f.setSize(620, 400);
                f.setVisible(true);
                a.start();
            }
        });
    }
}

