/*
 * Decompiled with CFR 0.152.
 */
package ai;

import ai.AttributeClassPair;
import ai.SplitFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;

public class InformationGainFunction
extends SplitFunction {
    private static final long serialVersionUID = 1L;
    private int numOfFeatures;
    private final Random random;
    private static final Comparator<AttributeClassPair> comp = new Comparator<AttributeClassPair>(){

        @Override
        public int compare(AttributeClassPair o1, AttributeClassPair o2) {
            double diff = o2.attributeValue - o1.attributeValue;
            if (diff < 0.0) {
                return 1;
            }
            if (diff == 0.0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }
    };

    public InformationGainFunction(int numOfFeatures, Random random) {
        this.numOfFeatures = numOfFeatures;
        this.random = random;
    }

    @Override
    public void init(Instances data, ArrayList<Integer> indices) {
        if (indices.isEmpty()) {
            this.index = 0;
            this.threshold = 0.0;
            this.allSame = true;
            return;
        }
        int len = data.numAttributes();
        int numElements = indices.size();
        int numClasses = data.numClasses();
        ArrayList<Integer> allIndices = new ArrayList<Integer>();
        for (int i = 0; i < len; ++i) {
            if (i == data.classIndex()) continue;
            allIndices.add(i);
        }
        Collections.shuffle(allIndices, this.random);
        double bestGain = Double.MIN_VALUE;
        for (int i = 0; i < this.numOfFeatures; ++i) {
            int featureToUse = (Integer)allIndices.get(i);
            double[] initialProb = new double[numClasses];
            for (int n = 0; n < numElements; ++n) {
                int n2 = (int)data.get(n).classValue();
                initialProb[n2] = initialProb[n2] + 1.0;
            }
            double initialEntropy = ContingencyTables.entropy((double[])initialProb);
            initialProb = null;
            ArrayList<AttributeClassPair> list = new ArrayList<AttributeClassPair>();
            for (int j = 0; j < numElements; ++j) {
                list.add(new AttributeClassPair(data.get(indices.get(j).intValue()).value(featureToUse), (int)data.get(indices.get(j).intValue()).classValue()));
            }
            Collections.sort(list, comp);
            double[] probLeft = new double[numClasses];
            double[] probRight = new double[numClasses];
            for (int n = 0; n < list.size(); ++n) {
                int n3 = ((AttributeClassPair)list.get((int)n)).classValue;
                probRight[n3] = probRight[n3] + 1.0;
            }
            int splitPoint = 0;
            do {
                double entropyRight;
                int rightNumElements = numElements - splitPoint;
                for (int nClass = 0; nClass < numClasses; ++nClass) {
                    if (splitPoint != 0) {
                        int n = nClass;
                        probLeft[n] = probLeft[n] / (double)splitPoint;
                    }
                    if (rightNumElements == 0) continue;
                    int n = nClass;
                    probRight[n] = probRight[n] / (double)rightNumElements;
                }
                double entropyLeft = ContingencyTables.entropy((double[])probLeft);
                double totalEntropy = entropyLeft * (double)splitPoint / (double)numElements + (entropyRight = ContingencyTables.entropy((double[])probRight)) * (double)rightNumElements / (double)numElements;
                double currInfGain = initialEntropy - totalEntropy;
                if (currInfGain > bestGain) {
                    bestGain = currInfGain;
                    this.index = featureToUse;
                    this.threshold = ((AttributeClassPair)list.get((int)splitPoint)).attributeValue;
                }
                int n = ((AttributeClassPair)list.get((int)splitPoint)).classValue;
                probLeft[n] = probLeft[n] + 1.0;
                int n4 = ((AttributeClassPair)list.get((int)splitPoint)).classValue;
                probRight[n4] = probRight[n4] - 1.0;
            } while (++splitPoint < numElements);
            list.clear();
        }
        allIndices.clear();
        allIndices = null;
    }

    @Override
    public boolean evaluate(Instance instance) {
        if (this.allSame) {
            return true;
        }
        return instance.value(this.index) < this.threshold;
    }

    @Override
    public SplitFunction newInstance() {
        return new InformationGainFunction(this.numOfFeatures, this.random);
    }
}

