/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.imagestack;

import ij.ImagePlus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicSetupImgLoader;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.generic.sequence.TypedBasicImgLoader;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;

public class ImageStackImageLoader<T extends NumericType<T> & NativeType<T>, A extends ArrayDataAccess<A>>
implements BasicImgLoader,
TypedBasicImgLoader<T> {
    private final T type;
    private final ImagePlus imp;
    private final long[] dim;
    private final HashMap<Integer, SetupImgLoader> setupImgLoaders;
    private final Function<Object, A> wrapPixels;

    public static ImageStackImageLoader<UnsignedByteType, ByteArray> createUnsignedByteInstance(ImagePlus imp) {
        return ImageStackImageLoader.createUnsignedByteInstance(imp, 0);
    }

    public static ImageStackImageLoader<UnsignedByteType, ByteArray> createUnsignedByteInstance(ImagePlus imp, int offset) {
        return new ImageStackImageLoader<UnsignedByteType, ByteArray>(new UnsignedByteType(), imp, array -> new ByteArray((byte[])array), offset);
    }

    public static ImageStackImageLoader<UnsignedShortType, ShortArray> createUnsignedShortInstance(ImagePlus imp) {
        return ImageStackImageLoader.createUnsignedShortInstance(imp, 0);
    }

    public static ImageStackImageLoader<UnsignedShortType, ShortArray> createUnsignedShortInstance(ImagePlus imp, int offset) {
        return new ImageStackImageLoader<UnsignedShortType, ShortArray>(new UnsignedShortType(), imp, array -> new ShortArray((short[])array), offset);
    }

    public static ImageStackImageLoader<FloatType, FloatArray> createFloatInstance(ImagePlus imp) {
        return ImageStackImageLoader.createFloatInstance(imp, 0);
    }

    public static ImageStackImageLoader<FloatType, FloatArray> createFloatInstance(ImagePlus imp, int offset) {
        return new ImageStackImageLoader<FloatType, FloatArray>(new FloatType(), imp, array -> new FloatArray((float[])array), offset);
    }

    public static ImageStackImageLoader<ARGBType, IntArray> createARGBInstance(ImagePlus imp) {
        return ImageStackImageLoader.createARGBInstance(imp, 0);
    }

    public static ImageStackImageLoader<ARGBType, IntArray> createARGBInstance(ImagePlus imp, int offset) {
        return new ImageStackImageLoader<ARGBType, IntArray>(new ARGBType(), imp, array -> new IntArray((int[])array), offset);
    }

    public ImageStackImageLoader(T type, ImagePlus imp, Function<Object, A> wrapPixels, int setup_id_offset) {
        this.type = type;
        this.imp = imp;
        this.wrapPixels = wrapPixels;
        this.dim = new long[]{imp.getWidth(), imp.getHeight(), imp.getNSlices()};
        int numSetups = imp.getNChannels();
        this.setupImgLoaders = new HashMap();
        for (int c = 0; c < numSetups; ++c) {
            this.setupImgLoaders.put(setup_id_offset + c, new SetupImgLoader(c));
        }
    }

    public ImageStackImageLoader(T type, ImagePlus imp, Function<Object, A> wrapPixels) {
        this(type, imp, wrapPixels, 0);
    }

    public SetupImgLoader getSetupImgLoader(int setupId) {
        return this.setupImgLoaders.get(setupId);
    }

    public class SetupImgLoader
    implements BasicSetupImgLoader<T> {
        private final int channel;

        public SetupImgLoader(int channel) {
            this.channel = channel + 1;
        }

        public RandomAccessibleInterval<T> getImage(int timepointId, ImgLoaderHint ... hints) {
            int frame = timepointId + 1;
            ArrayList slices = new ArrayList();
            int slice = 1;
            while ((long)slice <= ImageStackImageLoader.this.dim[2]) {
                slices.add(ImageStackImageLoader.this.wrapPixels.apply(ImageStackImageLoader.this.imp.getStack().getPixels(ImageStackImageLoader.this.imp.getStackIndex(this.channel, slice, frame))));
                ++slice;
            }
            PlanarImg img = new PlanarImg(slices, ImageStackImageLoader.this.dim, ((NativeType)ImageStackImageLoader.this.type).getEntitiesPerPixel());
            NativeTypeFactory typeFactory = ((NativeType)ImageStackImageLoader.this.type).getNativeTypeFactory();
            img.setLinkedType(typeFactory.createLinkedType((NativeImg)img));
            return img;
        }

        public T getImageType() {
            return ImageStackImageLoader.this.type;
        }
    }
}

