/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.lw3d;

import java.util.Enumeration;
import org.scijava.java3d.Alpha;
import org.scijava.java3d.Switch;
import org.scijava.java3d.internal.J3dUtilsI18N;
import org.scijava.java3d.loaders.lw3d.FloatValueInterpolator;

class SwitchPathInterpolator
extends FloatValueInterpolator {
    Switch target;
    int firstSwitchIndex;
    int lastSwitchIndex;
    int currentChild;
    int childCount;

    SwitchPathInterpolator(Alpha alpha, float[] knots, Switch target) {
        super(alpha, knots, new float[knots.length]);
        if (knots.length != target.numChildren() + 1) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("SwitchPathInterpolator0"));
        }
        this.target = target;
        this.firstSwitchIndex = 0;
        this.lastSwitchIndex = target.numChildren() - 1;
        this.childCount = this.lastSwitchIndex + 1;
    }

    @Override
    public void processStimulus(Enumeration criteria) {
        if (this.getAlpha() != null) {
            this.computePathInterpolation();
            int child = this.currentKnotIndex > 0 ? this.currentKnotIndex - 1 : 0;
            if (this.target.getWhichChild() != child) {
                this.target.setWhichChild(child);
            }
            if (this.getAlpha().finished()) {
                return;
            }
        }
        this.wakeupOn(this.defaultWakeupCriterion);
    }
}

