/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.array;

import mpicbg.imglib.container.Container3D;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.basictypecontainer.DataAccess;
import mpicbg.imglib.cursor.array.Array3DLocalizableByDimCursor;
import mpicbg.imglib.cursor.array.Array3DLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.array.Array3DLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

public class Array3D<T extends Type<T>, A extends DataAccess>
extends Array<T, A>
implements Container3D<T> {
    final int width;
    final int height;
    final int depth;

    public Array3D(ArrayContainerFactory factory, A data, int width, int height, int depth, int entitiesPerPixel) {
        super(factory, data, new int[]{width, height, depth}, entitiesPerPixel);
        this.width = this.dim[0];
        this.height = this.dim[1];
        this.depth = this.dim[2];
    }

    @Override
    public Array3DLocalizableCursor<T> createLocalizableCursor(Image<T> image) {
        Array3DLocalizableCursor<T> c = new Array3DLocalizableCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return c;
    }

    @Override
    public Array3DLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        Array3DLocalizableByDimCursor<T> c = new Array3DLocalizableByDimCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return c;
    }

    @Override
    public Array3DLocalizableByDimOutOfBoundsCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        Array3DLocalizableByDimOutOfBoundsCursor<T> c = new Array3DLocalizableByDimOutOfBoundsCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer(), outOfBoundsFactory);
        return c;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public int getPos(int x, int y, int z) {
        return x + this.width * (y + z * this.height);
    }
}

