/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.compat;

import ij.IJ;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.List;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.AWTEventListener;
import java.awt.event.ContainerEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;

public class FileDialogDecorator
extends KeyAdapter {
    protected List list;
    protected long lastWhen;
    protected String prefix;
    protected boolean reRequestFocusAfterEnter;
    long timeout = 300L;

    public FileDialogDecorator(List list) {
        this.list = list;
        if (list.getParent().getComponentCount() == 7) {
            this.reRequestFocusAfterEnter = true;
            FileDialogDecorator.registerDropTarget(list.getParent());
        }
    }

    public void select(int index) {
        if (index < 0 || index >= this.list.getItemCount()) {
            return;
        }
        this.list.select(index);
        this.list.makeVisible(index);
    }

    public void requestFocus() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileDialogDecorator.this.list.requestFocus();
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode < 32) {
            if (this.reRequestFocusAfterEnter && keyCode == 10) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileDialogDecorator.this.requestFocus();
                    }
                });
            }
            return;
        }
        switch (keyCode) {
            case 36: {
                this.select(0);
                return;
            }
            case 35: {
                this.select(this.list.getItemCount() - 1);
                return;
            }
            case 34: {
                this.select(this.list.getSelectedIndex() + this.list.getRows());
                return;
            }
            case 33: {
                this.select(this.list.getSelectedIndex() - this.list.getRows());
                return;
            }
        }
        long when = e.getWhen();
        this.prefix = when - this.lastWhen > this.timeout ? "" + e.getKeyChar() : this.prefix + e.getKeyChar();
        int index = FileDialogDecorator.findItemForPrefix(this.list, this.prefix);
        if (index >= 0) {
            this.select(index);
        }
        this.lastWhen = when;
    }

    static boolean isSmaller(String s1, String s2) {
        int prefixLen = Math.min(s1.length(), s2.length());
        return s1.substring(0, prefixLen).compareTo(s2) > 0;
    }

    public static int findItemForPrefix(List list, String prefix) {
        int index = list.getSelectedIndex() + 1;
        if (index >= list.getItemCount() || FileDialogDecorator.isSmaller(list.getItem(index), prefix)) {
            index = 0;
        }
        do {
            if (!list.getItem(index).startsWith(prefix)) continue;
            return index;
        } while (++index < list.getItemCount());
        return -1;
    }

    public static void registerAutomaticDecorator() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AutomaticDecorator(), 2L);
    }

    public static void registerDropTarget(Component component) {
        if (component instanceof FileDialog) {
            new DropTarget(component, new DropListener((FileDialog)component));
        } else {
            IJ.log((String)("Warning: not a FileDialog: " + component));
        }
    }

    public static void main(String[] args) {
        FileDialogDecorator.registerAutomaticDecorator();
        FileDialogDecorator.report("FileDialog decorator started");
        FileDialogDecorator.report("========================");
    }

    public static void report(String message) {
        if (!message.endsWith("\n")) {
            message = message + "\n";
        }
        System.err.println(message);
    }

    static class DropListener
    implements DropTargetListener {
        FileDialog fileDialog;

        DropListener(FileDialog fileDialog) {
            this.fileDialog = fileDialog;
        }

        String trim(String string) {
            int i;
            for (i = string.length(); i > 0 && "\r\n".indexOf(string.charAt(i - 1)) >= 0; --i) {
            }
            return string.substring(0, i);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(1);
            Transferable t = dtde.getTransferable();
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String string = (String)t.getTransferData(DataFlavor.stringFlavor);
                    if (string.startsWith("file://")) {
                        File file = new File(string = this.trim(string.substring(7)));
                        if (file.isDirectory()) {
                            this.fileDialog.setDirectory(string);
                        } else {
                            this.fileDialog.setDirectory(file.getParent());
                            this.fileDialog.setFile(file.getName());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(1);
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }

    static class AutomaticDecorator
    implements AWTEventListener {
        AutomaticDecorator() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            ContainerEvent e = (ContainerEvent)event;
            if (e.getID() == 300 && e.getSource() instanceof FileDialog && e.getChild() instanceof List) {
                e.getChild().addKeyListener(new FileDialogDecorator((List)e.getChild()));
            }
        }
    }
}

