/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.animate;

import bdv.viewer.animate.AbstractAnimator;
import bdv.viewer.animate.OverlayAnimator;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MessageOverlayAnimator
implements OverlayAnimator {
    protected final Font font;
    protected final long duration;
    protected final double fadeInTime;
    protected final double fadeOutTime;
    protected final List<TextAnimator> texts;

    public MessageOverlayAnimator(long duration) {
        this(duration, 0.2, 0.5);
    }

    public MessageOverlayAnimator(long duration, double fadeInTime, double fadeOutTime) {
        this(duration, fadeInTime, fadeOutTime, new Font("SansSerif", 1, 20));
    }

    public MessageOverlayAnimator(long duration, double fadeInTime, double fadeOutTime, Font font) {
        this.duration = duration;
        this.fadeInTime = fadeInTime;
        this.fadeOutTime = fadeOutTime;
        this.font = font;
        this.texts = Collections.synchronizedList(new LinkedList());
    }

    public void add(String text) {
        this.texts.add(0, new TextAnimator(text, this.duration));
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    @Override
    public boolean requiresRepaint() {
        return !this.texts.isEmpty();
    }

    @Override
    public void paint(Graphics2D g, long time) {
        if (!this.requiresRepaint()) {
            return;
        }
        double ox = g.getClipBounds().getWidth() - 10.0;
        double oy = g.getClipBounds().getHeight() - 10.0;
        FontRenderContext frc = g.getFontRenderContext();
        for (int i = 0; i < this.texts.size(); ++i) {
            TextAnimator text = this.texts.get(i);
            text.setTime(time);
            TextLayout layout = new TextLayout(text.text, this.font, frc);
            Rectangle2D bounds = layout.getBounds();
            double t = text.ratioComplete();
            float alpha = t <= this.fadeInTime ? (float)Math.sin(1.5707963267948966 * t / this.fadeInTime) : (t >= 1.0 - this.fadeOutTime ? (float)Math.sin(1.5707963267948966 * (1.0 - t) / this.fadeOutTime) : 1.0f);
            g.setColor(new Color(1.0f, 1.0f, 1.0f, alpha));
            float x = (float)(ox - bounds.getMaxX());
            float y = (float)oy;
            layout.draw(g, x, y);
            oy += bounds.getY() - 5.0;
            if (!text.isComplete()) continue;
            while (this.texts.size() > i) {
                this.texts.remove(i);
            }
        }
    }

    protected static class TextAnimator
    extends AbstractAnimator {
        protected final String text;

        public TextAnimator(String text, long duration) {
            super(duration);
            this.text = text;
        }
    }
}

