/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.detector;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.MaskUtils;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.detection.ThresholdDetectorFactory;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.util.DetectionPreview;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.Threads;
import ij.ImagePlus;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class ThresholdDetectorConfigurationPanel
extends ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private static final NumberFormat THRESHOLD_FORMAT = new DecimalFormat("#.###");
    protected final Settings settings;
    protected JCheckBox chkboxSimplify;
    protected JSlider sliderChannel;
    protected final JFormattedTextField ftfIntensityThreshold;
    protected final JButton btnAutoThreshold;
    protected final JLabel lblIntensityThreshold;

    public ThresholdDetectorConfigurationPanel(Settings settings, Model model) {
        this(settings, model, "<html>This detector creates spots by thresholding a grayscale image.<p>Pixels in the designated channel that have a value larger than the threshold are considered as part of the foreground, and used to build connected regions. In 2D, spots are created with the (possibly simplified) contour of the region. In 3D, a spherical spot is created for each region in its center, with a volume equal to the region volume.<p>The spot quality stores the object area or volume in pixels.</html>", "Thresholding detector");
    }

    protected ThresholdDetectorConfigurationPanel(Settings settings, Model model, String infoText, String detectorName) {
        this.settings = settings;
        ImagePlus imp = settings.imp;
        this.setPreferredSize(new Dimension(300, 511));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 47};
        gridBagLayout.columnWidths = new int[]{0, 0, 20};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, 0.0};
        this.setLayout(gridBagLayout);
        JLabel jLabelDetectorName = new JLabel(detectorName, 0);
        jLabelDetectorName.setFont(Fonts.BIG_FONT);
        GridBagConstraints gbclblSegmenterName = new GridBagConstraints();
        gbclblSegmenterName.anchor = 18;
        gbclblSegmenterName.insets = new Insets(5, 5, 5, 5);
        gbclblSegmenterName.gridwidth = 3;
        gbclblSegmenterName.gridx = 0;
        gbclblSegmenterName.gridy = 0;
        this.add((Component)jLabelDetectorName, gbclblSegmenterName);
        GridBagConstraints gbcLblHelpText = new GridBagConstraints();
        gbcLblHelpText.anchor = 17;
        gbcLblHelpText.fill = 1;
        gbcLblHelpText.insets = new Insets(5, 5, 5, 5);
        gbcLblHelpText.gridwidth = 3;
        gbcLblHelpText.gridx = 0;
        gbcLblHelpText.gridy = 1;
        this.add((Component)GuiUtils.textInScrollPanel(GuiUtils.infoDisplay(infoText)), gbcLblHelpText);
        JLabel labelChannel = new JLabel("1");
        labelChannel.setHorizontalAlignment(0);
        labelChannel.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcLblChannel = new GridBagConstraints();
        gbcLblChannel.fill = 3;
        gbcLblChannel.insets = new Insets(5, 5, 5, 5);
        gbcLblChannel.gridx = 2;
        gbcLblChannel.gridy = 3;
        this.add((Component)labelChannel, gbcLblChannel);
        this.sliderChannel = new JSlider();
        this.sliderChannel.addChangeListener(e -> labelChannel.setText("" + this.sliderChannel.getValue()));
        JLabel lblDetectInChannel = new JLabel("Segment in channel:");
        lblDetectInChannel.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcLblDetectInChannel = new GridBagConstraints();
        gbcLblDetectInChannel.anchor = 13;
        gbcLblDetectInChannel.insets = new Insets(5, 5, 5, 5);
        gbcLblDetectInChannel.gridx = 0;
        gbcLblDetectInChannel.gridy = 3;
        this.add((Component)lblDetectInChannel, gbcLblDetectInChannel);
        GridBagConstraints gbcSliderChannel = new GridBagConstraints();
        gbcSliderChannel.fill = 1;
        gbcSliderChannel.insets = new Insets(5, 5, 5, 5);
        gbcSliderChannel.gridx = 1;
        gbcSliderChannel.gridy = 3;
        this.add((Component)this.sliderChannel, gbcSliderChannel);
        this.lblIntensityThreshold = new JLabel("Intensity threshold:");
        this.lblIntensityThreshold.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcLblNewLabel = new GridBagConstraints();
        gbcLblNewLabel.anchor = 13;
        gbcLblNewLabel.insets = new Insets(5, 5, 5, 5);
        gbcLblNewLabel.gridx = 0;
        gbcLblNewLabel.gridy = 4;
        this.add((Component)this.lblIntensityThreshold, gbcLblNewLabel);
        this.ftfIntensityThreshold = new JFormattedTextField(THRESHOLD_FORMAT);
        GuiUtils.selectAllOnFocus(this.ftfIntensityThreshold);
        this.ftfIntensityThreshold.setValue(0.0);
        this.ftfIntensityThreshold.setFont(Fonts.SMALL_FONT);
        this.ftfIntensityThreshold.setHorizontalAlignment(0);
        GridBagConstraints gbcFtfIntensityThreshold = new GridBagConstraints();
        gbcFtfIntensityThreshold.fill = 2;
        gbcFtfIntensityThreshold.insets = new Insets(5, 5, 5, 5);
        gbcFtfIntensityThreshold.gridx = 1;
        gbcFtfIntensityThreshold.gridy = 4;
        this.add((Component)this.ftfIntensityThreshold, gbcFtfIntensityThreshold);
        this.btnAutoThreshold = new JButton("Auto");
        this.btnAutoThreshold.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcBtnAutoThreshold = new GridBagConstraints();
        gbcBtnAutoThreshold.insets = new Insets(5, 5, 5, 5);
        gbcBtnAutoThreshold.gridx = 2;
        gbcBtnAutoThreshold.gridy = 4;
        this.add((Component)this.btnAutoThreshold, gbcBtnAutoThreshold);
        this.chkboxSimplify = new JCheckBox();
        GridBagConstraints gbChkboxSimplify = new GridBagConstraints();
        gbChkboxSimplify.anchor = 18;
        gbChkboxSimplify.insets = new Insets(5, 5, 5, 5);
        gbChkboxSimplify.gridwidth = 3;
        gbChkboxSimplify.gridx = 0;
        gbChkboxSimplify.gridy = 5;
        this.add((Component)this.chkboxSimplify, gbChkboxSimplify);
        this.chkboxSimplify.setText("Simplify contours.");
        this.chkboxSimplify.setFont(Fonts.FONT);
        DetectionPreview detectionPreview = DetectionPreview.create().model(model).settings(settings).detectorFactory(this.getDetectorFactory()).detectionSettingsSupplier(() -> this.getSettings()).thresholdUpdater(null).axisLabel(DetectionUtils.is2D(settings.imp) ? "Area histogram" : "Volume histogram").get();
        GridBagConstraints gbcBtnPreview = new GridBagConstraints();
        gbcBtnPreview.fill = 1;
        gbcBtnPreview.insets = new Insets(5, 5, 5, 5);
        gbcBtnPreview.gridwidth = 3;
        gbcBtnPreview.gridx = 0;
        gbcBtnPreview.gridy = 7;
        this.add((Component)detectionPreview.getPanel(), gbcBtnPreview);
        int nChannels = imp.getNChannels();
        this.sliderChannel.setMinimum(1);
        this.sliderChannel.setMaximum(nChannels);
        if (nChannels <= 1) {
            labelChannel.setVisible(false);
            lblDetectInChannel.setVisible(false);
            this.sliderChannel.setVisible(false);
        } else {
            labelChannel.setVisible(true);
            lblDetectInChannel.setVisible(true);
            this.sliderChannel.setVisible(true);
        }
        this.btnAutoThreshold.addActionListener(e -> this.autoThreshold());
    }

    private <T extends RealType<T> & NativeType<T>> void autoThreshold() {
        this.btnAutoThreshold.setEnabled(false);
        Threads.run("TrackMate compute threshold thread", () -> {
            try {
                ImgPlus img = TMUtils.rawWraps(this.settings.imp);
                int channel = Integer.valueOf(this.sliderChannel.getValue()) - 1;
                int frame = this.settings.imp.getT() - 1;
                RandomAccessibleInterval imFrame = DetectionUtils.prepareFrameImg(img, channel, frame);
                Interval interval = DetectionUtils.squeeze(TMUtils.getInterval(img, this.settings));
                IntervalView crop = Views.interval(imFrame, (Interval)interval);
                double threshold = MaskUtils.otsuThreshold(crop);
                SwingUtilities.invokeLater(() -> this.ftfIntensityThreshold.setValue(threshold));
            }
            finally {
                SwingUtilities.invokeLater(() -> this.btnAutoThreshold.setEnabled(true));
            }
        });
    }

    @Override
    public Map<String, Object> getSettings() {
        int targetChannel = this.sliderChannel.getValue();
        boolean simplify = this.chkboxSimplify.isSelected();
        double intensityThreshold = ((Number)this.ftfIntensityThreshold.getValue()).doubleValue();
        HashMap<String, Object> lSettings = new HashMap<String, Object>(3);
        lSettings.put("TARGET_CHANNEL", targetChannel);
        lSettings.put("INTENSITY_THRESHOLD", intensityThreshold);
        lSettings.put("SIMPLIFY_CONTOURS", simplify);
        return lSettings;
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.sliderChannel.setValue((Integer)settings.get("TARGET_CHANNEL"));
        this.chkboxSimplify.setSelected((Boolean)settings.get("SIMPLIFY_CONTOURS"));
        Double intensityThreshold = (double)((Double)settings.get("INTENSITY_THRESHOLD"));
        if (intensityThreshold == null || intensityThreshold == 0.0) {
            this.autoThreshold();
        } else {
            this.ftfIntensityThreshold.setValue(intensityThreshold);
        }
    }

    protected SpotDetectorFactory<?> getDetectorFactory() {
        return new ThresholdDetectorFactory();
    }

    @Override
    public void clean() {
    }
}

