/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.displaysettings;

import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettingsIO;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettingsPanel;
import ij.ImageJ;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, label="Configure TrackMate display settings...", iconPath="/icons/commands/information.png", menuPath="Edit >  Options > Configure TrackMate display settings...")
public class ConfigTrackMateDisplaySettings
implements Command {
    private static final String APPLY_TOOLTIP = "<html>Save the current settings to the user default settings. They will be used in all the following TrackMate sessions.</html>";
    private static final String REVERT_TOOLTIP = "<html>Revert the current settings to the ones saved in the user default settings file.</html>";
    private static final String RESET_TOOLTIP = "<html>Reset the current settings to the built-in defaults.</html>";

    public void run() {
        ConfigTrackMateDisplaySettings.editor(DisplaySettingsIO.readUserDefault(), "Configure the default settings to be used by TrackMate.", "TrackMate user default settings").setVisible(true);
    }

    public static JFrame editor(DisplaySettings ds, String titleStr, String frameName) {
        JPanel configPanel = new JPanel();
        configPanel.setLayout(new BorderLayout());
        JLabel title = new JLabel("<html><i>" + titleStr + "</i></html>");
        title.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        configPanel.add((Component)title, "North");
        JPanel panelButton = new JPanel();
        BoxLayout panelButtonLayout = new BoxLayout(panelButton, 2);
        panelButton.setLayout(panelButtonLayout);
        JButton btnReset = new JButton("Reset", Icons.RESET_ICON);
        btnReset.setToolTipText(RESET_TOOLTIP);
        JButton btnRevert = new JButton("Revert", Icons.REVERT_ICON);
        btnRevert.setToolTipText(REVERT_TOOLTIP);
        JButton btnApply = new JButton("Save to user defaults", Icons.APPLY_ICON);
        btnApply.setToolTipText(APPLY_TOOLTIP);
        panelButton.add(btnReset);
        panelButton.add(Box.createHorizontalStrut(5));
        panelButton.add(btnRevert);
        panelButton.add(Box.createHorizontalGlue());
        panelButton.add(btnApply);
        panelButton.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        configPanel.add((Component)panelButton, "South");
        DisplaySettingsPanel editor = new DisplaySettingsPanel(ds);
        JScrollPane scrollPane = new JScrollPane(editor, 22, 31);
        scrollPane.setPreferredSize(new Dimension(350, 500));
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        configPanel.add((Component)scrollPane, "Center");
        btnReset.addActionListener(e -> {
            ds.set(DisplaySettings.defaultStyle().copy("User-default"));
            title.setText("Reset the current settings to the built-in defaults.");
        });
        btnRevert.addActionListener(e -> {
            ds.set(DisplaySettingsIO.readUserDefault());
            title.setText("Reverted the current settings to the user defaults.");
        });
        btnApply.addActionListener(e -> {
            DisplaySettingsIO.saveToUserDefault(ds);
            title.setText("Saved the current settings to the user defaults file.");
        });
        JFrame frame = new JFrame(frameName);
        frame.setIconImage(Icons.TRACKMATE_ICON.getImage());
        frame.getContentPane().add(configPanel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        return frame;
    }

    public static void main(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        ImageJ.main((String[])args);
        new ConfigTrackMateDisplaySettings().run();
    }
}

