/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman.costmatrix;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SparseCostMatrix {
    final double[] cc;
    final int[] kk;
    final int[] number;
    final int nRows;
    final int nCols;
    final int cardinality;
    final int[] start;

    public SparseCostMatrix(double[] cc, int[] kk, int[] number, int nCols) {
        this.cc = cc;
        this.kk = kk;
        this.number = number;
        this.nCols = nCols;
        if (cc.length != kk.length) {
            throw new IllegalArgumentException("Cost and column indices arrays must have the same length. Found " + cc.length + " and " + kk.length + ".");
        }
        this.cardinality = cc.length;
        this.nRows = number.length;
        this.start = new int[this.nRows];
        if (this.nRows > 0) {
            this.start[0] = 0;
        }
        for (int i = 1; i < this.nRows; ++i) {
            if (number[i] == 0) {
                throw new IllegalArgumentException("All the rows must have at least one cost. Row " + i + " have none.");
            }
            this.start[i] = this.start[i - 1] + number[i - 1];
        }
        int[] colHistogram = new int[nCols];
        for (int i = 0; i < this.nRows; ++i) {
            int previousK = -1;
            for (int j = this.start[i]; j < this.start[i] + number[i]; ++j) {
                int k = kk[j];
                if (k >= nCols) {
                    throw new IllegalArgumentException("At line " + i + ", the column indices array contains a column index (" + k + ") that is larger than or equal to the declared number of column (" + nCols + ").");
                }
                int n = k;
                colHistogram[n] = colHistogram[n] + 1;
                if (k <= previousK) {
                    throw new IllegalArgumentException("The column indices array must be sorted within each row. The column elements at line " + i + " are not properly sorted.");
                }
                previousK = k;
            }
        }
        for (int j = 0; j < colHistogram.length; ++j) {
            if (colHistogram[j] != 0) continue;
            throw new IllegalArgumentException("All the columns must have at least one cost. The column " + j + " has none.");
        }
    }

    public String toString() {
        return this.toString(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    /*
     * WARNING - void declaration
     */
    public String toString(List<?> rows, List<?> columns) {
        int i;
        int n;
        void var6_10;
        String[] colNames = new String[this.nCols];
        for (int j = 0; j < colNames.length; ++j) {
            colNames[j] = "" + j;
        }
        String[] rowNames = new String[this.nRows];
        for (int i2 = 0; i2 < rowNames.length; ++i2) {
            rowNames[i2] = "" + i2;
        }
        for (int j = 0; j < columns.size(); ++j) {
            String str;
            Object obj = columns.get(j);
            if (null == obj) continue;
            colNames[j] = str = obj.toString();
        }
        int colWidth = -1;
        for (String str : colNames) {
            if (str.length() <= colWidth) continue;
            colWidth = str.length();
        }
        ++colWidth;
        colWidth = Math.max(colWidth, 7);
        boolean bl = false;
        while (var6_10 < rows.size()) {
            Object row = rows.get((int)var6_10);
            if (null != row) {
                String str;
                rowNames[var6_10] = str = row.toString();
            }
            ++var6_10;
        }
        int n2 = -1;
        for (String str : rowNames) {
            if (str.length() <= n) continue;
            n = str.length();
        }
        void var6_13 = n + true;
        int n3 = Math.max(7, (int)var6_13);
        StringBuilder str = new StringBuilder();
        str.append(super.toString() + '\n');
        str.append("  " + this.nRows + " \u00d7 " + this.nCols + " matrix with " + this.cardinality + " non-null elements. ");
        str.append(String.format("Density = %.2f%%.\n", (double)this.cardinality / (double)(this.nRows * this.nCols) * 100.0));
        for (i = 0; i < n3; ++i) {
            str.append(' ');
        }
        str.append('|');
        for (int c = 0; c < this.nCols; ++c) {
            for (int i4 = 0; i4 < colWidth - colNames[c].length(); ++i4) {
                str.append(' ');
            }
            str.append(colNames[c]);
        }
        str.append('\n');
        for (i = 0; i < n3; ++i) {
            str.append('_');
        }
        str.append('|');
        char[] line = new char[colWidth * this.nCols];
        Arrays.fill(line, '_');
        str.append(line);
        str.append('\n');
        for (int r = 0; r < this.nRows; ++r) {
            str.append(rowNames[r]);
            for (int i5 = 0; i5 < n3 - rowNames[r].length(); ++i5) {
                str.append(' ');
            }
            str.append('|');
            StringBuilder rowStr = new StringBuilder();
            char[] spaces = new char[colWidth * this.nCols];
            Arrays.fill(spaces, ' ');
            rowStr.append(spaces);
            for (int k = this.start[r]; k < this.start[r] + this.number[r]; ++k) {
                int col = this.kk[k];
                double cost = this.cc[k];
                rowStr.replace(col * colWidth, (col + 1) * colWidth, String.format("% " + colWidth + ".1f", cost));
            }
            rowStr.append('\n');
            str.append(rowStr.toString());
        }
        return str.toString();
    }

    public double totalAssignmentCost(int[] rowAssignment) {
        double sum = 0.0;
        for (int i = 0; i < rowAssignment.length; ++i) {
            int j = rowAssignment[i];
            int kj = Arrays.binarySearch(this.kk, this.start[i], this.start[i] + this.number[i], j);
            sum += this.cc[kj];
        }
        return sum;
    }

    public double[][] toFullMatrix() {
        double[][] cm;
        for (double[] ds : cm = new double[this.nRows][this.nCols]) {
            Arrays.fill(ds, Double.MAX_VALUE);
        }
        for (int r = 0; r < this.nRows; ++r) {
            for (int k = this.start[r]; k < this.start[r] + this.number[r]; ++k) {
                double cost;
                int c = this.kk[k];
                cm[r][c] = cost = this.cc[k];
            }
        }
        return cm;
    }

    public final double get(int i, int j, double missingValue) {
        int k = Arrays.binarySearch(this.kk, this.start[i], this.start[i] + this.number[i], j);
        if (k < 0) {
            return missingValue;
        }
        return this.cc[k];
    }

    public double[] getCosts() {
        return this.cc;
    }

    public int getNCols() {
        return this.nCols;
    }

    public int getNRows() {
        return this.nRows;
    }

    public final SparseCostMatrix vcat(SparseCostMatrix B) {
        if (this.nCols != B.nCols) {
            throw new IllegalArgumentException("Matrices A & B do not have the same number of columns. Found " + this.nCols + " and " + B.nCols + " respectively.");
        }
        double[] cc2 = new double[this.cardinality + B.cardinality];
        int[] kk2 = new int[this.cardinality + B.cardinality];
        int[] number2 = new int[this.nRows + B.nRows];
        System.arraycopy(this.kk, 0, kk2, 0, this.cardinality);
        System.arraycopy(this.cc, 0, cc2, 0, this.cardinality);
        System.arraycopy(this.number, 0, number2, 0, this.nRows);
        System.arraycopy(B.kk, 0, kk2, this.cardinality, B.cardinality);
        System.arraycopy(B.cc, 0, cc2, this.cardinality, B.cardinality);
        System.arraycopy(B.number, 0, number2, this.nRows, B.nRows);
        return new SparseCostMatrix(cc2, kk2, number2, this.nCols);
    }

    public final SparseCostMatrix hcat(SparseCostMatrix B) {
        if (this.nRows != B.nRows) {
            throw new IllegalArgumentException("Matrices A & B do not have the same number of rows. Found " + this.nRows + " and " + B.nRows + " respectively.");
        }
        double[] cc2 = new double[this.cardinality + B.cardinality];
        int[] kk2 = new int[this.cardinality + B.cardinality];
        int[] number2 = new int[this.nRows];
        int Aindex = 0;
        int Bindex = 0;
        int Cindex = 0;
        for (int i = 0; i < this.nRows; ++i) {
            System.arraycopy(this.cc, Aindex, cc2, Cindex, this.number[i]);
            System.arraycopy(this.kk, Aindex, kk2, Cindex, this.number[i]);
            Aindex += this.number[i];
            System.arraycopy(B.cc, Bindex, cc2, Cindex += this.number[i], B.number[i]);
            for (int j = 0; j < B.number[i]; ++j) {
                kk2[Cindex + j] = B.kk[Bindex + j] + this.nCols;
            }
            Bindex += B.number[i];
            Cindex += B.number[i];
            number2[i] = this.number[i] + B.number[i];
        }
        return new SparseCostMatrix(cc2, kk2, number2, this.nCols + B.nCols);
    }

    public final SparseCostMatrix transpose() {
        int[] number2 = new int[this.nCols];
        int[] nArray = this.kk;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int j;
            int n2 = j = nArray[i];
            number2[n2] = number2[n2] + 1;
        }
        int[][] cols = new int[this.nCols][];
        double[][] costs = new double[this.nCols][];
        for (int j = 0; j < cols.length; ++j) {
            cols[j] = new int[number2[j]];
            costs[j] = new double[number2[j]];
        }
        int currentLine = 0;
        int previousJ = -1;
        int walked = 0;
        int[] colIndex = new int[this.nCols];
        for (int k = 0; k < this.cardinality; ++k) {
            int j = this.kk[k];
            double c = this.cc[k];
            if (j <= previousJ || walked >= this.number[currentLine]) {
                walked = 0;
            }
            ++walked;
            previousJ = j;
            cols[j][colIndex[j]] = ++currentLine;
            costs[j][colIndex[j]] = c;
            int n3 = j;
            colIndex[n3] = colIndex[n3] + 1;
        }
        double[] cc2 = new double[this.cardinality];
        int[] kk2 = new int[this.cardinality];
        int index = 0;
        for (int i = 0; i < cols.length; ++i) {
            System.arraycopy(cols[i], 0, kk2, index, number2[i]);
            System.arraycopy(costs[i], 0, cc2, index, number2[i]);
            index += number2[i];
        }
        return new SparseCostMatrix(cc2, kk2, number2, this.nRows);
    }

    public void fillWith(double value) {
        Arrays.fill(this.cc, value);
    }
}

