/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.gui.displaysettings.Colormap;
import fiji.plugin.trackmate.visualization.TrackColorGenerator;
import java.awt.Color;
import org.jgrapht.graph.DefaultWeightedEdge;

public class PerSpotFeatureColorGenerator
implements TrackColorGenerator {
    private final Model model;
    private final String spotFeature;
    private final Color missingValueColor;
    private final Color undefinedValueColor;
    private final Colormap colormap;
    private final double min;
    private final double max;

    public PerSpotFeatureColorGenerator(Model model, String spotFeature, Color missingValueColor, Color undefinedValueColor, Colormap colormap, double min, double max) {
        this.model = model;
        this.spotFeature = spotFeature;
        this.missingValueColor = missingValueColor;
        this.undefinedValueColor = undefinedValueColor;
        this.colormap = colormap;
        this.min = min;
        this.max = max;
    }

    @Override
    public Color color(DefaultWeightedEdge edge) {
        Spot spot = this.model.getTrackModel().getEdgeTarget(edge);
        Double feat = spot.getFeature(this.spotFeature);
        if (null == feat) {
            return this.missingValueColor;
        }
        if (feat.isNaN()) {
            return this.undefinedValueColor;
        }
        double val = feat;
        return this.colormap.getPaint((val - this.min) / (this.max - this.min));
    }
}

