/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.image.IndexColorModel;
import java.util.Random;
import java.util.Vector;
import view5d.PolyROI;
import view5d.ROI;
import view5d.RectROI;

public class Bundle
implements Cloneable {
    private double mincs = 0.0;
    private double maxcs = 1.0;
    private double[] ProjMincs = new double[]{0.0, 0.0};
    private double[] ProjMaxcs = new double[]{1.0, 1.0};
    public int ElementModelNr = 0;
    static final int ElementModels = 13;
    static final String[] ElementModelName = new String[]{"GrayScale", "Red", "Green", "Blue", "Purple", "Glow Red", "Glow Green-Blue", "Glow Green-Yellow", "Glow Blue", "Glow Purple", "Rainbow", "Random", "Cyclic"};
    byte[] cmapRed;
    byte[] cmapGreen;
    byte[] cmapBlue;
    static Vector<Integer> MapSizes = new Vector();
    static Vector<byte[]> RedMaps = new Vector();
    static Vector<byte[]> GreenMaps = new Vector();
    static Vector<byte[]> BlueMaps = new Vector();
    boolean cmapIsInverse = false;
    IndexColorModel ElementModel;
    boolean ShowOvUn = false;
    boolean LogScale = false;
    double Gamma = 1.0;
    static final int MaxCTableBits = 15;
    static final int MaxCTable = 32768;
    int cmapcLow = 0;
    int cmapcHigh = 32768;
    boolean DispOverlay = false;
    boolean MulDisplay = false;
    boolean MIPMode = true;
    boolean[] ProjValid;
    ROI ActiveROI;
    RectROI rectROI;
    PolyROI polyROI;

    Bundle(int EN, double min, double max) {
        this.ElementModelNr = EN;
        this.mincs = min;
        this.maxcs = max;
        this.ProjMincs[0] = min;
        this.ProjMaxcs[0] = max;
        this.ProjMincs[1] = min;
        this.ProjMaxcs[1] = max;
        this.ProjValid = new boolean[3];
        this.rectROI = new RectROI();
        this.polyROI = new PolyROI();
        this.ActiveROI = this.rectROI;
        this.Invalidate();
        try {
            this.GenCMap();
        }
        catch (Exception e) {
            System.out.println("Exception creating Bundle\n");
            e.printStackTrace();
        }
    }

    void Invalidate() {
        this.ProjValid[0] = false;
        this.ProjValid[1] = false;
        this.ProjValid[2] = false;
    }

    double GetMincs() {
        return this.mincs;
    }

    double GetMaxcs() {
        return this.maxcs;
    }

    void SetMincs(double val) {
        this.mincs = val;
    }

    void SetMaxcs(double val) {
        this.maxcs = val;
    }

    void ToggleROI() {
        this.ActiveROI = this.ActiveROI == this.rectROI ? this.polyROI : this.rectROI;
    }

    boolean InOverlayDispl() {
        return this.DispOverlay;
    }

    boolean MulOverlayDispl() {
        return this.MulDisplay;
    }

    public void ToggleOverlayDispl(int val) {
        if (val < 0) {
            this.DispOverlay = !this.DispOverlay;
        } else if (val == 0) {
            this.DispOverlay = false;
        } else if (val == 1) {
            this.DispOverlay = true;
        }
    }

    public void ToggleMulDispl(int val) {
        if (val < 0) {
            this.MulDisplay = !this.MulDisplay;
        } else if (val == 0) {
            this.MulDisplay = false;
        } else if (val == 1) {
            this.MulDisplay = true;
            this.DispOverlay = false;
        }
    }

    public boolean SquareROIs() {
        return this.ActiveROI == this.rectROI;
    }

    public void TakeSqrROIs(int[] Pmin, int[] Pmax) {
        this.rectROI.TakeSqrROIs(Pmin, Pmax);
    }

    public void UpdateSqrROI(int ROIX, int ROIY, int ROIXe, int ROIYe, int dir) {
        this.rectROI.UpdateSqrROI(ROIX, ROIY, ROIXe, ROIYe, dir);
    }

    public void TakePolyROIs(Polygon[] PS) {
        this.polyROI.TakePolyROIs(PS);
    }

    public void TakePlaneROIs(Vector<Integer>[] PlanesS, Vector<Double>[] PlanesD) {
    }

    public Object clone() {
        Bundle nb = new Bundle(this.ElementModelNr, this.mincs, this.maxcs);
        nb.MIPMode = this.MIPMode;
        nb.ShowOvUn = this.ShowOvUn;
        nb.LogScale = this.LogScale;
        nb.Gamma = this.Gamma;
        nb.DispOverlay = this.DispOverlay;
        nb.TakeSqrROIs(this.rectROI.ProjMin, this.rectROI.ProjMax);
        return nb;
    }

    public static double CClip(double c) {
        return c < 0.0 ? 0.0 : (c > 1.0 ? 1.0 : c);
    }

    public static double MClip(double c) {
        return c <= 0.0 ? 0.0 : (c > 1.0 ? (c >= 2.0 ? 0.0 : 2.0 - c) : c);
    }

    public Color GetCMapColor(int pos, int mysize) {
        int cpos = pos * (this.cmapcHigh - this.cmapcLow) / mysize + this.cmapcLow;
        if (cpos >= 32768) {
            cpos = Short.MAX_VALUE;
        }
        if (cpos < 0) {
            cpos = 0;
        }
        int red = this.cmapRed[cpos] & 0xFF;
        int green = this.cmapGreen[cpos] & 0xFF;
        int blue = this.cmapBlue[cpos] & 0xFF;
        return new Color(red, green, blue);
    }

    public static Color ColFromHue(float tmp) {
        return new Color((float)Bundle.MClip((double)tmp * 1.5 + 1.0), (float)Bundle.MClip((double)tmp * 1.5 + 0.25), (float)Bundle.MClip((double)tmp * 1.5 - 0.5));
    }

    public void CompCMap() {
        double LogGain = 32768.0;
        double LogCalib = Math.log(LogGain + 1.0);
        Random myrnd = new Random(0L);
        for (int i = 0; i < 32768; ++i) {
            double tmp = ((double)i - (double)this.cmapcLow) / (double)(this.cmapcHigh - this.cmapcLow);
            if (tmp <= 0.0 || i == 0) {
                tmp = 0.0;
                if (this.ShowOvUn) {
                    this.cmapGreen[i] = 100;
                    this.cmapRed[i] = 0;
                    this.cmapBlue[i] = 0;
                    continue;
                }
            }
            if (tmp >= 1.0 || i == Short.MAX_VALUE) {
                tmp = 1.0;
                if (this.ShowOvUn) {
                    this.cmapGreen[i] = 0;
                    this.cmapRed[i] = 0;
                    this.cmapBlue[i] = -1;
                    continue;
                }
            }
            if (this.Gamma != 1.0) {
                tmp = Math.pow(tmp, this.Gamma);
            }
            if (this.LogScale) {
                tmp = Math.log(LogGain * tmp + 1.0) / LogCalib;
            }
            switch (this.ElementModelNr) {
                case 0: {
                    this.cmapRed[i] = (byte)(tmp * 255.0);
                    this.cmapGreen[i] = (byte)(tmp * 255.0);
                    this.cmapBlue[i] = (byte)(tmp * 255.0);
                    break;
                }
                case 1: {
                    this.cmapRed[i] = (byte)(tmp * 255.0);
                    this.cmapGreen[i] = 0;
                    this.cmapBlue[i] = 0;
                    break;
                }
                case 2: {
                    this.cmapRed[i] = 0;
                    this.cmapGreen[i] = (byte)(tmp * 255.0);
                    this.cmapBlue[i] = 0;
                    break;
                }
                case 3: {
                    this.cmapRed[i] = 0;
                    this.cmapGreen[i] = 0;
                    this.cmapBlue[i] = (byte)(tmp * 255.0);
                    break;
                }
                case 4: {
                    this.cmapRed[i] = (byte)(tmp * 255.0);
                    this.cmapGreen[i] = 0;
                    this.cmapBlue[i] = (byte)(tmp * 255.0);
                    break;
                }
                case 5: {
                    this.cmapRed[i] = (byte)(255.0 * Bundle.CClip(tmp * 3.0));
                    this.cmapGreen[i] = (byte)(255.0 * Bundle.CClip(tmp * 3.0 - 1.0));
                    this.cmapBlue[i] = (byte)(255.0 * Bundle.CClip(tmp * 3.0 - 2.0));
                    break;
                }
                case 6: {
                    this.cmapRed[i] = (byte)(255.0 * Bundle.CClip(tmp * 3.0 - 2.0));
                    this.cmapGreen[i] = (byte)(255.0 * Bundle.CClip(tmp * 3.0));
                    this.cmapBlue[i] = (byte)(255.0 * Bundle.CClip(tmp * 3.0 - 1.0));
                    break;
                }
                case 7: {
                    this.cmapRed[i] = (byte)(255.0 * Bundle.CClip(tmp * 3.0 - 1.0));
                    this.cmapGreen[i] = (byte)(255.0 * Bundle.CClip(tmp * 3.0));
                    this.cmapBlue[i] = (byte)(255.0 * Bundle.CClip(tmp * 3.0 - 2.0));
                    break;
                }
                case 8: {
                    this.cmapBlue[i] = (byte)(255.0 * Bundle.CClip(tmp * 3.0));
                    this.cmapGreen[i] = (byte)(255.0 * Bundle.CClip(tmp * 3.0 - 1.0));
                    this.cmapRed[i] = (byte)(255.0 * Bundle.CClip(tmp * 3.0 - 2.0));
                    break;
                }
                case 9: {
                    this.cmapRed[i] = (byte)(255.0 * Bundle.CClip(tmp * 2.0));
                    this.cmapGreen[i] = (byte)(255.0 * Bundle.CClip(tmp * 2.0 - 1.0));
                    this.cmapBlue[i] = (byte)(255.0 * Bundle.CClip(tmp * 2.0));
                    break;
                }
                case 10: {
                    this.cmapRed[i] = (byte)(255.0 * Bundle.MClip(tmp * 1.5 + 1.0));
                    this.cmapGreen[i] = (byte)(255.0 * Bundle.MClip(tmp * 1.5 + 0.25));
                    this.cmapBlue[i] = (byte)(255.0 * Bundle.MClip(tmp * 1.5 - 0.5));
                    if (i != 0) break;
                    this.cmapRed[i] = 0;
                    this.cmapGreen[i] = 0;
                    this.cmapBlue[i] = 0;
                    break;
                }
                case 11: {
                    if (i == 0) {
                        this.cmapRed[i] = 0;
                        this.cmapGreen[i] = 0;
                        this.cmapBlue[i] = 0;
                        break;
                    }
                    this.cmapRed[i] = (byte)(255.0 * myrnd.nextDouble());
                    this.cmapGreen[i] = (byte)(255.0 * myrnd.nextDouble());
                    this.cmapBlue[i] = (byte)(255.0 * myrnd.nextDouble());
                    break;
                }
                case 12: {
                    if (tmp < 0.3333333333333333) {
                        this.cmapRed[i] = (byte)(255.0 * Bundle.MClip(1.0 - tmp * 3.0));
                        this.cmapGreen[i] = (byte)(255.0 * Bundle.MClip(tmp * 3.0));
                        this.cmapBlue[i] = 0;
                    }
                    if (tmp >= 0.3333333333333333 && tmp < 0.6666666666666666) {
                        this.cmapRed[i] = 0;
                        this.cmapGreen[i] = (byte)(255.0 * Bundle.MClip(1.0 - (tmp - 0.3333333333333333) * 3.0));
                        this.cmapBlue[i] = (byte)(255.0 * Bundle.MClip((tmp - 0.3333333333333333) * 3.0));
                    }
                    if (tmp >= 0.6666666666666666) {
                        this.cmapRed[i] = (byte)(255.0 * Bundle.MClip((tmp - 0.6666666666666666) * 3.0));
                        this.cmapGreen[i] = 0;
                        this.cmapBlue[i] = (byte)(255.0 * Bundle.MClip(1.0 - (tmp - 0.6666666666666666) * 3.0));
                    }
                    if (i != 0) break;
                    this.cmapRed[i] = 0;
                    this.cmapGreen[i] = 0;
                    this.cmapBlue[i] = 0;
                    break;
                }
                default: {
                    int elem = this.ElementModelNr - 13;
                    int MapSize = MapSizes.elementAt(elem);
                    int index = (int)((double)(MapSize - 1) * tmp);
                    this.cmapRed[i] = RedMaps.elementAt(elem)[index];
                    this.cmapGreen[i] = GreenMaps.elementAt(elem)[index];
                    this.cmapBlue[i] = BlueMaps.elementAt(elem)[index];
                }
            }
            if (!this.cmapIsInverse) continue;
            this.cmapRed[i] = (byte)(255 - this.cmapRed[i]);
            this.cmapGreen[i] = (byte)(255 - this.cmapGreen[i]);
            this.cmapBlue[i] = (byte)(255 - this.cmapBlue[i]);
        }
        this.ElementModel = new IndexColorModel(15, 32768, this.cmapRed, this.cmapGreen, this.cmapBlue);
    }

    public void GenCMap() {
        this.cmapRed = new byte[32768];
        this.cmapGreen = new byte[32768];
        this.cmapBlue = new byte[32768];
        this.CompCMap();
    }

    public static int AddLookUpTable(int TableSize, byte[] reds, byte[] greens, byte[] blues) {
        MapSizes.addElement(TableSize);
        RedMaps.addElement(reds);
        GreenMaps.addElement(greens);
        BlueMaps.addElement(blues);
        return MapSizes.size() - 1;
    }

    public void ToggleModel(int actModel) {
        this.ElementModelNr = actModel < 0 ? ++this.ElementModelNr : actModel;
        if (this.ElementModelNr >= 13 + MapSizes.size()) {
            this.ElementModelNr = 0;
        }
        this.CompCMap();
    }

    public boolean ToggleOvUn(int newVal) {
        this.ShowOvUn = newVal < 0 ? !this.ShowOvUn : newVal == 1;
        this.CompCMap();
        return this.ShowOvUn;
    }

    public void SetGamma(double newVal) {
        double oldGamma = this.Gamma;
        this.Gamma = newVal;
        if (this.Gamma != oldGamma) {
            this.CompCMap();
        }
    }

    public double GetGamma() {
        return this.Gamma;
    }

    public void ToggleLog(int newVal) {
        this.LogScale = newVal < 0 ? !this.LogScale : newVal == 1;
        this.CompCMap();
    }
}

