/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import view5d.AnElement;

public class ComplexElement
extends AnElement {
    public float[] myData;
    int SizeXY;
    int readmode;

    ComplexElement(int SX, int SY, int SZ, double MaxVal) {
        super(SX, SY, SZ, MaxVal);
        this.myData = new float[2 * this.Sizes[0] * this.Sizes[1] * this.Sizes[2]];
        this.SizeXY = this.Sizes[0] * this.Sizes[1];
        this.DataType = ComplexType;
        this.readmode = 0;
    }

    @Override
    void AdvanceReadMode() {
        this.readmode = (this.readmode + 1) % 4;
    }

    @Override
    void SetReadMode(int rmode) {
        this.readmode = rmode % 4;
    }

    @Override
    void Clear() {
        for (int i = 0; i < 2 * this.Sizes[0] * this.Sizes[1] * this.Sizes[2]; ++i) {
            this.myData[i] = 0.0f;
        }
    }

    @Override
    void DeleteData() {
        this.myData = null;
    }

    @Override
    int GetStdByteNum() {
        return 4;
    }

    @Override
    void SetValueAt(int x, int y, int z, double val) {
        this.myData[2 * (x + this.Sizes[0] * y + this.SizeXY * z)] = (float)val;
    }

    void SetValueAt(int x, int y, int z, float rval, float ival) {
        this.myData[2 * (x + this.Sizes[0] * y + this.SizeXY * z)] = rval;
        this.myData[2 * (x + this.Sizes[0] * y + this.SizeXY * z) + 1] = ival;
    }

    @Override
    int GetIntValueAt(int x, int y, int z) {
        return (int)((this.GetRawValueAt(x, y, z) - this.shift) * this.scaleI);
    }

    @Override
    int GetByteValueAt(int x, int y, int z) {
        return (int)((this.GetRawValueAt(x, y, z) - this.shift) * this.scaleB);
    }

    @Override
    double GetRawValueAt(int x, int y, int z) {
        float re = this.myData[2 * (x + this.Sizes[0] * y + this.SizeXY * z)];
        float im = this.myData[2 * (x + this.Sizes[0] * y + this.SizeXY * z) + 1];
        switch (this.readmode) {
            case 0: {
                return Math.sqrt(re * re + im * im);
            }
            case 1: {
                return Math.atan2(re, im) * 180.0 / Math.PI;
            }
            case 2: {
                return re;
            }
        }
        return im;
    }

    String GetReadModeString() {
        switch (this.readmode) {
            case 0: {
                return "Abs. Value.";
            }
            case 1: {
                return "Phase [deg.]";
            }
            case 2: {
                return "Real Part";
            }
        }
        return "Imag. Part";
    }

    @Override
    double GetValueAt(int x, int y, int z) {
        return this.GetRawValueAt(x, y, z) * this.ScaleV + this.OffsetV;
    }

    @Override
    String GetValueStringAt(int x, int y, int z) {
        float re = this.myData[2 * (x + this.Sizes[0] * y + this.SizeXY * z)];
        float im = this.myData[2 * (x + this.Sizes[0] * y + this.SizeXY * z) + 1];
        String ff = "%g";
        return String.format(ff, this.GetValueAt(x, y, z)) + " (" + String.format(ff, Float.valueOf(re)) + ", " + String.format(ff, Float.valueOf(im)) + "i), " + this.GetReadModeString() + ". " + String.format(ff, this.GetRawValueAt(x, y, z));
    }

    @Override
    void ConvertSliceFromSimilar(int myslice, int bufslice, Object Ibuffer, int mstep, int moff) {
        float[] mbuffer = (float[])Ibuffer;
        for (int i = 0; i < this.SizeXY; i += mstep) {
            this.myData[2 * (i + this.Sizes[0] * this.Sizes[1] * myslice)] = mbuffer[bufslice * this.SizeXY + i + moff];
        }
    }

    @Override
    void ConvertSliceFromByte(int myslice, int bufslice, byte[] Ibuffer, int mstep, int moff) {
        float frval = 0.0f;
        float fival = 0.0f;
        int SliceSize = 4 * this.SizeXY;
        for (int i = 0; i < this.SizeXY; i += mstep) {
            int val;
            int b;
            int ival = 0;
            for (b = 1; b < 4; ++b) {
                val = Ibuffer[2 * (bufslice * SliceSize + 4 * (i + moff)) + b] & 0xFF;
                ival |= val << 8 * b;
            }
            this.myData[2 * (i + this.SizeXY * myslice)] = frval = Float.intBitsToFloat(ival);
            ival = 0;
            for (b = 1; b < 4; ++b) {
                val = Ibuffer[2 * (bufslice * SliceSize + 4 * (i + moff)) + 4 + b] & 0xFF;
                ival |= val << 8 * b;
            }
            this.myData[2 * (i + this.SizeXY * myslice) + 1] = fival = Float.intBitsToFloat(ival);
        }
    }

    @Override
    void ConvertSliceFromRGB(int myslice, int bufslice, int[] Ibuffer, int mstep, int moff, int soff) {
        throw new IllegalArgumentException("Int: Inapplicable conversion\n");
    }

    @Override
    void CopySliceToSimilar(int myslice, Object buffer) {
        float[] mbuffer = (float[])buffer;
        int i = 0;
        for (int z = 0; z < this.Sizes[2]; ++z) {
            for (int y = 0; y < this.Sizes[1]; ++y) {
                for (int x = 0; x < this.Sizes[0]; ++x) {
                    mbuffer[i] = (float)this.GetRawValueAt(x, y, z);
                    ++i;
                }
            }
        }
    }
}

