/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.io.SaveDialog;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.ParticleAnalyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;

public class ToAST25_
implements PlugInFilter,
Measurements {
    ImagePlus imp;
    int nParticles;
    float[][] ssx;
    float[][] ssy;
    String directory;
    String filename;
    static int minSize = 15;
    static int maxSize = 69;
    static int minTrackLength = 20;
    static double pixelSize = 627.0;
    static double timeLapse = 2.0;
    static boolean bSaveResultsFile = true;
    static boolean bShowLabels = true;
    static boolean bShowPositions = true;
    static boolean bShowPaths = true;
    static boolean bShowPathLengths = true;
    static boolean bCalculateCurvature = false;
    static boolean bDisplayRaw = true;
    static boolean bDisplayMotParam = false;
    static boolean patchglidersExist = false;
    static float maxVelocity = 20.0f;
    static int maxColumns = 75;
    static double spfLimit = 0.4;
    static double velLimit1 = 0.5;
    static double velLimit2 = 0.0;
    static double sepfactor = 0.0222;
    static double sepfactor2 = 0.2;
    static int filenumber = 1;
    static int slidingAverageHalfSize = 4;
    static double displacementLimit = 4.5 * pixelSize / 1000.0;
    double[][] spfactors;
    double[][] plengths;
    int[][] pixnumbers;
    double[][] curvatures;
    double[][] perimeter;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (IJ.versionLessThan((String)"1.17y")) {
            IJ.log((String)"your imageJ version is below 1.17y, quittin'");
            return 4096;
        }
        return 1;
    }

    public void run(ImageProcessor ip) {
        GenericDialog gd = new GenericDialog("ToAST25");
        gd.addMessage("TOol for Automated Sporozoite Tracking");
        gd.addNumericField("Min Object Size (pixels): ", (double)minSize, 0);
        gd.addNumericField("Max Object Size (pixels): ", (double)maxSize, 0);
        gd.addNumericField("Maximum Speed (pixels(/frame):", (double)maxVelocity, 0);
        gd.addNumericField("Minimum track length (frames)", (double)minTrackLength, 0);
        gd.addNumericField("Pixel size (in nanometers)", pixelSize, 0);
        gd.addNumericField("Time lapse (in sec)", timeLapse, 0);
        gd.addNumericField("Sliding Average HalfSize ", (double)slidingAverageHalfSize, 0);
        gd.addNumericField("Minimal elongation (0..1)", spfLimit, 1);
        gd.addNumericField("File number", (double)filenumber, 0);
        gd.addCheckbox("Save_Results File", bSaveResultsFile);
        gd.addCheckbox("Display Path Lengths", bShowPathLengths);
        gd.addCheckbox("Show_Labels", bShowLabels);
        gd.addCheckbox("Show_Positions", bShowPositions);
        gd.addCheckbox("Show_Paths", bShowPaths);
        gd.addCheckbox("Calculate Curvature", bCalculateCurvature);
        gd.addCheckbox("Output_Raw Tracking", bDisplayRaw);
        gd.addCheckbox("Output_Motility Features", bDisplayMotParam);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        minSize = (int)gd.getNextNumber();
        maxSize = (int)gd.getNextNumber();
        maxVelocity = (float)gd.getNextNumber();
        minTrackLength = (int)gd.getNextNumber();
        pixelSize = gd.getNextNumber();
        timeLapse = gd.getNextNumber();
        slidingAverageHalfSize = (int)gd.getNextNumber();
        spfLimit = gd.getNextNumber();
        filenumber = (int)gd.getNextNumber();
        bSaveResultsFile = gd.getNextBoolean();
        bShowPathLengths = gd.getNextBoolean();
        bShowLabels = gd.getNextBoolean();
        bShowPositions = gd.getNextBoolean();
        bShowPaths = gd.getNextBoolean();
        bCalculateCurvature = gd.getNextBoolean();
        bDisplayRaw = gd.getNextBoolean();
        bDisplayMotParam = gd.getNextBoolean();
        patchglidersExist = false;
        if (bShowPositions) {
            bShowLabels = true;
        }
        if (bSaveResultsFile) {
            SaveDialog sd = new SaveDialog("Save Track Results", "logfile_" + filenumber, ".txt");
            this.directory = sd.getDirectory();
            this.filename = sd.getFileName();
        }
        this.track(this.imp, minSize, maxSize, maxVelocity, this.directory, this.filename);
    }

    public void track(ImagePlus imp, int minSize, int maxSize, float maxVelocity, String directory, String filename) {
        boolean writefile;
        ArrayList theTracks;
        int trackCount;
        block172: {
            int i;
            int nFrames = imp.getStackSize();
            if (nFrames < 2) {
                IJ.showMessage((String)"Tracker", (String)"Stack required");
                return;
            }
            ImageStack stack = imp.getStack();
            int options = 0;
            int measurements = 32;
            ResultsTable rt = new ResultsTable();
            rt.reset();
            ArrayList[] theParticles = new ArrayList[nFrames];
            trackCount = 0;
            for (int iFrame = 1; iFrame <= nFrames; ++iFrame) {
                theParticles[iFrame - 1] = new ArrayList();
                rt.reset();
                ParticleAnalyzer pa = new ParticleAnalyzer(options, measurements, rt, (double)minSize, (double)maxSize);
                pa.analyze(imp, stack.getProcessor(iFrame));
                float[] sxRes = rt.getColumn(6);
                float[] syRes = rt.getColumn(7);
                if (sxRes == null) {
                    return;
                }
                for (int iPart = 0; iPart < sxRes.length; ++iPart) {
                    particle aParticle = new particle();
                    aParticle.x = sxRes[iPart];
                    aParticle.y = syRes[iPart];
                    aParticle.z = iFrame - 1;
                    theParticles[iFrame - 1].add(aParticle);
                }
                IJ.showProgress((double)((double)iFrame / (double)nFrames));
            }
            theTracks = new ArrayList();
            for (int i2 = 0; i2 <= nFrames - 1; ++i2) {
                IJ.showProgress((double)((double)i2 / (double)nFrames));
                ListIterator j = theParticles[i2].listIterator();
                while (j.hasNext()) {
                    particle aParticle = (particle)j.next();
                    if (aParticle.inTrack) continue;
                    ArrayList<particle> aTrack = new ArrayList<particle>();
                    aParticle.inTrack = true;
                    aParticle.trackNr = ++trackCount;
                    aTrack.add(aParticle);
                    boolean searchOn = true;
                    particle oldParticle = new particle();
                    particle tmpParticle = new particle();
                    oldParticle.copy(aParticle);
                    for (int iF = i2 + 1; iF <= nFrames - 1; ++iF) {
                        boolean foundOne = false;
                        particle newParticle = new particle();
                        ListIterator jF = theParticles[iF].listIterator();
                        while (jF.hasNext() && searchOn) {
                            particle testParticle = (particle)jF.next();
                            float distance = testParticle.distance(oldParticle);
                            if (distance < maxVelocity && !testParticle.inTrack) {
                                if (!foundOne) {
                                    tmpParticle = testParticle;
                                    testParticle.inTrack = true;
                                    testParticle.trackNr = trackCount;
                                    newParticle.copy(testParticle);
                                    foundOne = true;
                                    continue;
                                }
                                testParticle.flag = true;
                                if (distance < newParticle.distance(oldParticle)) {
                                    testParticle.inTrack = true;
                                    testParticle.trackNr = trackCount;
                                    newParticle.copy(testParticle);
                                    tmpParticle.inTrack = false;
                                    tmpParticle.trackNr = 0;
                                    tmpParticle = testParticle;
                                    continue;
                                }
                                newParticle.flag = true;
                                continue;
                            }
                            if (!(distance < maxVelocity)) continue;
                            testParticle.flag = true;
                        }
                        if (foundOne) {
                            aTrack.add(newParticle);
                        } else {
                            searchOn = false;
                        }
                        oldParticle.copy(newParticle);
                    }
                    theTracks.add(aTrack);
                }
            }
            String strHeadings = "Frame";
            int frameCount = 1;
            ListIterator iT = theTracks.listIterator();
            while (iT.hasNext()) {
                ArrayList bTrack = (ArrayList)iT.next();
                if (bTrack.size() < minTrackLength) continue;
                if (frameCount <= maxColumns) {
                    strHeadings = strHeadings + "\tX" + frameCount + "\tY" + frameCount + "\tFlag" + frameCount;
                }
                ++frameCount;
            }
            String contents = "";
            writefile = false;
            if (filename != null) {
                File outputfile = new File(directory, filename);
                if (!outputfile.canWrite()) {
                    try {
                        outputfile.createNewFile();
                    }
                    catch (IOException e) {
                        IJ.showMessage((String)"Error", (String)("Could not create " + directory + filename));
                    }
                }
                if (outputfile.canWrite()) {
                    writefile = true;
                } else {
                    IJ.showMessage((String)"Error", (String)("Could not write to " + directory + filename));
                }
            }
            int repeat = frameCount / maxColumns;
            float reTest = (float)frameCount / (float)maxColumns;
            int maxPossibleTrackNum = 1000;
            int paramnumber = 14;
            double[][][] parameters = new double[paramnumber][maxPossibleTrackNum][nFrames];
            float[][] xx = new float[maxPossibleTrackNum][nFrames];
            boolean pcnt = false;
            boolean fncnt = false;
            float[][] yy = new float[maxPossibleTrackNum][nFrames];
            float[][] vel = new float[maxPossibleTrackNum][nFrames];
            double[][] angles = new double[maxPossibleTrackNum][nFrames];
            this.spfactors = new double[maxPossibleTrackNum][nFrames];
            this.plengths = new double[maxPossibleTrackNum][nFrames];
            this.pixnumbers = new int[maxPossibleTrackNum][nFrames];
            this.curvatures = new double[maxPossibleTrackNum][nFrames];
            this.perimeter = new double[maxPossibleTrackNum][nFrames];
            for (int j = 0; j < maxPossibleTrackNum * nFrames; ++j) {
                angles[j / nFrames][j % nFrames] = 0.0;
                this.spfactors[j / nFrames][j % nFrames] = 0.0;
                this.plengths[j / nFrames][j % nFrames] = 0.0;
                this.pixnumbers[j / nFrames][j % nFrames] = 0;
                this.curvatures[j / nFrames][j % nFrames] = 0.0;
            }
            int tracksNum = 0;
            if (reTest > (float)repeat) {
                ++repeat;
            }
            if (!writefile) {
                IJ.setColumnHeadings((String)strHeadings);
                repeat = 1;
                for (int j = 1; j <= repeat; ++j) {
                    int to = j * maxColumns;
                    if (to > frameCount - 1) {
                        to = frameCount - 1;
                    }
                    String stLine = "Tracks " + ((j - 1) * maxColumns + 1) + " to " + to;
                    IJ.write((String)stLine);
                    for (i = 0; i <= nFrames - 1; ++i) {
                        String strLine = "" + (i + 1);
                        int trackNr = 0;
                        int listTrackNr = 0;
                        ListIterator iT2 = theTracks.listIterator();
                        while (iT2.hasNext()) {
                            ++trackNr;
                            ArrayList bTrack = (ArrayList)iT2.next();
                            boolean particleFound = false;
                            if (bTrack.size() < minTrackLength || ++listTrackNr <= (j - 1) * maxColumns || listTrackNr > j * maxColumns) continue;
                            ListIterator k = theParticles[i].listIterator();
                            while (k.hasNext() && !particleFound) {
                                particle aParticle = (particle)k.next();
                                if (aParticle.trackNr != trackNr) continue;
                                particleFound = true;
                                String flag = aParticle.flag ? "*" : " ";
                                strLine = strLine + "\t" + aParticle.x + "\t" + aParticle.y + "\t";
                            }
                            if (particleFound) continue;
                            strLine = strLine + "\t \t \t ";
                        }
                        IJ.write((String)strLine);
                    }
                }
            }
            try {
                int i3;
                File outputfile = new File(directory, filename);
                BufferedWriter dos = new BufferedWriter(new FileWriter(outputfile));
                if (bShowLabels) {
                    for (i = 0; i <= nFrames - 1; ++i) {
                        int iFrame = i + 1;
                        String strLine = "" + i;
                        ImageProcessor ip = stack.getProcessor(iFrame);
                        int trackNr = 0;
                        int displayTrackNr = 0;
                        ListIterator iT3 = theTracks.listIterator();
                        while (iT3.hasNext()) {
                            ++trackNr;
                            ArrayList bTrack = (ArrayList)iT3.next();
                            if (bTrack.size() < minTrackLength) continue;
                            ++displayTrackNr;
                            ListIterator k = theParticles[i].listIterator();
                            while (k.hasNext()) {
                                particle aParticle = (particle)k.next();
                                if (aParticle.trackNr != trackNr) continue;
                                String strPart = "" + displayTrackNr;
                                if (!bShowPositions) continue;
                                strPart = strPart + "=" + (int)aParticle.x + "," + (int)aParticle.y;
                                xx[displayTrackNr][i] = aParticle.x;
                                yy[displayTrackNr][i] = aParticle.y;
                            }
                        }
                        tracksNum = displayTrackNr;
                        IJ.showProgress((double)((double)iFrame / (double)nFrames));
                    }
                }
                dos.write("Filenum_" + filenumber + "\n");
                for (int iFrame = 1; iFrame < nFrames; ++iFrame) {
                    int i4;
                    IJ.showStatus((String)("Processing frame " + iFrame + "/" + nFrames));
                    ImageProcessor iProc = stack.getProcessor(iFrame);
                    iProc = iProc.convertToRGB();
                    int[] pixels = (int[])iProc.getPixels();
                    int W = iProc.getWidth();
                    int H = iProc.getHeight();
                    int bright = 0;
                    int step = 1;
                    double currAngle = 0.0;
                    for (i4 = 0; i4 < W * H; ++i4) {
                        pixels[i4] = pixels[i4] + 0x1000000 & 0xFF;
                    }
                    for (i4 = 1; i4 <= tracksNum; ++i4) {
                        --iFrame;
                        double borderShift = 2.0 * Math.sqrt((maxSize - minSize) / 2);
                        currAngle = -500.0;
                        if ((double)xx[i4][iFrame] > borderShift && (double)yy[i4][iFrame] > borderShift && (double)xx[i4][iFrame] < (double)W - borderShift && (double)yy[i4][iFrame] < (double)H - borderShift) {
                            if (pixels[(int)xx[i4][iFrame] + (int)yy[i4][iFrame] * W] == bright) {
                                currAngle = this.segmentation(pixels, W, H, (int)xx[i4][iFrame], (int)yy[i4][iFrame], bright, minSize, maxSize, i4, iFrame);
                            } else {
                                while (currAngle == -500.0 && step < 16) {
                                    if (pixels[(int)(xx[i4][iFrame] + (float)step) + (int)yy[i4][iFrame] * W] == bright) {
                                        currAngle = this.segmentation(pixels, W, H, (int)xx[i4][iFrame] + step, (int)yy[i4][iFrame], bright, minSize, maxSize, i4, iFrame);
                                    } else if (pixels[(int)(xx[i4][iFrame] - (float)step) + (int)yy[i4][iFrame] * W] == bright) {
                                        currAngle = this.segmentation(pixels, W, H, (int)xx[i4][iFrame] - step, (int)yy[i4][iFrame], bright, minSize, maxSize, i4, iFrame);
                                    } else if (pixels[(int)xx[i4][iFrame] + (int)(yy[i4][iFrame] + (float)step) * W] == bright) {
                                        currAngle = this.segmentation(pixels, W, H, (int)xx[i4][iFrame], (int)yy[i4][iFrame] + step, bright, minSize, maxSize, i4, iFrame);
                                    } else if (pixels[(int)xx[i4][iFrame] + (int)(yy[i4][iFrame] - (float)step) * W] == bright) {
                                        currAngle = this.segmentation(pixels, W, H, (int)xx[i4][iFrame], (int)yy[i4][iFrame] - step, bright, minSize, maxSize, i4, iFrame);
                                    } else if (pixels[(int)(xx[i4][iFrame] + (float)(step / 2)) + (int)(yy[i4][iFrame] + (float)(step / 2)) * W] == bright) {
                                        currAngle = this.segmentation(pixels, W, H, (int)(xx[i4][iFrame] + (float)(step / 2)), (int)(yy[i4][iFrame] + (float)(step / 2)), bright, minSize, maxSize, i4, iFrame);
                                    } else if (pixels[(int)(xx[i4][iFrame] - (float)(step / 2)) + (int)(yy[i4][iFrame] + (float)(step / 2)) * W] == bright) {
                                        currAngle = this.segmentation(pixels, W, H, (int)(xx[i4][iFrame] - (float)(step / 2)), (int)(yy[i4][iFrame] + (float)(step / 2)), bright, minSize, maxSize, i4, iFrame);
                                    } else if (pixels[(int)(xx[i4][iFrame] + (float)(step / 2)) + (int)(yy[i4][iFrame] - (float)(step / 2)) * W] == bright) {
                                        currAngle = this.segmentation(pixels, W, H, (int)(xx[i4][iFrame] + (float)(step / 2)), (int)(yy[i4][iFrame] - (float)(step / 2)), bright, minSize, maxSize, i4, iFrame);
                                    } else if (pixels[(int)(xx[i4][iFrame] - (float)(step / 2)) + (int)(yy[i4][iFrame] - (float)(step / 2)) * W] == bright) {
                                        currAngle = this.segmentation(pixels, W, H, (int)(xx[i4][iFrame] - (float)(step / 2)), (int)(yy[i4][iFrame] - (float)(step / 2)), bright, minSize, maxSize, i4, iFrame);
                                    } else if (pixels[(int)(xx[i4][iFrame] - (float)(step / 4)) + (int)(yy[i4][iFrame] - (float)(step / 4)) * W] == bright) {
                                        currAngle = this.segmentation(pixels, W, H, (int)(xx[i4][iFrame] - (float)(step / 4)), (int)(yy[i4][iFrame] - (float)(step / 4)), bright, minSize, maxSize, i4, iFrame);
                                    } else if (pixels[(int)(xx[i4][iFrame] - (float)(step / 4)) + (int)(yy[i4][iFrame] - (float)(step / 4)) * W] == bright) {
                                        currAngle = this.segmentation(pixels, W, H, (int)(xx[i4][iFrame] - (float)(step / 4)), (int)(yy[i4][iFrame] - (float)(step / 4)), bright, minSize, maxSize, i4, iFrame);
                                    } else if (pixels[(int)(xx[i4][iFrame] - (float)(step / 4)) + (int)(yy[i4][iFrame] - (float)(step / 4)) * W] == bright) {
                                        currAngle = this.segmentation(pixels, W, H, (int)(xx[i4][iFrame] - (float)(step / 4)), (int)(yy[i4][iFrame] - (float)(step / 4)), bright, minSize, maxSize, i4, iFrame);
                                    } else if (pixels[(int)(xx[i4][iFrame] - (float)(step / 4)) + (int)(yy[i4][iFrame] - (float)(step / 4)) * W] == bright) {
                                        currAngle = this.segmentation(pixels, W, H, (int)(xx[i4][iFrame] - (float)(step / 4)), (int)(yy[i4][iFrame] - (float)(step / 4)), bright, minSize, maxSize, i4, iFrame);
                                    }
                                    ++step;
                                }
                            }
                        }
                        angles[i4][++iFrame - 1] = currAngle;
                        for (int b = 0; b < W; ++b) {
                            if ((int)((double)b * Math.tan(currAngle * 6.28 / 360.0) + (double)yy[i4][iFrame] * Math.tan(currAngle * 6.28 / 360.0)) <= 0 || (int)((double)b * Math.tan(currAngle * 6.28 / 360.0) + (double)yy[i4][iFrame] * Math.tan(currAngle * 6.28 / 360.0)) >= H) continue;
                            pixels[b + W * (int)((double)b * Math.tan((double)(currAngle * 6.28 / 360.0)) + (double)yy[i4][iFrame] * Math.tan((double)(currAngle * 6.28 / 360.0)))] = 255;
                        }
                    }
                }
                for (int i5 = 1; i5 <= tracksNum; ++i5) {
                    int b;
                    vel[i5][0] = 0.0f;
                    double sumSpf = 0.0;
                    double spfcnt = 0.0;
                    for (b = 0; b < nFrames - 1; ++b) {
                        if (this.spfactors[i5][b] == 0.0) continue;
                        sumSpf += this.spfactors[i5][b];
                        spfcnt += 1.0;
                    }
                    if ((sumSpf /= spfcnt) < spfLimit) continue;
                    for (b = 1; b < nFrames - 1; ++b) {
                        vel[i5][b] = xx[i5][b - 1] > 0.0f && yy[i5][b - 1] > 0.0f && xx[i5][b] > 0.0f && yy[i5][b] > 0.0f ? (float)Math.sqrt((xx[i5][b] - xx[i5][b - 1]) * (xx[i5][b] - xx[i5][b - 1]) + (yy[i5][b] - yy[i5][b - 1]) * (yy[i5][b] - yy[i5][b - 1])) * (float)pixelSize / (float)timeLapse / 1000.0f : 0.0f;
                        double angle = (Math.atan((double)(yy[i5][b + 1] - yy[i5][b]) / (double)(xx[i5][b + 1] - xx[i5][b])) - Math.atan((double)(yy[i5][b] - yy[i5][b - 1]) / (double)(xx[i5][b] - xx[i5][b - 1]))) * 360.0 / 6.28 * timeLapse / 2.0;
                        double a2 = (xx[i5][b - 1] - xx[i5][b]) * (xx[i5][b - 1] - xx[i5][b]) + (yy[i5][b - 1] - yy[i5][b]) * (yy[i5][b - 1] - yy[i5][b]);
                        double b2 = (xx[i5][b + 1] - xx[i5][b]) * (xx[i5][b + 1] - xx[i5][b]) + (yy[i5][b + 1] - yy[i5][b]) * (yy[i5][b + 1] - yy[i5][b]);
                        double c2 = (xx[i5][b + 1] - xx[i5][b - 1]) * (xx[i5][b + 1] - xx[i5][b - 1]) + (yy[i5][b + 1] - yy[i5][b - 1]) * (yy[i5][b + 1] - yy[i5][b - 1]);
                        if (a2 + b2 > c2 && Math.abs(angle) < -90.0 || a2 + b2 < c2 && Math.abs(angle) > 90.0) {
                            angle = -1.0 * Math.min(180.0 - Math.abs(angle), Math.abs(angle)) * (angle / Math.abs(angle));
                        }
                        if (!(angle < 180.0) || !(angle > -180.0)) {
                            angle = 0.0;
                        }
                        double angle_m = Math.atan((double)(yy[i5][b + 1] - yy[i5][b]) / (double)(xx[i5][b + 1] - xx[i5][b])) * 360.0 / 6.28;
                        if (xx[i5][b + 1] < xx[i5][b] && yy[i5][b + 1] <= yy[i5][b]) {
                            angle_m += 180.0;
                        } else if (xx[i5][b + 1] < xx[i5][b] && yy[i5][b + 1] >= yy[i5][b]) {
                            angle_m += 360.0;
                        } else if (xx[i5][b + 1] > xx[i5][b] && yy[i5][b + 1] <= yy[i5][b]) {
                            angle_m += 180.0;
                        } else if (xx[i5][b + 1] == xx[i5][b] && yy[i5][b + 1] < yy[i5][b]) {
                            angle_m = 90.0;
                        } else if (xx[i5][b + 1] == xx[i5][b] && yy[i5][b + 1] > yy[i5][b]) {
                            angle_m = 270.0;
                        } else if (xx[i5][b + 1] == xx[i5][b] && yy[i5][b + 1] == yy[i5][b]) {
                            angle_m = 0.0;
                        }
                        parameters[0][i5][b] = vel[i5][b];
                        parameters[1][i5][b] = angle;
                        parameters[2][i5][b] = angles[i5][b];
                        if (this.spfactors[i5][b] >= 0.0 && this.spfactors[i5][b] <= 1.0) {
                            parameters[3][i5][b] = this.spfactors[i5][b];
                        }
                        parameters[4][i5][b] = this.plengths[i5][b];
                        parameters[5][i5][b] = Math.abs(this.pixnumbers[i5][b]);
                        parameters[6][i5][b] = this.curvatures[i5][b];
                        parameters[7][i5][b] = this.perimeter[i5][b];
                        parameters[8][i5][b] = b;
                        parameters[10][i5][b] = xx[i5][b];
                        parameters[11][i5][b] = yy[i5][b];
                        parameters[12][i5][b] = angle_m;
                        parameters[13][i5][b] = i5;
                        if (b >= slidingAverageHalfSize * 2 + 1) {
                            double vel1 = 0.0;
                            double angle1 = 0.0;
                            double angle2 = 0.0;
                            for (int t = 0; t < slidingAverageHalfSize * 2 + 1; ++t) {
                                vel1 += (double)vel[i5][b - t] / (double)(slidingAverageHalfSize * 2 + 1);
                                angle1 += Math.abs(angles[i5][b - t]) / (double)(slidingAverageHalfSize * 2 + 1);
                                angle2 = angles[i5][b - t] / (double)(slidingAverageHalfSize * 2 + 1);
                            }
                            parameters[9][i5][b] = vel1 <= velLimit1 ? 0.0 : (vel1 > Math.abs(angle1) * sepfactor2 + velLimit2 && patchglidersExist ? 4.0 : (angle2 > 0.0 && vel1 > Math.abs(angle1) * sepfactor ? 2.0 : (angle2 < 0.0 && vel1 > Math.abs(angle1) * sepfactor ? 3.0 : 1.0)));
                        }
                        if (bDisplayRaw) {
                            if (xx[i5][b - 1] == 0.0f && yy[i5][b - 1] == 0.0f) {
                                dos.write("" + i5 + " picnum " + (b + 1) + " x&y " + xx[i5][b] + " " + yy[i5][b] + " Speed(microm/sec) " + vel[i5][b] + " rotatonal_speed " + 0 + " angle_orientation " + 0 + " SpFactor " + this.spfactors[i5][b] + " length " + this.plengths[i5][b] + " pixelnumber " + this.pixnumbers[i5][b] + " curvature " + this.curvatures[i5][b] + " perimeter " + this.perimeter[i5][b] + " moving_dir " + angle_m + " Moving_Type " + parameters[9][i5][b] + "\n");
                            } else if (xx[i5][b + 1] == 0.0f && yy[i5][b + 1] == 0.0f) {
                                dos.write("" + i5 + " picnum " + (b + 1) + " x&y " + xx[i5][b] + " " + yy[i5][b] + " speed(microm/sec) " + vel[i5][b] + " rotatonal_speed " + 0 + " angle_orientation " + 0 + " SpFactor " + this.spfactors[i5][b] + " length " + this.plengths[i5][b] + " pixelnumber " + this.pixnumbers[i5][b] + " curvature " + this.curvatures[i5][b] + " perimeter " + this.perimeter[i5][b] + " moving_dir " + angle_m + " Moving_Type " + parameters[9][i5][b] + "\n");
                            } else if (xx[i5][b] == 0.0f && yy[i5][b] == 0.0f) {
                                dos.write("" + i5 + " picnum " + (b + 1) + " x&y " + xx[i5][b] + " " + yy[i5][b] + " speed(microm/sec) " + 0 + " rotatonal_speed " + 0 + " angle_orientation " + 0 + " SpFactor " + this.spfactors[i5][b] + " length " + this.plengths[i5][b] + " pixelnumber " + this.pixnumbers[i5][b] + " curvature " + this.curvatures[i5][b] + " perimeter " + this.perimeter[i5][b] + " moving_dir " + angle_m + " Moving_Type " + parameters[9][i5][b] + "\n");
                            } else {
                                dos.write("" + i5 + " picnum " + (b + 1) + " x&y " + xx[i5][b] + " " + yy[i5][b] + " speed(microm/sec) " + vel[i5][b] + " rotatonal_speed " + angle + " angle_orientation " + angles[i5][b] + " SpFactor " + this.spfactors[i5][b] + " length " + this.plengths[i5][b] + " pixelnumber " + this.pixnumbers[i5][b] + " curvature " + this.curvatures[i5][b] + " perimeter " + this.perimeter[i5][b] + " moving_dir " + angle_m + " Moving_Type " + parameters[9][i5][b] + "\n");
                            }
                        }
                        angles[i5][b] = xx[i5][b - 1] > 0.0f && yy[i5][b - 1] > 0.0f && xx[i5][b + 1] > 0.0f && yy[i5][b + 1] > 0.0f ? angle : 0.0;
                    }
                }
                IJ.showStatus((String)"Visualising ");
                if (bShowLabels) {
                    ImageStack newstack = imp.createEmptyStack();
                    int xHeight = newstack.getHeight();
                    int yWidth = newstack.getWidth();
                    for (int i6 = 0; i6 <= nFrames - 1; ++i6) {
                        int iFrame = i6 + 1;
                        String strLine = "" + i6;
                        ImageProcessor ip = stack.getProcessor(iFrame);
                        newstack.addSlice(stack.getSliceLabel(iFrame), ip.crop());
                        ImageProcessor nip = newstack.getProcessor(iFrame);
                        nip.setColor(Color.black);
                        int trackNr = 0;
                        int displayTrackNr = 0;
                        ListIterator iT4 = theTracks.listIterator();
                        while (iT4.hasNext()) {
                            ++trackNr;
                            ArrayList bTrack = (ArrayList)iT4.next();
                            if (bTrack.size() < minTrackLength) continue;
                            ++displayTrackNr;
                            ListIterator k = theParticles[i6].listIterator();
                            while (k.hasNext()) {
                                particle aParticle = (particle)k.next();
                                if (aParticle.trackNr != trackNr) continue;
                                String strPart = "" + displayTrackNr;
                                if (bShowPositions) {
                                    strPart = strPart + "=" + (int)aParticle.x + "," + (int)aParticle.y + "," + (int)parameters[9][displayTrackNr][i6];
                                }
                                nip.moveTo((int)aParticle.x + 5, this.doOffset((int)aParticle.y, yWidth, 5));
                                double sumSpf = 0.0;
                                double spfcnt = 0.0;
                                for (int b = 0; b < nFrames - 1; ++b) {
                                    if (this.spfactors[displayTrackNr][b] == 0.0) continue;
                                    sumSpf += this.spfactors[displayTrackNr][b];
                                    spfcnt += 1.0;
                                }
                                if ((sumSpf /= spfcnt) > spfLimit) {
                                    nip.drawString(strPart);
                                    continue;
                                }
                                nip.drawString("=" + displayTrackNr + "," + 0 + "." + (int)(100.0 * sumSpf));
                            }
                        }
                        tracksNum = displayTrackNr;
                        IJ.showProgress((double)((double)iFrame / (double)nFrames));
                    }
                    ImagePlus nimp = new ImagePlus(imp.getTitle() + " labels", newstack);
                    nimp.show();
                    imp.show();
                    nimp.updateAndDraw();
                }
                dos.write("overall statistics for each parasite\n");
                long totalTime = 0L;
                long waverTime = 0L;
                long ccwTime = 0L;
                long cwTime = 0L;
                long attachedTime = 0L;
                long patchGlidingTime = 0L;
                for (int i7 = 1; i7 <= tracksNum; ++i7) {
                    int b;
                    long totalTimeParasite = 0L;
                    long waverTimeParasite = 0L;
                    long ccwTimeParasite = 0L;
                    long cwTimeParasite = 0L;
                    long attachedTimeParasite = 0L;
                    long patchGlidingTimeParasite = 0L;
                    double sumSpf = 0.0;
                    double spfcnt = 0.0;
                    for (b = 0; b < nFrames - 1; ++b) {
                        if (this.spfactors[i7][b] == 0.0) continue;
                        sumSpf += this.spfactors[i7][b];
                        spfcnt += 1.0;
                    }
                    if ((sumSpf /= spfcnt) < spfLimit) continue;
                    for (b = 1; b < nFrames - 1; ++b) {
                        if (angles[i7][b] * (double)vel[i7][b] == 0.0) continue;
                        ++totalTimeParasite;
                        if ((double)vel[i7][b] <= velLimit1) {
                            ++attachedTimeParasite;
                            continue;
                        }
                        if ((double)vel[i7][b] > Math.abs(angles[i7][b]) * sepfactor2 + velLimit2 && patchglidersExist) {
                            ++patchGlidingTimeParasite;
                            continue;
                        }
                        if (angles[i7][b] > 0.0 && (double)vel[i7][b] > Math.abs(angles[i7][b]) * sepfactor) {
                            ++cwTimeParasite;
                            continue;
                        }
                        if (angles[i7][b] < 0.0 && (double)vel[i7][b] > Math.abs(angles[i7][b]) * sepfactor) {
                            ++ccwTimeParasite;
                            continue;
                        }
                        ++waverTimeParasite;
                    }
                    dos.write("Track" + i7 + " Total_time(frames) " + totalTimeParasite + " Attached " + attachedTimeParasite + " Waving " + waverTimeParasite + " CWmover " + cwTimeParasite + " CCWmover " + ccwTimeParasite + " PatchGliding " + patchGlidingTimeParasite + "\n");
                    totalTime += totalTimeParasite;
                    waverTime += waverTimeParasite;
                    ccwTime += ccwTimeParasite;
                    cwTime += cwTimeParasite;
                    attachedTime += attachedTimeParasite;
                    patchGlidingTime += patchGlidingTimeParasite;
                }
                dos.write("Total Total_time(frames) " + totalTime + " Attached " + attachedTime + " Waving " + waverTime + " CWmover " + cwTime + " CCWmover " + ccwTime + " patchGliding " + patchGlidingTime + "\n");
                int arraysize = (int)Math.max(32000.0, (double)(nFrames * tracksNum) / 1.5);
                double[][][] parameters_movingtypes = new double[paramnumber][5][arraysize];
                double[][] angles_abs_movingtypes = new double[5][arraysize];
                double[][] vels_movingtypes = new double[5][arraysize];
                double[][] spfactors_movingtypes = new double[5][arraysize];
                double[][] lengths_movingtypes = new double[5][arraysize];
                double[][] pixelnums_movingtypes = new double[5][arraysize];
                int[] cnt = new int[]{0, 0, 0, 0, 0};
                double[][] statelengths = new double[5][arraysize];
                int[] statescnt = new int[5];
                int[] unfinished_states = new int[5];
                dos.write("overall statistics for each parasite(sliding_average_of_" + (2 * slidingAverageHalfSize + 1) + "_frames)\n");
                totalTime = 0L;
                waverTime = 0L;
                ccwTime = 0L;
                cwTime = 0L;
                attachedTime = 0L;
                patchGlidingTime = 0L;
                boolean spfscrew = false;
                long[][] stateTransmissions = new long[5][5];
                long[][] stateTransmissionsCondition = new long[5][5];
                for (int b = 0; b < 5; ++b) {
                    for (int g = 0; g < 5; ++g) {
                        stateTransmissions[b][g] = 0L;
                        stateTransmissionsCondition[b][g] = 0L;
                    }
                }
                double[][] sameStateProbability = new double[5][nFrames];
                long[][] sameStateCnt = new long[5][nFrames];
                double[][] stateDisplacement = new double[5][nFrames];
                double[][] stateDisplacementConditional = new double[5][nFrames];
                long[][] sameStateCntConditional = new long[5][nFrames];
                for (i3 = 1; i3 <= tracksNum; ++i3) {
                    int j;
                    int b;
                    long totalTimeParasite = 0L;
                    long waverTimeParasite = 0L;
                    long ccwTimeParasite = 0L;
                    long cwTimeParasite = 0L;
                    long attachedTimeParasite = 0L;
                    long patchGlidingTimeParasite = 0L;
                    double sumSpf = 0.0;
                    double spfcnt = 0.0;
                    for (int b2 = 0; b2 < nFrames - 1; ++b2) {
                        if (this.spfactors[i3][b2] == 0.0) continue;
                        sumSpf += this.spfactors[i3][b2];
                        spfcnt += 1.0;
                    }
                    if ((sumSpf /= spfcnt) < spfLimit) continue;
                    double[][] params_ave = new double[paramnumber][nFrames - 2 * slidingAverageHalfSize];
                    double[] angles_ave = new double[nFrames - 2 * slidingAverageHalfSize];
                    double[] angles_abs_ave = new double[nFrames - 2 * slidingAverageHalfSize];
                    double[] vel_ave = new double[nFrames - 2 * slidingAverageHalfSize];
                    double[] spfactors_ave = new double[nFrames - 2 * slidingAverageHalfSize];
                    double[] length_ave = new double[nFrames - 2 * slidingAverageHalfSize];
                    double[] pixelsize_ave = new double[nFrames - 2 * slidingAverageHalfSize];
                    int index = 0;
                    int belongflag = 0;
                    int spffalse = 0;
                    int oldbelongflag = 0;
                    int timeshift = 0;
                    int[] states = new int[nFrames];
                    for (int g = 0; g < nFrames - 2 * slidingAverageHalfSize; ++g) {
                        angles_ave[g] = 0.0;
                        vel_ave[g] = 0.0;
                    }
                    for (int b3 = 0; b3 < nFrames - 2 * slidingAverageHalfSize - 1; ++b3) {
                        if ((double)vel[i3][b3] * angles[i3][b3] == 0.0 || (double)vel[i3][b3 + 2 * slidingAverageHalfSize + 1] * angles[i3][b3 + 2 * slidingAverageHalfSize + 1] == 0.0) {
                            ++timeshift;
                            continue;
                        }
                        for (int g = 0; g < 2 * slidingAverageHalfSize + 1; ++g) {
                            for (int k1 = 0; k1 < paramnumber; ++k1) {
                                if (k1 != 2) {
                                    double[] dArray = params_ave[k1];
                                    int n = index;
                                    dArray[n] = dArray[n] + parameters[k1][i3][b3 + g] / (double)(2 * slidingAverageHalfSize + 1);
                                    continue;
                                }
                                if (k1 != 2 || !(Math.abs(parameters[2][i3][b3 + g]) < 180.0)) continue;
                                double[] dArray = params_ave[k1];
                                int n = index;
                                dArray[n] = dArray[n] + parameters[k1][i3][b3 + g] / (double)(2 * slidingAverageHalfSize + 1);
                            }
                            int n = index;
                            angles_ave[n] = angles_ave[n] + angles[i3][b3 + g] / (double)(2 * slidingAverageHalfSize + 1);
                            if (Math.abs(angles[i3][b3 + g]) < 180.0) {
                                int n2 = index;
                                angles_abs_ave[n2] = angles_abs_ave[n2] + Math.abs(angles[i3][b3 + g]) / (double)(2 * slidingAverageHalfSize + 1);
                            }
                            if (vel[i3][b3 + g] < maxVelocity) {
                                int n3 = index;
                                vel_ave[n3] = vel_ave[n3] + (double)(vel[i3][b3 + g] / (float)(2 * slidingAverageHalfSize + 1));
                            }
                            if (this.spfactors[i3][b3 + g] >= 0.0 && this.spfactors[i3][b3 + g] <= 1.0) {
                                int n4 = index;
                                spfactors_ave[n4] = spfactors_ave[n4] + this.spfactors[i3][b3 + g];
                            } else {
                                ++spffalse;
                            }
                            int n5 = index;
                            length_ave[n5] = length_ave[n5] + this.plengths[i3][b3 + g] / (double)(2 * slidingAverageHalfSize + 1);
                            int n6 = index;
                            pixelsize_ave[n6] = pixelsize_ave[n6] + (double)(this.pixnumbers[i3][b3 + g] / (2 * slidingAverageHalfSize + 1));
                        }
                        if (spfactors_ave[index] > 0.0 && spfactors_ave[index] < (double)(2 * slidingAverageHalfSize + 1) && 2 * slidingAverageHalfSize + 1 - spffalse > 0) {
                            int n = index;
                            spfactors_ave[n] = spfactors_ave[n] / (double)(2 * slidingAverageHalfSize + 1 - spffalse);
                        } else {
                            --index;
                        }
                        ++index;
                    }
                    int curr_tracklen = 0;
                    double[] displacement = new double[nFrames - 2 * slidingAverageHalfSize];
                    double[] ave_displacement = new double[nFrames - 2 * slidingAverageHalfSize];
                    for (b = 0; b < index; ++b) {
                        displacement[b] = Math.sqrt(params_ave[10][b] - parameters[10][i3][timeshift + b]);
                    }
                    for (b = 2 * slidingAverageHalfSize + 1; b < index; ++b) {
                        for (int g = 0; g < 2 * slidingAverageHalfSize + 1; ++g) {
                            int n = b;
                            ave_displacement[n] = ave_displacement[n] + Math.sqrt((params_ave[10][b - g] - parameters[10][i3][timeshift + b - g]) * (params_ave[10][b - g] - parameters[10][i3][timeshift + b - g]) + (params_ave[11][b - g] - parameters[11][i3][timeshift + b - g]) * (params_ave[11][b - g] - parameters[11][i3][timeshift + b - g])) / (double)(2 * slidingAverageHalfSize + 1);
                        }
                    }
                    for (b = 0; b < index; ++b) {
                        ++totalTimeParasite;
                        if (vel_ave[b] <= velLimit1) {
                            ++attachedTimeParasite;
                            belongflag = 0;
                            cnt[0] = cnt[0] + 1;
                        } else if (vel_ave[b] > Math.abs(angles_ave[b]) * sepfactor2 + velLimit2 && patchglidersExist) {
                            ++patchGlidingTimeParasite;
                            belongflag = 4;
                            cnt[4] = cnt[4] + 1;
                        } else if (angles_ave[b] > 0.0 && vel_ave[b] > Math.abs(angles_abs_ave[b]) * sepfactor) {
                            if (patchglidersExist && ave_displacement[b] * pixelSize / 1000.0 / params_ave[0][b] < displacementLimit && b > 2 * slidingAverageHalfSize && params_ave[0][b] > velLimit2) {
                                ++patchGlidingTimeParasite;
                                belongflag = 4;
                                cnt[4] = cnt[4] + 1;
                                IJ.log((String)("NUM " + i3 + " 1.displacement " + ave_displacement[b] * pixelSize / 1000.0 / params_ave[0][b] + " b " + b + " ave_vel " + params_ave[0][b] + " checked"));
                            } else {
                                ++cwTimeParasite;
                                belongflag = 2;
                                cnt[2] = cnt[2] + 1;
                            }
                        } else if (angles_ave[b] < 0.0 && vel_ave[b] > Math.abs(angles_abs_ave[b]) * sepfactor) {
                            if (patchglidersExist && ave_displacement[b] * pixelSize / 1000.0 / params_ave[0][b] < displacementLimit && b > 2 * slidingAverageHalfSize && params_ave[0][b] > velLimit2) {
                                ++patchGlidingTimeParasite;
                                belongflag = 4;
                                cnt[4] = cnt[4] + 1;
                                IJ.log((String)("NUM " + i3 + " 2.displacement " + ave_displacement[b] * pixelSize / 1000.0 / params_ave[0][b] + " b " + b + " ave_vel " + params_ave[0][b] + " checked"));
                            } else {
                                ++ccwTimeParasite;
                                belongflag = 3;
                                cnt[3] = cnt[3] + 1;
                            }
                        } else {
                            ++waverTimeParasite;
                            belongflag = 1;
                            cnt[1] = cnt[1] + 1;
                        }
                        for (int k1 = 0; k1 < paramnumber; ++k1) {
                            parameters_movingtypes[k1][belongflag][cnt[belongflag] - 1] = params_ave[k1][b];
                        }
                        angles_abs_movingtypes[belongflag][cnt[belongflag] - 1] = angles_abs_ave[b];
                        vels_movingtypes[belongflag][cnt[belongflag] - 1] = vel_ave[b];
                        spfactors_movingtypes[belongflag][cnt[belongflag] - 1] = spfactors_ave[b];
                        lengths_movingtypes[belongflag][cnt[belongflag] - 1] = length_ave[b];
                        pixelnums_movingtypes[belongflag][cnt[belongflag] - 1] = pixelsize_ave[b];
                        if (b > 0) {
                            long[] lArray = stateTransmissions[oldbelongflag];
                            int n = belongflag;
                            lArray[n] = lArray[n] + 1L;
                        }
                        if (b > 0 && oldbelongflag != belongflag && (double)curr_tracklen * timeLapse > 5.0) {
                            long[] lArray = stateTransmissionsCondition[oldbelongflag];
                            int n = belongflag;
                            lArray[n] = lArray[n] + 1L;
                        }
                        if (b > 0 && oldbelongflag == belongflag) {
                            ++curr_tracklen;
                        } else {
                            statelengths[oldbelongflag][statescnt[oldbelongflag]] = (double)curr_tracklen * timeLapse;
                            int n = oldbelongflag;
                            statescnt[n] = statescnt[n] + 1;
                            curr_tracklen = 0;
                        }
                        if (b == index - 1 && oldbelongflag == belongflag) {
                            statelengths[oldbelongflag][statescnt[oldbelongflag]] = (double)curr_tracklen * timeLapse;
                            int n = oldbelongflag;
                            statescnt[n] = statescnt[n] + 1;
                            curr_tracklen = 0;
                        }
                        oldbelongflag = belongflag;
                        states[b] = belongflag;
                    }
                    for (int len = 0; len < index - 5; ++len) {
                        boolean finishflag = false;
                        for (j = 0; j < 5; ++j) {
                            if (states[len] != j) continue;
                            for (int in = len; in < index; ++in) {
                                long[] lArray = sameStateCnt[j];
                                int n = in - len;
                                lArray[n] = lArray[n] + 1L;
                                double tmp = Math.sqrt(Math.pow(params_ave[10][len] - params_ave[10][in], 2.0) + Math.pow(params_ave[11][len] - params_ave[11][in], 2.0));
                                if (states[in] == j && tmp < 100.0) {
                                    double[] dArray = sameStateProbability[j];
                                    int n7 = in - len;
                                    dArray[n7] = dArray[n7] + 1.0;
                                }
                                if (tmp < 100.0) {
                                    double[] dArray = stateDisplacement[j];
                                    int n8 = in - len;
                                    dArray[n8] = dArray[n8] + tmp;
                                }
                                if (states[len] != states[j]) {
                                    finishflag = true;
                                }
                                if (finishflag) continue;
                                if (tmp < 100.0) {
                                    double[] dArray = stateDisplacementConditional[j];
                                    int n9 = in - len;
                                    dArray[n9] = dArray[n9] + Math.sqrt(Math.pow(params_ave[10][len] - params_ave[10][in], 2.0) + Math.pow(params_ave[11][len] - params_ave[11][in], 2.0));
                                }
                                if (!(tmp < 100.0)) continue;
                                long[] lArray2 = sameStateCntConditional[j];
                                int n10 = in - len;
                                lArray2[n10] = lArray2[n10] + 1L;
                            }
                        }
                    }
                    dos.write("Track" + i3 + " Total_time(frames) " + totalTimeParasite + " Attached " + attachedTimeParasite + " Waving " + waverTimeParasite + " CWmover " + cwTimeParasite + " CCWmover " + ccwTimeParasite + " Patchgliding " + patchGlidingTimeParasite + "\n");
                    totalTime += totalTimeParasite;
                    waverTime += waverTimeParasite;
                    ccwTime += ccwTimeParasite;
                    cwTime += cwTimeParasite;
                    attachedTime += attachedTimeParasite;
                    patchGlidingTime += patchGlidingTimeParasite;
                    for (j = 0; j < index; ++j) {
                        dos.write("" + states[j] + " ");
                    }
                    dos.write("\n");
                }
                int j = 0;
                if (bDisplayMotParam) {
                    dos.write("All attached points as list\n");
                    for (i3 = 0; i3 < cnt[j]; ++i3) {
                        dos.write(" vel " + parameters_movingtypes[0][j][i3] + " angle_m " + parameters_movingtypes[1][j][i3] + " angle_a " + parameters_movingtypes[2][j][i3] + " spfactor " + parameters_movingtypes[3][j][i3] + " para_length " + parameters_movingtypes[4][j][i3] + " pixnumber " + parameters_movingtypes[5][j][i3] + " curvature " + parameters_movingtypes[6][j][i3] + " perimeter " + parameters_movingtypes[7][j][i3] + " time " + parameters_movingtypes[8][j][i3] + " moving_dir " + parameters_movingtypes[12][j][i3] + " track_number " + parameters_movingtypes[13][j][i3] + "\n");
                    }
                    dos.write("All waving points as list\n");
                    ++j;
                    for (i3 = 0; i3 < cnt[j]; ++i3) {
                        dos.write(" vel " + parameters_movingtypes[0][j][i3] + " angle_m " + parameters_movingtypes[1][j][i3] + " angle_a " + parameters_movingtypes[2][j][i3] + " spfactor " + parameters_movingtypes[3][j][i3] + " para_length " + parameters_movingtypes[4][j][i3] + " pixnumber " + parameters_movingtypes[5][j][i3] + " curvature " + parameters_movingtypes[6][j][i3] + " perimeter " + parameters_movingtypes[7][j][i3] + " time " + parameters_movingtypes[8][j][i3] + " moving_dir " + parameters_movingtypes[12][j][i3] + " track_number " + parameters_movingtypes[13][j][i3] + "\n");
                    }
                    dos.write("All clockwaizzemoving points as list\n");
                    ++j;
                    for (i3 = 0; i3 < cnt[j]; ++i3) {
                        dos.write(" vel " + parameters_movingtypes[0][j][i3] + " angle_m " + parameters_movingtypes[1][j][i3] + " angle_a " + parameters_movingtypes[2][j][i3] + " spfactor " + parameters_movingtypes[3][j][i3] + " para_length " + parameters_movingtypes[4][j][i3] + " pixnumber " + parameters_movingtypes[5][j][i3] + " curvature " + parameters_movingtypes[6][j][i3] + " perimeter " + parameters_movingtypes[7][j][i3] + " time " + parameters_movingtypes[8][j][i3] + " moving_dir " + parameters_movingtypes[12][j][i3] + " track_number " + parameters_movingtypes[13][j][i3] + "\n");
                    }
                    dos.write("All CClockwaizzemoving points as list\n");
                    ++j;
                    for (i3 = 0; i3 < cnt[j]; ++i3) {
                        dos.write(" vel " + parameters_movingtypes[0][j][i3] + " angle_m " + parameters_movingtypes[1][j][i3] + " angle_a " + parameters_movingtypes[2][j][i3] + " spfactor " + parameters_movingtypes[3][j][i3] + " para_length " + parameters_movingtypes[4][j][i3] + " pixnumber " + parameters_movingtypes[5][j][i3] + " curvature " + parameters_movingtypes[6][j][i3] + " perimeter " + parameters_movingtypes[7][j][i3] + " time " + parameters_movingtypes[8][j][i3] + " moving_dir " + parameters_movingtypes[12][j][i3] + " track_number " + parameters_movingtypes[13][j][i3] + "\n");
                    }
                    dos.write("All PatchGliding points as list\n");
                    ++j;
                    for (i3 = 0; i3 < cnt[j]; ++i3) {
                        dos.write(" vel " + parameters_movingtypes[0][j][i3] + " angle_m " + parameters_movingtypes[1][j][i3] + " angle_a " + parameters_movingtypes[2][j][i3] + " spfactor " + parameters_movingtypes[3][j][i3] + " para_length " + parameters_movingtypes[4][j][i3] + " pixnumber " + parameters_movingtypes[5][j][i3] + " curvature " + parameters_movingtypes[6][j][i3] + " perimeter " + parameters_movingtypes[7][j][i3] + " time " + parameters_movingtypes[8][j][i3] + " moving_dir " + parameters_movingtypes[12][j][i3] + " track_number " + parameters_movingtypes[13][j][i3] + "\n");
                    }
                }
                double[][] means_angles = new double[5][2];
                double[][] means_spf = new double[5][2];
                double[][] means_lengths = new double[5][2];
                double[][] means_vels = new double[5][2];
                double[][] means_pixelsize = new double[5][2];
                double[][] means_absangle = new double[5][2];
                double[][][] means_parameters = new double[paramnumber][5][2];
                for (j = 0; j < 5; ++j) {
                    means_absangle[j][0] = this.mean_a(angles_abs_movingtypes[j], cnt[j]);
                    means_absangle[j][1] = this.stddev_a(angles_abs_movingtypes[j], cnt[j], means_absangle[j][0]);
                    means_spf[j][0] = this.mean_a(spfactors_movingtypes[j], cnt[j]);
                    means_spf[j][1] = this.stddev_a(spfactors_movingtypes[j], cnt[j], means_spf[j][0]);
                    means_lengths[j][0] = this.mean_a(lengths_movingtypes[j], cnt[j]);
                    means_lengths[j][1] = this.stddev_a(lengths_movingtypes[j], cnt[j], means_lengths[j][0]);
                    means_vels[j][0] = this.mean_a(vels_movingtypes[j], cnt[j]);
                    means_vels[j][1] = this.stddev_a(vels_movingtypes[j], cnt[j], means_vels[j][0]);
                    means_pixelsize[j][0] = this.mean_a(pixelnums_movingtypes[j], cnt[j]);
                    means_pixelsize[j][1] = this.stddev_a(pixelnums_movingtypes[j], cnt[j], means_pixelsize[j][0]);
                    for (int k1 = 0; k1 < paramnumber; ++k1) {
                        means_parameters[k1][j][0] = this.mean_a(parameters_movingtypes[k1][j], cnt[j]);
                        means_parameters[k1][j][1] = this.stddev_a(parameters_movingtypes[k1][j], cnt[j], means_parameters[k1][j][0]);
                    }
                }
                dos.write("overall statistics for all parasites(sliding average of " + (2 * slidingAverageHalfSize + 1) + " frames)\n");
                dos.write("Total Total_time(frames) " + totalTime + " Attached " + attachedTime + " Waving " + waverTime + " CWmover " + cwTime + " CCWmover " + ccwTime + " PatchGliding " + patchGlidingTime + "\n");
                j = 0;
                dos.write("Attached(meanval+sttdev): velocity " + means_parameters[0][j][0] + " " + means_parameters[0][j][1] + " angle_moving " + means_parameters[1][j][0] + " " + means_parameters[1][j][1] + " angle_orientation " + means_parameters[2][j][0] + " " + means_parameters[2][j][1] + " spfactor " + means_parameters[3][j][0] + " " + means_parameters[3][j][1] + " length " + means_parameters[4][j][0] + " " + means_parameters[4][j][1] + " pixelsize " + means_parameters[5][j][0] + " " + means_parameters[5][j][1] + " curvature " + means_parameters[6][j][0] + " " + means_parameters[6][j][1] + " perimeter " + means_parameters[7][j][0] + " " + means_parameters[7][j][1] + " time " + means_parameters[8][j][0] + " " + means_parameters[8][j][1] + " abs_angle " + means_absangle[j][0] + " " + means_absangle[j][1] + "\n");
                dos.write("Waving(meanval+sttdev): velocity " + means_parameters[0][++j][0] + " " + means_parameters[0][j][1] + " angle_moving " + means_parameters[1][j][0] + " " + means_parameters[1][j][1] + " angle_orientation " + means_parameters[2][j][0] + " " + means_parameters[2][j][1] + " spfactor " + means_parameters[3][j][0] + " " + means_parameters[3][j][1] + " length " + means_parameters[4][j][0] + " " + means_parameters[4][j][1] + " pixelsize " + means_parameters[5][j][0] + " " + means_parameters[5][j][1] + " curvature " + means_parameters[6][j][0] + " " + means_parameters[6][j][1] + " perimeter " + means_parameters[7][j][0] + " " + means_parameters[7][j][1] + " time " + means_parameters[8][j][0] + " " + means_parameters[8][j][1] + " abs_angle " + means_absangle[j][0] + " " + means_absangle[j][1] + "\n");
                dos.write("ClockwiseM(meanval+sttdev): velocity " + means_parameters[0][++j][0] + " " + means_parameters[0][j][1] + " angle_moving " + means_parameters[1][j][0] + " " + means_parameters[1][j][1] + " angle_orientation " + means_parameters[2][j][0] + " " + means_parameters[2][j][1] + " spfactor " + means_parameters[3][j][0] + " " + means_parameters[3][j][1] + " length " + means_parameters[4][j][0] + " " + means_parameters[4][j][1] + " pixelsize " + means_parameters[5][j][0] + " " + means_parameters[5][j][1] + " curvature " + means_parameters[6][j][0] + " " + means_parameters[6][j][1] + " perimeter " + means_parameters[7][j][0] + " " + means_parameters[7][j][1] + " time " + means_parameters[8][j][0] + " " + means_parameters[8][j][1] + " abs_angle " + means_absangle[j][0] + " " + means_absangle[j][1] + "\n");
                dos.write("CounterClockwiseM(meanval+sttdev): velocity " + means_parameters[0][++j][0] + " " + means_parameters[0][j][1] + " angle_moving " + means_parameters[1][j][0] + " " + means_parameters[1][j][1] + " angle_orientation " + means_parameters[2][j][0] + " " + means_parameters[2][j][1] + " spfactor " + means_parameters[3][j][0] + " " + means_parameters[3][j][1] + " length " + means_parameters[4][j][0] + " " + means_parameters[4][j][1] + " pixelsize " + means_parameters[5][j][0] + " " + means_parameters[5][j][1] + " curvature " + means_parameters[6][j][0] + " " + means_parameters[6][j][1] + " perimeter " + means_parameters[7][j][0] + " " + means_parameters[7][j][1] + " time " + means_parameters[8][j][0] + " " + means_parameters[8][j][1] + " abs_angle " + means_absangle[j][0] + " " + means_absangle[j][1] + "\n");
                dos.write("PatchGliders(meanval+sttdev): velocity " + means_parameters[0][++j][0] + " " + means_parameters[0][j][1] + " angle_moving " + means_parameters[1][j][0] + " " + means_parameters[1][j][1] + " angle_orientation " + means_parameters[2][j][0] + " " + means_parameters[2][j][1] + " spfactor " + means_parameters[3][j][0] + " " + means_parameters[3][j][1] + " length " + means_parameters[4][j][0] + " " + means_parameters[4][j][1] + " pixelsize " + means_parameters[5][j][0] + " " + means_parameters[5][j][1] + " curvature " + means_parameters[6][j][0] + " " + means_parameters[6][j][1] + " perimeter " + means_parameters[7][j][0] + " " + means_parameters[7][j][1] + " time " + means_parameters[8][j][0] + " " + means_parameters[8][j][1] + " abs_angle " + means_absangle[j][0] + " " + means_absangle[j][1] + "\n");
                ++j;
                dos.write("Table_of_transmissions_between_states \n");
                for (j = 0; j < 5; ++j) {
                    dos.write(stateTransmissions[j][0] + " " + stateTransmissions[j][1] + " " + stateTransmissions[j][2] + " " + stateTransmissions[j][3] + " " + stateTransmissions[j][4] + "\n");
                }
                dos.write("Table_of_Conditional_transmissions_between_states(counts_changes_if_previous_state_lasted_over_5sec) \n");
                for (j = 0; j < 5; ++j) {
                    dos.write(stateTransmissionsCondition[j][0] + " " + stateTransmissionsCondition[j][1] + " " + stateTransmissionsCondition[j][2] + " " + stateTransmissionsCondition[j][3] + " " + stateTransmissionsCondition[j][4] + "\n");
                }
                double[] aveStateLen = new double[5];
                for (j = 0; j < 5; ++j) {
                    for (i3 = 0; i3 < statescnt[j]; ++i3) {
                        int n = j;
                        aveStateLen[n] = aveStateLen[n] + statelengths[j][i3];
                    }
                    int n = j;
                    aveStateLen[n] = aveStateLen[n] / (double)statescnt[j];
                }
                j = 0;
                dos.write("list_of_durations_for_all_states:Attached N= " + statescnt[j] + " Ave= " + aveStateLen[j] + " Median= " + this.median_a(statelengths[j], statescnt[j]) + " StdDev= " + this.stddev_a(statelengths[j], statescnt[j], aveStateLen[j]) + " ConditionalAverage(if_dur>5frames)= " + this.mean_cond(statelengths[j], statescnt[j], 5.0) + "\n");
                dos.write("list_of_durations_for_all_states:Waving N= " + statescnt[++j] + " Ave= " + aveStateLen[j] + " Median= " + this.median_a(statelengths[j], statescnt[j]) + " StdDev= " + this.stddev_a(statelengths[j], statescnt[j], aveStateLen[j]) + " ConditionalAverage(if_dur>5frames)= " + this.mean_cond(statelengths[j], statescnt[j], 5.0) + "\n");
                dos.write("list_of_durations_for_all_states:CwizzeMover N= " + statescnt[++j] + " Ave= " + aveStateLen[j] + " Median= " + this.median_a(statelengths[j], statescnt[j]) + " StdDev= " + this.stddev_a(statelengths[j], statescnt[j], aveStateLen[j]) + " ConditionalAverage(if_dur>5frames)= " + this.mean_cond(statelengths[j], statescnt[j], 5.0) + "\n");
                dos.write("list_of_durations_for_all_states:CCwizzeMover N= " + statescnt[++j] + " Ave= " + aveStateLen[j] + " Median= " + this.median_a(statelengths[j], statescnt[j]) + " StdDev= " + this.stddev_a(statelengths[j], statescnt[j], aveStateLen[j]) + " ConditionalAverage(if_dur>5frames)= " + this.mean_cond(statelengths[j], statescnt[j], 5.0) + "\n");
                dos.write("list_of_durations_for_all_states:PatchGlider N= " + statescnt[++j] + " Ave= " + aveStateLen[j] + " Median= " + this.median_a(statelengths[j], statescnt[j]) + " StdDev= " + this.stddev_a(statelengths[j], statescnt[j], aveStateLen[j]) + " ConditionalAverage(if_dur>5frames)= " + this.mean_cond(statelengths[j], statescnt[j], 5.0) + "\n");
                dos.close();
            }
            catch (IOException e) {
                if (filename == null) break block172;
                IJ.error((String)("An error occurred writing the file. \n \n " + e));
            }
        }
        if (bShowPathLengths && !writefile) {
            double[] lengths = new double[trackCount];
            double[] distances = new double[trackCount];
            int[] frames = new int[trackCount];
            int trackNr = 0;
            int displayTrackNr = 0;
            ListIterator iT = theTracks.listIterator();
            while (iT.hasNext()) {
                ++trackNr;
                ArrayList bTrack = (ArrayList)iT.next();
                if (bTrack.size() < minTrackLength) continue;
                ListIterator jT = bTrack.listIterator();
                particle oldParticle = (particle)jT.next();
                particle firstParticle = new particle();
                firstParticle.copy(oldParticle);
                frames[++displayTrackNr - 1] = bTrack.size();
                while (jT.hasNext()) {
                    particle newParticle = (particle)jT.next();
                    int n = displayTrackNr - 1;
                    lengths[n] = lengths[n] + Math.sqrt(this.sqr(oldParticle.x - newParticle.x) + this.sqr(oldParticle.y - newParticle.y));
                    oldParticle = newParticle;
                }
                distances[displayTrackNr - 1] = Math.sqrt(this.sqr(oldParticle.x - firstParticle.x) + this.sqr(oldParticle.y - firstParticle.y));
            }
            IJ.write((String)"");
            IJ.write((String)"Track \tLength\tDistance traveled\tNr of Frames");
            for (int i = 0; i < displayTrackNr; ++i) {
                String str = "" + (i + 1) + ":\t" + (float)lengths[i] + "\t" + (float)distances[i] + "\t" + frames[i];
                IJ.write((String)str);
            }
        }
        if (bShowPaths) {
            if (imp.getCalibration().scaled()) {
                IJ.showMessage((String)"MultiTracker", (String)"Cannot display paths if image is spatially calibrated");
                return;
            }
            ByteProcessor ip = new ByteProcessor(imp.getWidth(), imp.getHeight());
            ip.setColor(Color.white);
            ip.fill();
            trackCount = 0;
            ListIterator iT = theTracks.listIterator();
            while (iT.hasNext()) {
                ++trackCount;
                ArrayList bTrack = (ArrayList)iT.next();
                if (bTrack.size() < minTrackLength) continue;
                ListIterator jT = bTrack.listIterator();
                particle oldParticle = (particle)jT.next();
                while (jT.hasNext()) {
                    particle newParticle = (particle)jT.next();
                    int color = Math.min(trackCount + 1, 254);
                    ip.setValue((double)color);
                    ip.moveTo((int)oldParticle.x, (int)oldParticle.y);
                    ip.lineTo((int)newParticle.x, (int)newParticle.y);
                    oldParticle = newParticle;
                }
            }
            new ImagePlus("Paths", (ImageProcessor)ip).show();
        }
    }

    double sqr(double n) {
        return n * n;
    }

    int doOffset(int center, int maxSize, int displacement) {
        if (center - displacement < 2 * displacement) {
            return center + 4 * displacement;
        }
        return center - displacement;
    }

    double s2d(String s) {
        Double d;
        try {
            d = new Double(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public double segmentation(int[] pixels, int W, int H, int x, int y, int bright, int mnsize, int mxsize, int i1, int i2) {
        int i = 0;
        int j = 0;
        boolean flag = true;
        int closeness = 1;
        parObject obj = new parObject();
        obj.addp(x, y, (double)pixels[x + y * W]);
        while (flag && obj.n < obj.maxpixnum - 2) {
            flag = false;
            for (int b = 0; b < obj.n; ++b) {
                i = (int)obj.x[b] - closeness;
                while ((double)i < obj.x[b] + 1.0 + (double)closeness) {
                    j = (int)obj.y[b] - closeness;
                    while ((double)j < obj.y[b] + 1.0 + (double)closeness) {
                        if (i + j * W >= 0 && i + j * W < W * H && pixels[i + j * W] == bright && obj.isin(i, j) == 0) {
                            obj.addp(i, j, (double)pixels[i + j * W]);
                            flag = true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (obj.n != obj.maxpixnum - 3) continue;
            return -600.0;
        }
        parObject rtpar = new parObject();
        rtpar = obj.rotate(45.0 + obj.princ_angle());
        this.spfactors[i1][i2] = Math.min(Math.max(Math.abs(rtpar.corrxy()), Math.abs(obj.corrxy())), 1.0);
        this.plengths[i1][i2] = obj.mlen();
        this.pixnumbers[i1][i2] = obj.n;
        this.perimeter[i1][i2] = obj.perimeter();
        this.curvatures[i1][i2] = bCalculateCurvature ? obj.curvature() : 0.0;
        if (obj.n < mxsize && obj.n > mnsize) {
            return obj.princ_angle();
        }
        return -550.0;
    }

    double mean_a(double[] a, int len) {
        double sum = 0.0;
        for (int i = 0; i < len; ++i) {
            sum += a[i];
        }
        return sum / (double)len;
    }

    double mean_cond(double[] a, int len, double limit) {
        double sum = 0.0;
        double cnt = 0.0;
        for (int i = 0; i < len; ++i) {
            if (!(a[i] > limit)) continue;
            sum += a[i];
            cnt += 1.0;
        }
        return sum / cnt;
    }

    double stddev_a(double[] a, int len, double mean) {
        double stddev = 0.0;
        for (int i = 0; i < len; ++i) {
            stddev += Math.abs(a[i] - mean);
        }
        return stddev / (double)(len - 1);
    }

    double median_a(double[] a, int len) {
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!(a[i] < a[j])) continue;
                double temp = a[i];
                a[i] = a[j];
                a[j] = temp;
            }
        }
        return a[(int)((double)len / 2.0)];
    }

    public class particle {
        float x;
        float y;
        int z;
        int trackNr;
        boolean inTrack = false;
        boolean flag = false;

        public void copy(particle source) {
            this.x = source.x;
            this.y = source.y;
            this.z = source.z;
            this.inTrack = source.inTrack;
            this.flag = source.flag;
        }

        public float distance(particle p) {
            return (float)Math.sqrt(ToAST25_.this.sqr(this.x - p.x) + ToAST25_.this.sqr(this.y - p.y));
        }
    }
}

