/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.colourDeconvolution;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Frame;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import sc.fiji.colourDeconvolution.StainMatrix;

public class Colour_Deconvolution
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.error((String)"No image!");
            return;
        }
        if (imp.getBitDepth() != 24) {
            IJ.error((String)"RGB image needed.");
            return;
        }
        LinkedHashMap<String, StainMatrix> matrixHashList = null;
        try {
            matrixHashList = this.getStainList();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (matrixHashList == null) {
            return;
        }
        ArrayList<String> matrixSet = new ArrayList<String>(matrixHashList.keySet());
        matrixSet.add("From ROI");
        matrixSet.add("User values");
        String[] stainArray = matrixSet.toArray(new String[matrixSet.size()]);
        GenericDialog gd = new GenericDialog("Colour Deconvolution 1.7", (Frame)IJ.getInstance());
        gd.addMessage("Warning: This plugin is not suitable to quantify\n the intensity of immunostained slides because\n immunostains are not stoichiometric.");
        gd.addChoice("Vectors", stainArray, stainArray[0]);
        gd.addCheckbox("Show matrices", false);
        gd.addCheckbox("Hide legend", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String myStain = gd.getNextChoice();
        boolean doIshow = gd.getNextBoolean();
        boolean hideLegend = gd.getNextBoolean();
        StainMatrix mt = null;
        mt = matrixHashList.get(myStain);
        if (myStain.equals("User values")) {
            GenericDialog gd2 = new GenericDialog("User values", (Frame)IJ.getInstance());
            gd2.addMessage("Colour[1]");
            gd2.addNumericField("[R1]", 0.0, 5);
            gd2.addNumericField("[G1]", 0.0, 5);
            gd2.addNumericField("[B1]", 0.0, 5);
            gd2.addMessage("Colour[2]");
            gd2.addNumericField("[R2]", 0.0, 5);
            gd2.addNumericField("[G2]", 0.0, 5);
            gd2.addNumericField("[B2]", 0.0, 5);
            gd2.addMessage("Colour[3]");
            gd2.addNumericField("[R3]", 0.0, 5);
            gd2.addNumericField("[G3]", 0.0, 5);
            gd2.addNumericField("[B3]", 0.0, 5);
            gd2.showDialog();
            if (gd2.wasCanceled()) {
                return;
            }
            mt = new StainMatrix();
            double x0 = gd2.getNextNumber();
            double y0 = gd2.getNextNumber();
            double z0 = gd2.getNextNumber();
            double x1 = gd2.getNextNumber();
            double y1 = gd2.getNextNumber();
            double z1 = gd2.getNextNumber();
            double x2 = gd2.getNextNumber();
            double y2 = gd2.getNextNumber();
            double z2 = gd2.getNextNumber();
            mt.init("User values", x0, y0, z0, x1, y1, z1, x2, y2, z2);
        }
        if (myStain.equals("From ROI")) {
            mt = new StainMatrix();
            IJ.runMacro((String)"setOption('DisablePopupMenu', true)");
            double[] matrixValue = new double[9];
            double[] rgbOD = new double[3];
            for (int i = 0; i < 3; ++i) {
                this.getmeanRGBODfromROI(i, rgbOD, imp);
                matrixValue[3 * i + 0] = rgbOD[0];
                matrixValue[3 * i + 1] = rgbOD[1];
                matrixValue[3 * i + 2] = rgbOD[2];
            }
            mt.init("From ROI", matrixValue[0], matrixValue[1], matrixValue[2], matrixValue[3], matrixValue[4], matrixValue[5], matrixValue[6], matrixValue[7], matrixValue[8]);
            IJ.runMacro((String)"setOption('DisablePopupMenu', false)");
        }
        mt.computeAndShow(doIshow, hideLegend, imp);
    }

    void getmeanRGBODfromROI(int i, double[] rgbOD, ImagePlus imp) {
        int[] xyzf = new int[4];
        int h = 0;
        int w = 0;
        int px = 0;
        int py = 0;
        double log255 = Math.log(255.0);
        ImageProcessor ip = imp.getProcessor();
        int mw = ip.getWidth() - 1;
        int mh = ip.getHeight() - 1;
        IJ.showMessage((String)("Select ROI for Colour_" + (i + 1) + ".\n \n(Right-click to end)"));
        this.getCursorLoc(xyzf, imp);
        while ((xyzf[3] & 4) != 0) {
            this.getCursorLoc(xyzf, imp);
            IJ.wait((int)20);
        }
        while ((xyzf[3] & 0x10) == 0 && (xyzf[3] & 4) == 0) {
            this.getCursorLoc(xyzf, imp);
            IJ.wait((int)20);
        }
        rgbOD[0] = 0.0;
        rgbOD[1] = 0.0;
        rgbOD[2] = 0.0;
        if ((xyzf[3] & 4) == 0) {
            int x1 = xyzf[0];
            int y1 = xyzf[1];
            int x2 = x1;
            int y2 = y1;
            while ((xyzf[3] & 4) == 0) {
                this.getCursorLoc(xyzf, imp);
                if (xyzf[0] != x2 || xyzf[1] != y2) {
                    if (xyzf[0] < 0) {
                        xyzf[0] = 0;
                    }
                    if (xyzf[1] < 0) {
                        xyzf[1] = 0;
                    }
                    if (xyzf[0] > mw) {
                        xyzf[0] = mw;
                    }
                    if (xyzf[1] > mh) {
                        xyzf[1] = mh;
                    }
                    x2 = xyzf[0];
                    y2 = xyzf[1];
                    w = x2 - x1 + 1;
                    h = y2 - y1 + 1;
                    if (x2 < x1) {
                        px = x2;
                        w = x1 - x2 + 1;
                    } else {
                        px = x1;
                    }
                    if (y2 < y1) {
                        py = y2;
                        h = y1 - y2 + 1;
                    } else {
                        py = y1;
                    }
                    IJ.makeRectangle((int)px, (int)py, (int)w, (int)h);
                }
                IJ.wait((int)20);
            }
            while ((xyzf[3] & 0x10) != 0) {
                this.getCursorLoc(xyzf, imp);
                IJ.wait((int)20);
            }
            for (int x = px; x < px + w; ++x) {
                for (int y = py; y < py + h; ++y) {
                    int p = ip.getPixel(x, y);
                    rgbOD[0] = rgbOD[0] + -(255.0 * Math.log(((double)((p & 0xFF0000) >> 16) + 1.0) / 255.0) / log255);
                    rgbOD[1] = rgbOD[1] + -(255.0 * Math.log(((double)((p & 0xFF00) >> 8) + 1.0) / 255.0) / log255);
                    rgbOD[2] = rgbOD[2] + -(255.0 * Math.log(((double)(p & 0xFF) + 1.0) / 255.0) / log255);
                }
            }
            rgbOD[0] = rgbOD[0] / (double)(w * h);
            rgbOD[1] = rgbOD[1] / (double)(w * h);
            rgbOD[2] = rgbOD[2] / (double)(w * h);
        }
        IJ.run((String)"Select None");
    }

    void getCursorLoc(int[] xyzf, ImagePlus imp) {
        ImageWindow win = imp.getWindow();
        ImageCanvas ic = win.getCanvas();
        Point p = ic.getCursorLoc();
        xyzf[0] = p.x;
        xyzf[1] = p.y;
        xyzf[2] = imp.getCurrentSlice() - 1;
        xyzf[3] = ic.getModifiers();
    }

    public static void main(String[] args) throws Exception {
        Class<Colour_Deconvolution> clazz = Colour_Deconvolution.class;
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        File file = new File(url.toURI());
        System.setProperty("plugins.dir", file.getAbsolutePath());
        new ImageJ();
        ImagePlus image = IJ.openImage((String)"http://imagej.net/images/clown.jpg");
        image.show();
        IJ.runPlugIn((String)clazz.getName(), (String)"");
    }

    private LinkedHashMap<String, StainMatrix> getStainList() throws IOException {
        InputStream stream;
        File file;
        ArrayList<String> lines;
        LinkedHashMap<String, StainMatrix> matrixMap;
        block10: {
            matrixMap = new LinkedHashMap<String, StainMatrix>();
            lines = new ArrayList<String>();
            String libDir = IJ.getDirectory((String)"plugins");
            file = new File(libDir, "colourdeconvolution.txt");
            if (!file.exists()) {
                try {
                    int bytesRead;
                    stream = this.getClass().getResourceAsStream("colourdeconvolution.txt");
                    FileOutputStream outStream = new FileOutputStream(file);
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = stream.read(buffer)) != -1) {
                        ((OutputStream)outStream).write(buffer, 0, bytesRead);
                    }
                    stream.close();
                    ((OutputStream)outStream).close();
                }
                catch (IOException ioe) {
                    IJ.error((String)"Plugin Directory not writable", (String)("The Plugin directory is not writable, so the file containing the vector list would not be copied into the plugin directory." + System.getProperty("line.separator") + ioe));
                    if (!file.exists()) break block10;
                    file.delete();
                }
            }
        }
        if (!file.exists()) {
            stream = this.getClass().getResourceAsStream("colourdeconvolution.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
            reader.close();
            for (int i = 1; i < lines.size(); ++i) {
                StainMatrix matrix = new StainMatrix();
                matrix.init((String)lines.get(i));
                matrixMap.put(matrix.myStain, matrix);
            }
        } else {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
            reader.close();
            for (int i = 1; i < lines.size(); ++i) {
                StainMatrix matrix = new StainMatrix();
                matrix.init((String)lines.get(i));
                matrixMap.put(matrix.myStain, matrix);
            }
        }
        return matrixMap;
    }
}

