/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj;

import ij.gui.GenericDialog;

public class Param {
    public int mode = 2;
    public int img_subsamp_fact = 0;
    public int min_scale_deformation = 0;
    public int max_scale_deformation = 2;
    public double divWeight = 0.0;
    public double curlWeight = 0.0;
    public double landmarkWeight = 0.0;
    public double imageWeight = 1.0;
    public double consistencyWeight = 10.0;
    public double stopThreshold = 0.01;
    protected final String[] sRegistrationModes = new String[]{"Fast", "Accurate", "Mono"};
    protected final String[] sMinScaleDeformationChoices = new String[]{"Very Coarse", "Coarse", "Fine", "Very Fine"};
    protected String[] sMaxScaleDeformationChoices = new String[]{"Very Coarse", "Coarse", "Fine", "Very Fine", "Super Fine"};
    private double shearCorrection = 0.0;
    private double scaleCorrection = 0.0;
    private double anisotropyCorrection = 0.0;

    public Param() {
    }

    public Param(int mode, int img_subsamp_fact, int min_scale_deformation, int max_scale_deformation, double divWeight, double curlWeight, double landmarkWeight, double imageWeight, double consistencyWeight, double stopThreshold) {
        this.mode = mode;
        this.img_subsamp_fact = img_subsamp_fact;
        this.min_scale_deformation = min_scale_deformation;
        this.max_scale_deformation = max_scale_deformation;
        this.divWeight = divWeight;
        this.curlWeight = curlWeight;
        this.landmarkWeight = landmarkWeight;
        this.imageWeight = imageWeight;
        this.consistencyWeight = consistencyWeight;
        this.stopThreshold = stopThreshold;
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("Elastic Registration");
        gd.addChoice("Registration Mode", this.sRegistrationModes, this.sRegistrationModes[2]);
        gd.addSlider("Image_Subsample_Factor", 0.0, 7.0, 0.0);
        gd.addMessage("------ Advanced Options ------");
        gd.addChoice("Initial_Deformation :", this.sMinScaleDeformationChoices, this.sMinScaleDeformationChoices[this.min_scale_deformation]);
        gd.addChoice("Final_Deformation :", this.sMaxScaleDeformationChoices, this.sMaxScaleDeformationChoices[this.max_scale_deformation]);
        gd.addNumericField("Divergence_Weight :", this.divWeight, 1);
        gd.addNumericField("Curl_Weight :", this.curlWeight, 1);
        gd.addNumericField("Landmark_Weight :", this.landmarkWeight, 1);
        gd.addNumericField("Image_Weight :", this.imageWeight, 1);
        gd.addNumericField("Consistency_Weight :", this.consistencyWeight, 1);
        gd.addNumericField("Stop_Threshold :", this.stopThreshold, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.mode = gd.getNextChoiceIndex();
        this.img_subsamp_fact = (int)gd.getNextNumber();
        this.min_scale_deformation = gd.getNextChoiceIndex();
        this.max_scale_deformation = gd.getNextChoiceIndex();
        this.divWeight = gd.getNextNumber();
        this.curlWeight = gd.getNextNumber();
        this.landmarkWeight = gd.getNextNumber();
        this.imageWeight = gd.getNextNumber();
        this.consistencyWeight = gd.getNextNumber();
        this.stopThreshold = gd.getNextNumber();
        return true;
    }

    public String toString() {
        return new String("Registration mode: " + this.sRegistrationModes[this.mode] + "\nImage Sub-sampling factor:  " + this.img_subsamp_fact + " => " + Math.pow(2.0, this.img_subsamp_fact) + "\nMinimum scale factor = " + this.sMinScaleDeformationChoices[this.min_scale_deformation] + "\nMaximum scale factor = " + this.sMaxScaleDeformationChoices[this.max_scale_deformation] + "\nDivergence weight = " + this.divWeight + "\nCurl weight = " + this.curlWeight + "\nLandmark weight = " + this.landmarkWeight + "\nImage weight = " + this.imageWeight + "\nConsistency weight = " + this.consistencyWeight + "\nStopping threshold = " + this.stopThreshold + "\nShear correction = " + this.shearCorrection + "\nScale correction = " + this.scaleCorrection + "\nAnisotropy correction = " + this.anisotropyCorrection + "\n");
    }

    public void setShearCorrection(double shearCorrection) {
        this.shearCorrection = shearCorrection;
    }

    public double getShearCorrection() {
        return this.shearCorrection;
    }

    public void setScaleCorrection(double scaleCorrection) {
        this.scaleCorrection = scaleCorrection;
    }

    public double getScaleCorrection() {
        return this.scaleCorrection;
    }

    public void setAnisotropyCorrection(double anisotropyCorrection) {
        this.anisotropyCorrection = anisotropyCorrection;
    }

    public double getAnisotropyCorrection() {
        return this.anisotropyCorrection;
    }
}

