/*
 * Decompiled with CFR 0.152.
 */
package math;

import ij.IJ;

public class BSpline {
    public static double[] resize1D(double[] input, int n, int n1, int n2, double scale, boolean coefOrSamples) {
        int nxIn = input.length;
        double bb = Math.round((double)(nxIn - 1) * scale * 1.0 / scale);
        while ((double)(nxIn - 1) - bb != 0.0) {
            bb = Math.round((double)(++nxIn - 1) * scale * 1.0 / scale);
        }
        int nxOut = (int)Math.round((double)(nxIn - 1) * scale) + 1;
        double[] out = new double[nxOut];
        double[] coef = null;
        if (!coefOrSamples) {
            if (n < 2) {
                coef = input;
            } else {
                double[] pole = BSpline.tableOfPoles(n);
                double tolerance = 1.0E-11;
                coef = BSpline.convertToInterpCoef(input, pole, tolerance);
            }
        }
        double[] integ = new double[input.length];
        double med = 0.0;
        if (n1 == -1) {
            integ = input;
            med = 0.0;
        }
        if (n1 == 0) {
            med = BSpline.integSA(input, integ);
        }
        if (n1 == 1) {
            med = BSpline.integSA(input, integ);
            integ = BSpline.integAS(integ);
        }
        if (n1 == 2) {
            med = BSpline.integSA(input, integ);
            integ = BSpline.integAS(integ);
            BSpline.integSA(integ, integ);
        }
        if (n1 == 3) {
            med = BSpline.integSA(input, integ);
            integ = BSpline.integAS(integ);
            BSpline.integSA(integ, integ);
            integ = BSpline.integAS(integ);
        }
        double[] resize = BSpline.resampling(integ, nxIn, nxOut, scale, n1, n + n1 + 1);
        double[] fd = null;
        if (n1 == -1) {
            fd = resize;
        } else if (n1 == 0) {
            fd = BSpline.finDiffAS(resize);
        } else if (n1 == 1) {
            fd = BSpline.finDiffSA(resize);
            fd = BSpline.finDiffAS(fd);
        } else if (n1 == 2) {
            fd = BSpline.finDiffAS(resize);
            fd = BSpline.finDiffSA(fd);
            fd = BSpline.finDiffAS(fd);
        } else if (n1 == 3) {
            fd = BSpline.finDiffSA(resize);
            fd = BSpline.finDiffAS(fd);
            fd = BSpline.finDiffSA(fd);
            fd = BSpline.finDiffAS(fd);
        }
        int n11 = n1 + 1;
        int val1 = (double)n11 * 0.5 == (double)((int)Math.floor((double)n11 * 0.5)) ? (int)((double)n11 * 0.5) : (int)Math.floor((double)n11 * 0.5) + 1;
        double[] fdShort = new double[nxOut];
        for (int i = 0; i < nxOut; ++i) {
            fdShort[i] = fd[val1 + i] + med;
        }
        double[] coefFull = null;
        if (n1 + n2 + 1 < 2) {
            coefFull = fdShort;
        } else {
            double[] pole = BSpline.tableOfPoles(n1 + n2 + 1);
            double tolerance = 1.0E-11;
            coefFull = BSpline.convertToInterpCoef(fdShort, pole, tolerance);
        }
        if (coefOrSamples) {
            if (n2 < 2) {
                out = coefFull;
            } else {
                double[] samples = BSpline.tableOfSamples(n2);
                out = BSpline.convertToSamples(coefFull, samples);
            }
        }
        return out;
    }

    public static double[] convertToSamples(double[] coef, double[] samples) {
        int NbCoef = coef.length;
        int kn = 2 * NbCoef - 2;
        double[] out = new double[NbCoef];
        for (int k = 0; k < NbCoef; ++k) {
            double yaux = coef[k] * samples[0];
            for (int i = 1; i < samples.length - 1; ++i) {
                int k1 = k - i;
                int k2 = k + i;
                if (k1 < 0 && (k1 = -k1) >= NbCoef) {
                    k1 = kn - k1;
                }
                if (k2 >= NbCoef && (k2 = 2 * (NbCoef - 1) - k2) >= NbCoef) {
                    k2 = kn - k2;
                }
                yaux = yaux + coef[k1] + coef[k2] * samples[i];
            }
            out[k] = yaux;
        }
        return out;
    }

    private static double[] finDiffSA(double[] c) {
        int i;
        int N = c.length;
        double[] y = new double[N];
        for (i = 0; i < N - 1; ++i) {
            y[i] = c[i] - c[i + 1];
        }
        y[N - 1] = c[N - 1] - c[N - 2];
        i = 0;
        while (i < N) {
            int n = i++;
            y[n] = y[n] * -1.0;
        }
        return y;
    }

    public static double[] finDiffAS(double[] c) {
        int N = c.length;
        double[] y = new double[N];
        for (int i = 0; i < N - 1; ++i) {
            y[i + 1] = c[i + 1] - c[i];
        }
        y[0] = 2.0 * c[0];
        return y;
    }

    public static double[] resampling(double[] input, int nInput, int nOut, double scale, int n1, int nt) {
        boolean even = (double)(n1 + 1) * 0.5 == Math.floor((double)(n1 + 1) * 0.5);
        int m = BSpline.factorial(nt);
        double[] temp = new double[nt + 1];
        int val1 = (int)(even ? (double)(n1 + 1) * 0.5 : (double)((int)Math.floor((double)(n1 + 1) * 0.5) + 1));
        double newx0 = even ? (double)(nt + 1) * 0.5 - (double)val1 / scale : 0.5 * (1.0 / scale - 1.0) + (double)(nt + 1) * 0.5 - (double)val1 / scale;
        double aa = Math.pow(scale, n1 + 1);
        double val2 = Math.floor((double)(n1 + 1) * 0.5);
        double[] out = new double[nOut + n1 + 1];
        int k = -val1;
        while ((double)k < (double)nOut + val2) {
            int i;
            int s;
            int val = (int)Math.ceil((double)(-(nt + 1)) + newx0);
            for (s = 0; s <= nt; ++s) {
                temp[s] = Math.pow(-newx0 + (double)(nt + 1) + (double)val + (double)s, nt) / (double)m;
            }
            for (s = 0; s <= nt; ++s) {
                for (int l = nt + 1; l > 0; --l) {
                    int n = l;
                    temp[n] = temp[n] - temp[l - 1];
                }
            }
            if (even) {
                for (i = 0; i <= nt; ++i) {
                    if (i + val < 0) {
                        int n = k + val1;
                        out[n] = out[n] + input[-i - val] * temp[i];
                        continue;
                    }
                    if (i + val > nInput - 1) {
                        int n = k + val1;
                        out[n] = out[n] + input[2 * (nInput - 1) - i - val] * temp[i];
                        continue;
                    }
                    int n = k + val1;
                    out[n] = out[n] + input[i + val] * temp[i];
                }
            } else {
                for (i = 0; i <= nt; ++i) {
                    if (i + val < 0) {
                        int n = k + val1;
                        out[n] = out[n] - input[-i - val] * temp[i];
                        continue;
                    }
                    if (i + val > nInput - 1) {
                        int n = k + val1;
                        out[n] = out[n] - input[2 * (nInput - 1) - i - val] * temp[i];
                        continue;
                    }
                    int n = k + val1;
                    out[n] = out[n] + input[i + val] * temp[i];
                }
            }
            newx0 += 1.0 / scale;
            ++k;
        }
        int i = 0;
        while (i < out.length) {
            int n = i++;
            out[n] = out[n] * aa;
        }
        return out;
    }

    public static int factorial(int n) {
        int fact = 0;
        switch (n) {
            case 0: {
                fact = 1;
                break;
            }
            case 1: {
                fact = 1;
                break;
            }
            case 2: {
                fact = 2;
                break;
            }
            case 3: {
                fact = 6;
                break;
            }
            case 4: {
                fact = 24;
                break;
            }
            case 5: {
                fact = 120;
                break;
            }
            case 6: {
                fact = 720;
                break;
            }
            case 7: {
                fact = 5040;
                break;
            }
            default: {
                fact = 1;
                for (int i = 0; i < n; ++i) {
                    fact *= i;
                }
            }
        }
        return fact;
    }

    public static double[] integAS(double[] c) {
        int i;
        int N = c.length;
        double[] y = new double[N];
        y[0] = c[0];
        y[1] = 0.0;
        for (i = 2; i < N; ++i) {
            y[i] = y[i - 1] - c[i - 1];
        }
        i = 0;
        while (i < y.length) {
            int n = i++;
            y[n] = y[n] * -1.0;
        }
        return y;
    }

    public static double integSA(double[] c, double[] z) {
        double m = BSpline.mean(c);
        double[] coeffs = (double[])c.clone();
        int i = 0;
        while (i < coeffs.length) {
            int n = i++;
            coeffs[n] = coeffs[n] - m;
        }
        z[0] = coeffs[0] * 0.5;
        for (i = 1; i < coeffs.length; ++i) {
            z[i] = coeffs[i] + z[i - 1];
        }
        return m;
    }

    public static double mean(double[] A) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            sum += A[i];
        }
        double sumValue = 2.0 * sum - A[0] - A[A.length - 1];
        return sumValue / (double)(2 * A.length - 2);
    }

    public static double[] convertToInterpCoef(double[] input, double[] poles, double tolerance) {
        int k;
        double lambda = 1.0;
        int dataLength = input.length;
        double[] coef = new double[dataLength];
        if (dataLength == 1) {
            return coef;
        }
        for (k = 0; k < poles.length; ++k) {
            lambda = lambda * (1.0 - poles[k]) * (1.0 - 1.0 / poles[k]);
        }
        for (int n = 0; n < dataLength; ++n) {
            coef[n] = input[n] * lambda;
        }
        for (k = 0; k < poles.length; ++k) {
            int n;
            coef[0] = BSpline.initialCausalCoefficient(coef, poles[k], tolerance);
            for (n = 1; n < dataLength; ++n) {
                coef[n] = coef[n] + poles[k] * coef[n - 1];
            }
            coef[dataLength - 1] = BSpline.initialAntiCausalCoefficient(coef, poles[k]);
            for (n = dataLength - 2; n > 0; --n) {
                coef[n] = poles[k] * coef[n + 1] - coef[n];
            }
        }
        return coef;
    }

    public static double initialAntiCausalCoefficient(double[] c, double z) {
        return z / (z * z - 1.0) * (z * c[c.length - 2] + c[c.length - 1]);
    }

    public static double initialCausalCoefficient(double[] c, double z, double tolerance) {
        int dataLength;
        double sum = 0.0;
        int horizon = dataLength = c.length;
        if (tolerance > 0.0) {
            horizon = (int)(Math.ceil(Math.log(tolerance)) / Math.log(Math.abs(z)));
        }
        if (horizon < dataLength) {
            double zn = z;
            sum = c[0];
            for (int n = 1; n < horizon; ++n) {
                sum += zn * c[n];
                zn *= z;
            }
        } else {
            double zn = z;
            double iz = 1.0 / z;
            double z2n = Math.pow(z, dataLength - 1);
            sum = c[0] + z2n * c[dataLength - 1];
            z2n = z2n * z2n * iz;
            for (int n = 1; n < dataLength - 1; ++n) {
                sum += (zn + z2n) * c[n];
                zn *= z;
                z2n *= iz;
            }
            sum /= 1.0 - zn * zn;
        }
        return sum;
    }

    public static double[] tableOfPoles(int splineDegree) {
        double[] pole = null;
        switch (splineDegree) {
            case 2: {
                pole = new double[]{Math.sqrt(8.0) - 3.0};
                break;
            }
            case 3: {
                pole = new double[]{Math.sqrt(3.0) - 2.0};
                break;
            }
            case 4: {
                pole = new double[]{Math.sqrt(664.0 - Math.sqrt(438976.0)) + Math.sqrt(304.0) - 19.0, Math.sqrt(664.0 + Math.sqrt(438976.0)) - Math.sqrt(304.0) - 19.0};
                break;
            }
            case 5: {
                pole = new double[]{Math.sqrt(67.5 - Math.sqrt(4436.25)) + Math.sqrt(26.25) - 6.5, Math.sqrt(67.5 + Math.sqrt(4436.25)) - Math.sqrt(26.25) - 6.5};
                break;
            }
            case 6: {
                pole = new double[]{-0.48829458930304476, -0.08167927107623751, -0.0014141518083258177};
                break;
            }
            case 7: {
                pole = new double[]{-0.5352804307964382, -0.12255461519232669, -0.009148694809608277};
                break;
            }
            default: {
                IJ.error((String)"Invalid spline degree");
            }
        }
        return pole;
    }

    public static double[] tableOfSamples(int splineDegree) {
        double[] samples = null;
        switch (splineDegree) {
            case 0: 
            case 1: {
                samples = null;
                break;
            }
            case 2: {
                samples = new double[]{0.0, 0.0};
                break;
            }
            case 3: {
                samples = new double[]{0.0, 0.0};
                break;
            }
            case 4: {
                samples = new double[]{0.0, 0.0, 0.0};
                break;
            }
            case 5: {
                samples = new double[]{0.0, 0.0, 0.0};
                break;
            }
            case 6: {
                samples = new double[]{0.0, 0.0, 0.0, 0.0};
                break;
            }
            case 7: {
                samples = new double[]{0.0, 0.0, 0.0, 0.0};
                break;
            }
            default: {
                IJ.error((String)"Invalid spline degree");
            }
        }
        return samples;
    }
}

