/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.results;

import ij.IJ;
import ij.ImagePlus;
import ij.text.TextWindow;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.math.ImageStatistics;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.numeric.RealType;
import sc.fiji.coloc.algorithms.Histogram2D;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.results.ResultHandler;
import sc.fiji.coloc.results.Warning;

public class EasyDisplay<T extends RealType<T>>
implements ResultHandler<T> {
    protected static TextWindow textWindow;
    protected DataContainer<T> container;

    public EasyDisplay(DataContainer<T> container) {
        int twWidth = 170;
        int twHeight = 250;
        if (textWindow == null || !textWindow.isVisible()) {
            textWindow = new TextWindow("Results", "Result\tValue\n", "", 170, 250);
        } else {
            textWindow.setSize(170, 250);
        }
        textWindow.setVisible(false);
        this.container = container;
    }

    @Override
    public void handleImage(RandomAccessibleInterval<T> image, String name) {
        ImagePlus imp = ImageJFunctions.wrapFloat(image, (String)name);
        double max = ((RealType)ImageStatistics.getImageMax(image)).getRealDouble();
        this.showImage(imp, max);
    }

    @Override
    public void handleHistogram(Histogram2D<T> histogram, String name) {
        ImagePlus imp = ImageJFunctions.wrapFloat(histogram.getPlotImage(), (String)name);
        double max = ImageStatistics.getImageMax(histogram.getPlotImage()).getRealDouble();
        this.showImage(imp, max);
    }

    protected void showImage(ImagePlus imp, double max) {
        imp.setDisplayRange(0.0, max);
        imp.show();
    }

    @Override
    public void handleWarning(Warning warning) {
    }

    @Override
    public void handleValue(String name, String value) {
        textWindow.getTextPanel().appendLine(name + "\t" + value + "\n");
    }

    @Override
    public void handleValue(String name, double value) {
        this.handleValue(name, value, 3);
    }

    @Override
    public void handleValue(String name, double value, int decimals) {
        this.handleValue(name, IJ.d2s((double)value, (int)decimals));
    }

    protected void printTextStatistics(DataContainer<T> container) {
        textWindow.getTextPanel().appendLine("Ch1 Mean\t" + container.getMeanCh1() + "\n");
        textWindow.getTextPanel().appendLine("Ch2 Mean\t" + container.getMeanCh2() + "\n");
        textWindow.getTextPanel().appendLine("Ch1 Min\t" + container.getMinCh1() + "\n");
        textWindow.getTextPanel().appendLine("Ch2 Min\t" + container.getMinCh2() + "\n");
        textWindow.getTextPanel().appendLine("Ch1 Max\t" + container.getMaxCh1() + "\n");
        textWindow.getTextPanel().appendLine("Ch2 Max\t" + container.getMaxCh2() + "\n");
    }

    @Override
    public void process() {
        this.printTextStatistics(this.container);
        textWindow.setVisible(true);
        IJ.selectWindow((String)"Results");
    }
}

