/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import FlowJ.FlowJException;
import FlowJ.FlowJFlow;
import bijnum.BIJJacobi;
import bijnum.BIJmatrix;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import volume.CentralDiff;
import volume.Gaussian;
import volume.Gaussian2D;
import volume.GaussianDerivative;
import volume.Kernel;
import volume.Kernel1D;
import volume.Kernel2D;
import volume.Kernel3D;
import volume.Sobel;
import volume.Sobel3D;
import volume.VolumeFloat;

public class FlowJLucas {
    public final boolean debug = false;
    public final boolean displayon = false;
    protected static final int GAUSSIANDERIV = 0;
    protected static final int CENTRALDIFF = 1;
    protected static final int SOBEL2D = 2;
    protected static final int SOBEL3D = 3;
    protected static final int SUBTRACT = 4;
    public static String[] sderiv = new String[]{"Gaussian deriv", "4 Point CD", "Sobel 2D", "Sobel 3D", "2 images diff"};
    protected float tau;
    protected Kernel1D sKernel;
    protected Kernel1D tKernel;
    protected Kernel gradientKernel;
    protected Kernel1D sgradientKernel;
    protected Kernel1D tgradientKernel;
    protected Kernel G;
    protected float density;
    protected VolumeFloat dx;
    protected VolumeFloat dy;
    protected VolumeFloat dt;
    protected final int REG_GAUSSIAN_1D = 0;
    protected final int REG_GAUSSIAN = 1;
    protected final int REG_AVERAGE = 2;
    public static String[] sregul = new String[]{"Gaussian 1D", "Gaussian", "Average 1D"};
    protected int support;
    protected boolean includeNormals;

    public static int getSupport(float sigmat, int gradientType) {
        int support = 0;
        switch (gradientType) {
            case 1: {
                CentralDiff gradientKernel = new CentralDiff();
                Gaussian tKernel = new Gaussian(sigmat);
                support = tKernel.support() + gradientKernel.support() - 1;
                break;
            }
            case 2: {
                Sobel gradientKernel = new Sobel();
                Gaussian tKernel = new Gaussian(sigmat);
                support = tKernel.support() + gradientKernel.support() - 1;
                break;
            }
            case 3: {
                Sobel3D gradientKernel = new Sobel3D();
                Gaussian tKernel = new Gaussian(sigmat);
                support = tKernel.support() + gradientKernel.support() - 1;
                break;
            }
            case 0: {
                GaussianDerivative tgradientKernel = new GaussianDerivative(sigmat);
                support = tgradientKernel.support();
                break;
            }
            case 4: {
                support = 2;
            }
        }
        return support;
    }

    public static int firstFrame(ImageStack is, float sigmat, int gradientType) {
        return FlowJLucas.getSupport(sigmat, gradientType) / 2 + 1;
    }

    public static int lastFrame(ImageStack is, float sigmat, int gradientType) {
        return is.getSize() - FlowJLucas.getSupport(sigmat, gradientType) / 2 - 1;
    }

    public void filterAll(ImageStack is, int center, float sigmat, float sigmas, int gradientType) throws FlowJException {
        VolumeFloat v = null;
        this.support = 0;
        switch (gradientType) {
            case 1: {
                this.gradientKernel = new CentralDiff();
                this.tKernel = new Gaussian(sigmat);
                this.sKernel = new Gaussian(sigmas);
                this.support = this.tKernel.support() + this.gradientKernel.support() - 1;
                break;
            }
            case 2: {
                this.gradientKernel = new Sobel();
                this.tKernel = new Gaussian(sigmat);
                this.sKernel = new Gaussian(sigmas);
                this.support = this.tKernel.support() + this.gradientKernel.support() - 1;
                break;
            }
            case 3: {
                this.gradientKernel = new Sobel3D();
                this.tKernel = new Gaussian(sigmat);
                this.sKernel = new Gaussian(sigmas);
                this.support = this.tKernel.support() + this.gradientKernel.support() - 1;
                break;
            }
            case 0: {
                this.tgradientKernel = new GaussianDerivative(sigmat);
                this.sgradientKernel = new GaussianDerivative(sigmas);
                this.tKernel = new Gaussian(sigmat);
                this.sKernel = new Gaussian(sigmas);
                this.support = this.tgradientKernel.support();
                break;
            }
            case 4: {
                this.sKernel = new Gaussian(sigmas);
                this.sgradientKernel = new GaussianDerivative(sigmas);
                this.support = 2;
            }
        }
        if (is.getSize() < this.support) {
            throw new FlowJException("Need at least " + this.support + " slices in stack.");
        }
        if (this.support > 2 && (center - 1 < this.support / 2 || center - 1 > is.getSize() - this.support / 2 - 1)) {
            throw new FlowJException("Please select the frame  > " + this.support / 2 + " and < " + (is.getSize() + 1 - this.support / 2));
        }
        this.dx = new VolumeFloat(is.getWidth(), is.getHeight(), 1);
        this.dy = new VolumeFloat(is.getWidth(), is.getHeight(), 1);
        this.dt = new VolumeFloat(is.getWidth(), is.getHeight(), 1);
        switch (gradientType) {
            case 1: 
            case 2: 
            case 3: {
                v = new VolumeFloat(is.getWidth(), is.getHeight(), this.gradientKernel.support());
                if (this.tKernel instanceof Kernel) {
                    v.convolvet(is, center, this.tKernel);
                } else {
                    v.load(is, center - this.gradientKernel.support() / 2);
                }
                if (this.sKernel instanceof Kernel) {
                    v.convolvexy(this.sKernel);
                }
                IJ.showStatus((String)("Computing " + this.gradientKernel.toString() + " derivatives..."));
                if (this.gradientKernel instanceof Kernel1D) {
                    this.dx.convolvex(v, (Kernel1D)this.gradientKernel);
                    this.dy.convolvey(v, (Kernel1D)this.gradientKernel);
                    this.dt.convolvez(v, (Kernel1D)this.gradientKernel);
                    break;
                }
                if (this.gradientKernel instanceof Kernel2D) {
                    this.dx.convolvex(v, (Kernel2D)this.gradientKernel);
                    this.dy.convolvey(v, (Kernel2D)this.gradientKernel);
                    this.dt.convolvez(v, (Kernel2D)this.gradientKernel);
                    break;
                }
                if (!(this.gradientKernel instanceof Kernel3D)) break;
                this.dx.convolvex(v, (Kernel3D)this.gradientKernel);
                this.dy.convolvey(v, (Kernel3D)this.gradientKernel);
                this.dt.convolvez(v, (Kernel3D)this.gradientKernel);
                break;
            }
            case 0: {
                IJ.showStatus((String)"Computing Gaussian derivatives...");
                this.dx.convolvet(is, center, this.tKernel);
                this.dy.convolvet(is, center, this.tKernel);
                this.dt.convolvet(is, center, this.tgradientKernel);
                VolumeFloat temp = new VolumeFloat(is.getWidth(), is.getHeight(), 1);
                temp.convolvex(this.dx, this.sgradientKernel);
                this.dx.convolvey(temp, this.sKernel);
                temp.convolvex(this.dy, this.sKernel);
                this.dy.convolvey(temp, this.sgradientKernel);
                temp.convolvex(this.dt, this.sKernel);
                this.dt.convolvey(temp, this.sKernel);
                break;
            }
            case 4: {
                v = new VolumeFloat(is.getWidth(), is.getHeight(), 2);
                v.load(is, Math.max(0, center - 1));
                if (this.sKernel instanceof Kernel) {
                    v.convolvexy(this.sKernel);
                }
                this.dx.convolvex(v, this.sgradientKernel);
                this.dy.convolvey(v, this.sgradientKernel);
                this.dt.convolvez(v);
                new ImagePlus("dx", this.dx.getImageStack()).show();
                new ImagePlus("dy", this.dy.getImageStack()).show();
                new ImagePlus("dt", this.dt.getImageStack()).show();
            }
        }
    }

    public void computeFull(FlowJFlow flow, boolean includeNormals, float sigmaw, float tau, int regularizationMethod) {
        this.includeNormals = includeNormals;
        this.tau = tau;
        VolumeFloat xt = new VolumeFloat(this.dx);
        xt.mul(this.dt);
        VolumeFloat yt = new VolumeFloat(this.dy);
        yt.mul(this.dt);
        VolumeFloat xx = new VolumeFloat(this.dx);
        xx.mul(this.dx);
        VolumeFloat yy = new VolumeFloat(this.dy);
        yy.mul(this.dy);
        VolumeFloat xy = new VolumeFloat(this.dx);
        xy.mul(this.dy);
        this.dt = null;
        this.dy = null;
        this.dx = null;
        switch (regularizationMethod) {
            case 1: {
                this.G = new Gaussian2D(sigmaw);
                xt.convolvexy((Kernel2D)this.G);
                yt.convolvexy((Kernel2D)this.G);
                xx.convolvexy((Kernel2D)this.G);
                yy.convolvexy((Kernel2D)this.G);
                xy.convolvexy((Kernel2D)this.G);
                break;
            }
            case 0: {
                this.G = new Gaussian(sigmaw);
                xt.convolvexy((Kernel1D)this.G);
                yt.convolvexy((Kernel1D)this.G);
                xx.convolvexy((Kernel1D)this.G);
                yy.convolvexy((Kernel1D)this.G);
                xy.convolvexy((Kernel1D)this.G);
                break;
            }
            default: {
                this.G = new Gaussian(5);
                xt.convolvexy((Kernel1D)this.G);
                yt.convolvexy((Kernel1D)this.G);
                xx.convolvexy((Kernel1D)this.G);
                yy.convolvexy((Kernel1D)this.G);
                xy.convolvexy((Kernel1D)this.G);
            }
        }
        int total = 0;
        int full = 0;
        int normals = 0;
        flow.v.setEdge(xx.getEdge());
        for (int y = 0; y < xx.getHeight(); ++y) {
            IJ.showProgress((double)((float)y / (float)xx.getHeight()));
            for (int x = 0; x < xx.getWidth(); ++x) {
                flow.set(x, y, 0.0f, 0.0f, false);
                if (!xx.valid(x, y)) continue;
                float[] b = new float[2];
                float[][] m = new float[2][2];
                m[0][0] = xx.v[0][y][x];
                m[0][1] = xy.v[0][y][x];
                m[1][0] = xy.v[0][y][x];
                m[1][1] = yy.v[0][y][x];
                b[0] = xt.v[0][y][x];
                b[1] = yt.v[0][y][x];
                float[][] mi = null;
                BIJJacobi j = null;
                try {
                    float[] v;
                    mi = BIJmatrix.inverse(m);
                    j = new BIJJacobi(m, true);
                    j.compute();
                    j.sort();
                    if (j.eigenvalues[0] >= tau && j.eigenvalues[1] >= tau) {
                        if (BIJmatrix.determinant(m) > 0.0f) {
                            v = BIJmatrix.mul(mi, b);
                            flow.set(x, y, -v[0], v[1], true);
                            ++full;
                        }
                    } else if (includeNormals && j.eigenvalues[0] > tau && (double)Math.abs(BIJmatrix.determinant(m)) > 1.0E-8) {
                        v = BIJmatrix.mul(mi, b);
                        float[] ff = new float[]{(v[0] * j.eigenvectors[0][0] + v[1] * j.eigenvectors[1][0]) * j.eigenvectors[1][0], (-v[0] * j.eigenvectors[0][0] - v[1] * j.eigenvectors[1][0]) * j.eigenvectors[0][0]};
                        flow.set(x, y, ff[0], ff[1], true);
                        ++normals;
                    }
                }
                catch (Exception e) {
                    IJ.log((String)("Inverse or Jacobi error " + e));
                }
                ++total;
            }
        }
        this.density = (float)full / (float)total;
    }

    public String toString() {
        String s = "LK ";
        if (this.sKernel instanceof Kernel) {
            s = s + "s" + this.sKernel.toString();
        }
        if (this.tKernel instanceof Kernel) {
            s = s + " t" + this.tKernel.toString();
        }
        s = s + " w" + this.G.toString() + " tau" + this.tau + " ";
        s = this.gradientKernel instanceof Kernel ? s + this.gradientKernel.toString() : (this.tgradientKernel instanceof Kernel ? s + " Gaussian diff " : s + " diff ");
        s = s + " (" + IJ.d2s((double)(this.density * 100.0f), (int)2) + "%)" + (this.includeNormals ? " (w. normals) " : "") + "(support=" + this.support + ")";
        return s;
    }
}

