/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJClassifier;
import VolumeJ.VJClassifierIsosurface;
import volume.Volume;
import volume.VolumeFloat;
import volume.VolumeRGB;
import volume.VolumeShort;

public class VJThresholdedVolume
extends Volume {
    public boolean[] v;

    public VJThresholdedVolume() {
    }

    public VJThresholdedVolume(Volume v, VJClassifier classifier) {
        if (v instanceof VolumeShort) {
            this.threshold((VolumeShort)v, (VJClassifierIsosurface)classifier);
        } else if (v instanceof VolumeRGB) {
            this.threshold((VolumeRGB)v, (VJClassifierIsosurface)classifier);
        } else if (v instanceof VolumeFloat) {
            this.threshold((VolumeFloat)v, (VJClassifierIsosurface)classifier);
        }
    }

    private void threshold(VolumeShort v, VJClassifierIsosurface classifier) {
        this.depth = v.getDepth();
        this.height = v.getHeight();
        this.width = v.getWidth();
        this.v = new boolean[this.depth * this.height * this.width];
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[z * this.height * this.width + y * this.width + x] = classifier.overThreshold(v.v[z][y][x]);
                }
            }
        }
    }

    private void threshold(VolumeRGB v, VJClassifierIsosurface classifier) {
        this.depth = v.getDepth();
        this.height = v.getHeight();
        this.width = v.getWidth();
        this.v = new boolean[this.depth * this.height * this.width];
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[z * this.height * this.width + y * this.width + x] = classifier.overThreshold(v.b[z * this.height * this.width + y * this.width + x] & 0xFF);
                }
            }
        }
    }

    private void threshold(VolumeFloat v, VJClassifierIsosurface classifier) {
        this.depth = v.getDepth();
        this.height = v.getHeight();
        this.width = v.getWidth();
        this.v = new boolean[this.depth * this.height * this.width];
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[z * this.height * this.width + y * this.width + x] = classifier.overThreshold(v.v[z][y][x]);
                }
            }
        }
    }

    @Override
    public Object get(int x, int y, int z) {
        return new Boolean(this.v[z * this.height * this.width + y * this.width + x]);
    }

    @Override
    public void set(Object value, int x, int y, int z) {
        this.v[z * this.height * this.width + y * this.width + x] = (Boolean)value;
    }
}

