/*
 * Decompiled with CFR 0.152.
 */
package volume;

import ij.IJ;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import volume.Kernel1D;
import volume.Volume;

public class VolumeShort
extends Volume {
    public short[][][] v;
    private boolean indexed = false;

    public VolumeShort() {
        this(0, 0, 0);
    }

    public VolumeShort(int width, int height, int depth, double aspectx, double aspecty, double aspectz) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.v = new short[depth][height][width];
        this.setAspects(aspectx, aspecty, aspectz);
        this.edge = 0;
    }

    public VolumeShort(int width, int height, int depth) {
        this(width, height, depth, 1.0, 1.0, 1.0);
    }

    public VolumeShort(VolumeShort v1) {
        this(v1.getWidth(), v1.getHeight(), v1.getDepth(), v1.getAspectx(), v1.getAspecty(), v1.getAspectz());
        this.copy(v1.v);
    }

    public VolumeShort(ImageStack s, double aspectx, double aspecty, double aspectz) throws Exception {
        this(s.getWidth(), s.getHeight(), s.getSize(), aspectx, aspecty, aspectz);
        if (!this.load(s, 0)) {
            throw new Exception("Cannot instantiate volume from ImageStack");
        }
    }

    public VolumeShort(ImageStack s) throws Exception {
        this(s, 1.0, 1.0, 1.0);
    }

    public VolumeShort(ImageProcessor ip) {
        this(ip.getWidth(), ip.getHeight(), 1, 1.0, 1.0, 1.0);
        this.load(ip, 0);
    }

    public VolumeShort(ImageStack s, int depth, int n) {
        this(s, depth, n, 1.0, 1.0, 1.0);
    }

    public VolumeShort(ImageStack s, int depth, int n, double aspectx, double aspecty, double aspectz) {
        this(s.getWidth(), s.getHeight(), depth, aspectx, aspecty, aspectz);
        this.load(s, n * depth);
    }

    @Override
    public Object get(int x, int y, int z) {
        return new Short(this.v[z][y][x]);
    }

    @Override
    public void set(Object value, int x, int y, int z) {
        this.v[z][y][x] = ((Number)value).shortValue();
    }

    @Deprecated
    public void set(int x, int y, int z, int value) {
        this.v[z][y][x] = (short)value;
    }

    public boolean load(ImageStack s, int start) {
        if (!(s.getImageArray()[0] instanceof byte[]) && !(s.getImageArray()[0] instanceof short[])) {
            IJ.error((String)"VolumeShort: can only convert 8- and 16-bit images.");
            return false;
        }
        for (int t = start; t < start + this.depth; ++t) {
            this.loadSlice(this.v[t - start], s, t + 1);
        }
        return true;
    }

    public void load(ImageProcessor ip, int t) {
        if (ip instanceof ByteProcessor) {
            this.loadImage(this.v[t], (byte[])ip.getPixels());
        } else if (ip instanceof ShortProcessor) {
            this.loadImage(this.v[t], (short[])ip.getPixels());
        } else {
            IJ.error((String)"load: image type not supported.");
        }
    }

    public void loadInverse(ImageStack s, int center) {
        for (int t = -this.depth / 2; t <= this.depth / 2; ++t) {
            short[][] t1 = new short[this.height][this.width];
            this.loadSlice(t1, s, center + this.depth / 2 - t);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t + this.depth / 2][y][x] = t1[y][x];
                }
            }
        }
    }

    protected void loadSlice(short[][] i, ImageStack s, int io) {
        if (io < 1 || io > s.getSize()) {
            IJ.error((String)("loadSlice: slice index out of bounds (" + io + "><1-" + s.getSize() + ")"));
            return;
        }
        Object[] stack = s.getImageArray();
        if (stack[0] instanceof byte[]) {
            this.loadImage(i, (byte[])s.getPixels(io));
        } else if (stack[0] instanceof short[]) {
            this.loadImage(i, (short[])s.getPixels(io));
        } else {
            IJ.error((String)"loadSlice: image type not supported.");
        }
    }

    protected void loadImage(short[][] i, byte[] b) {
        for (int y = 0; y < this.height; ++y) {
            int offset = y * this.width;
            for (int x = 0; x < this.width; ++x) {
                i[y][x] = (short)(b[offset + x] & 0xFF);
            }
        }
    }

    protected void loadImage(short[][] i, short[] sh) {
        for (int y = 0; y < this.height; ++y) {
            int offset = y * this.width;
            for (int x = 0; x < this.width; ++x) {
                i[y][x] = sh[offset + x];
            }
        }
    }

    public void setHighBits(ImageStack s) {
        for (int t = 0; t < this.depth; ++t) {
            byte[] pixels = (byte[])s.getPixels(t + 1);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    short[] sArray = this.v[t][y];
                    int n = x;
                    sArray[n] = (short)(sArray[n] | pixels[y * this.width + x] << 8 & 0xFF00);
                }
            }
        }
        this.indexed = true;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public boolean getIndexed() {
        return this.indexed;
    }

    public void convolvexyz(Kernel1D kernel) {
        int k;
        double s;
        int x;
        int y;
        int z;
        if (kernel.halfwidth > this.edge) {
            this.edge = kernel.halfwidth;
        }
        VolumeShort t1 = new VolumeShort(this);
        for (z = 0; z < this.depth; ++z) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    s = 0.0;
                    if (this.valid(x, y, z)) {
                        for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                            s += (double)t1.v[z][y][x + k] * kernel.k[k + kernel.halfwidth];
                        }
                    }
                    this.v[z][y][x] = (short)s;
                }
            }
        }
        for (z = 0; z < this.depth; ++z) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    s = 0.0;
                    if (this.valid(x, y, z)) {
                        for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                            s += (double)this.v[z][y + k][x] * kernel.k[k + kernel.halfwidth];
                        }
                    }
                    this.v[z][y][x] = (short)s;
                }
            }
        }
        for (z = 0; z < this.depth; ++z) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    s = 0.0;
                    if (this.valid(x, y, z)) {
                        for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                            s += (double)t1.v[z + k][y][x] * kernel.k[k + kernel.halfwidth];
                        }
                    }
                    this.v[z][y][x] = (short)s;
                }
            }
        }
    }

    private void copy(short[][][] v1) {
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t][y][x] = v1[t][y][x];
                }
            }
        }
    }
}

